/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.mysql.MysqlConnectionImpl;
import com.caucho.quercus.mysql.MysqlResultImpl;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlStatementImpl
implements Statement {
    private static final Logger log = Logger.getLogger(MysqlStatementImpl.class.getName());
    private static final L10N L = new L10N(MysqlStatementImpl.class);
    private MysqlConnectionImpl _conn;
    private MysqlResultImpl _result;

    MysqlStatementImpl(MysqlConnectionImpl conn) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        this._conn = conn;
        this._result = new MysqlResultImpl(this);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this._conn.writeQuery(sql);
        this._conn.readResult(this._result);
        return this._result.isResultSet();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this._conn.writeQuery(sql);
        this._conn.readResult(this._result);
        return this._result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this._conn.writeQuery(sql);
        this._conn.readResult(this._result);
        return this._result.getUpdateCount();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._result;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._result.getUpdateCount();
    }

    @Override
    public MysqlConnectionImpl getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._conn == null;
    }

    @Override
    public void close() throws SQLException {
        this._conn = null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int executeUpdate(String query, int resultType) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int executeUpdate(String query, int[] columns) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int executeUpdate(String query, String[] columns) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean execute(String query, int resultType) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean execute(String query, int[] columns) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean execute(String query, String[] columns) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public boolean getMoreResults(int count) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void setPoolable(boolean isPoolable) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._conn + "]";
    }
}

