/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.annotation.Construct;
import com.caucho.quercus.annotation.Delegates;
import com.caucho.quercus.annotation.EntrySet;
import com.caucho.quercus.annotation.Hide;
import com.caucho.quercus.annotation.JsonEncode;
import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.env.AbstractJavaMethod;
import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.BigDecimalValue;
import com.caucho.quercus.env.BigIntegerValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.CountDelegate;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaCalendarValue;
import com.caucho.quercus.env.JavaConstructor;
import com.caucho.quercus.env.JavaDateValue;
import com.caucho.quercus.env.JavaMethod;
import com.caucho.quercus.env.JavaResourceValue;
import com.caucho.quercus.env.JavaURLValue;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.LiteralExpr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.marshal.JavaMarshal;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.marshal.MarshalFactory;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.FunctionArrayDelegate;
import com.caucho.quercus.program.JavaCollectionClassDef;
import com.caucho.quercus.program.JavaListClassDef;
import com.caucho.quercus.program.JavaMapClassDef;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassDef
extends ClassDef {
    private static final Logger log = Logger.getLogger(JavaClassDef.class.getName());
    private static final L10N L = new L10N(JavaClassDef.class);
    private final ModuleContext _moduleContext;
    private final String _name;
    private final Class _type;
    private QuercusClass _quercusClass;
    private HashSet<String> _instanceOfSet;
    private HashSet<String> _instanceOfSetLowerCase;
    private final boolean _isAbstract;
    private final boolean _isInterface;
    private final boolean _isDelegate;
    private boolean _isPhpClass;
    private String _resourceType;
    private JavaClassDef _componentDef;
    protected volatile boolean _isInit;
    private final HashMap<String, Value> _constMap = new HashMap();
    private final HashMap<String, Object> _constJavaMap = new HashMap();
    private final MethodMap<AbstractJavaMethod> _functionMap = new MethodMap(null, this);
    private final HashMap<StringValue, AbstractJavaMethod> _getMap = new HashMap();
    private final HashMap<StringValue, AbstractJavaMethod> _setMap = new HashMap();
    private final HashMap<StringValue, FieldMarshalPair> _fieldMap = new HashMap();
    private AbstractJavaMethod _cons;
    private AbstractJavaMethod __construct;
    private JavaMethod __fieldGet;
    private JavaMethod __fieldSet;
    private FunctionArrayDelegate _funArrayDelegate;
    private ArrayDelegate _arrayDelegate;
    private JavaMethod __call;
    private JavaMethod __toString;
    private Method _printRImpl;
    private Method _varDumpImpl;
    private Method _jsonEncode;
    private Method _entrySet;
    private TraversableDelegate _traversableDelegate;
    private CountDelegate _countDelegate;
    private Method _iteratorMethod;
    private Marshal _marshal;
    private String _extension;

    public JavaClassDef(ModuleContext moduleContext, String name, Class type) {
        super(null, name, null, new String[0]);
        this._moduleContext = moduleContext;
        this._name = name;
        this._type = type;
        this._isAbstract = Modifier.isAbstract(type.getModifiers());
        this._isInterface = type.isInterface();
        this._isDelegate = type.isAnnotationPresent(ClassImplementation.class);
        if (type.isArray() && !this.isArray()) {
            throw new IllegalStateException(L.l("'{0}' needs to be called with JavaArrayClassDef", type));
        }
    }

    public JavaClassDef(ModuleContext moduleContext, String name, Class type, String extension) {
        this(moduleContext, name, type);
        this._extension = extension;
        moduleContext.addExtensionClass(extension, name);
    }

    private void fillInstanceOfSet(Class type, boolean isTop) {
        if (type == null) {
            return;
        }
        if (isTop && this._isDelegate) {
            this._instanceOfSet.add(this._name);
            this._instanceOfSetLowerCase.add(this._name.toLowerCase());
        } else {
            String name = type.getSimpleName();
            this._instanceOfSet.add(name);
            this._instanceOfSetLowerCase.add(name.toLowerCase());
        }
        this.fillInstanceOfSet(type.getSuperclass(), false);
        Class<?>[] ifaceList = type.getInterfaces();
        if (ifaceList != null) {
            for (Class<?> iface : ifaceList) {
                this.fillInstanceOfSet(iface, false);
            }
        }
    }

    public static JavaClassDef create(ModuleContext moduleContext, String name, Class<?> type) {
        if (Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return new DoubleClassDef(moduleContext);
        }
        if (Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
            return new LongClassDef(moduleContext);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return new BigDecimalClassDef(moduleContext);
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BigIntegerClassDef(moduleContext);
        }
        if (String.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return new StringClassDef(moduleContext);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return new BooleanClassDef(moduleContext);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return new CalendarClassDef(moduleContext);
        }
        if (Date.class.isAssignableFrom(type)) {
            return new DateClassDef(moduleContext);
        }
        if (URL.class.isAssignableFrom(type)) {
            return new URLClassDef(moduleContext);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new JavaMapClassDef(moduleContext, name, type);
        }
        if (List.class.isAssignableFrom(type)) {
            return new JavaListClassDef(moduleContext, name, type);
        }
        if (Collection.class.isAssignableFrom(type) && !Queue.class.isAssignableFrom(type)) {
            return new JavaCollectionClassDef(moduleContext, name, type);
        }
        return null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getSimpleName() {
        return this._type.getSimpleName();
    }

    public Class getType() {
        return this._type;
    }

    public String getResourceType() {
        return this._resourceType;
    }

    protected ModuleContext getModuleContext() {
        return this._moduleContext;
    }

    @Override
    public String getExtension() {
        return this._extension;
    }

    @Override
    public boolean isA(String name) {
        if (this._instanceOfSet == null) {
            this._instanceOfSet = new HashSet();
            this._instanceOfSetLowerCase = new HashSet();
            this.fillInstanceOfSet(this._type, true);
        }
        return this._instanceOfSet.contains(name) || this._instanceOfSetLowerCase.contains(name.toLowerCase());
    }

    @Override
    public void addInterfaces(HashSet<String> interfaceSet) {
        this.addInterfaces(interfaceSet, this._type, true);
    }

    protected void addInterfaces(HashSet<String> interfaceSet, Class type, boolean isTop) {
        if (type == null) {
            return;
        }
        interfaceSet.add(this._name.toLowerCase());
        interfaceSet.add(type.getSimpleName().toLowerCase());
        if (type.getInterfaces() != null) {
            for (Class<?> iface : type.getInterfaces()) {
                this.addInterfaces(interfaceSet, iface, false);
            }
        }
        this.addInterfaces(interfaceSet, type.getSuperclass(), false);
    }

    private boolean hasInterface(String name, Class type) {
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            for (Class<?> intfc : interfaces) {
                if (intfc.getSimpleName().equalsIgnoreCase(name)) {
                    return true;
                }
                if (!this.hasInterface(name, intfc)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return this._isInterface;
    }

    public boolean isDelegate() {
        return this._isDelegate;
    }

    public void setPhpClass(boolean isPhpClass) {
        this._isPhpClass = isPhpClass;
    }

    public boolean isPhpClass() {
        return this._isPhpClass;
    }

    public JavaClassDef getComponentDef() {
        if (this._componentDef == null) {
            Class<?> compType = this.getType().getComponentType();
            this._componentDef = this._moduleContext.getJavaClassDefinition(compType.getName());
        }
        return this._componentDef;
    }

    public Value wrap(Env env, Object obj) {
        if (!this._isInit) {
            this.init();
        }
        if (this._resourceType != null) {
            return new JavaResourceValue(env, obj, this);
        }
        return new JavaValue(env, obj, this);
    }

    private int cmpObject(Object lValue, Object rValue) {
        if (lValue == rValue) {
            return 0;
        }
        if (lValue == null) {
            return -1;
        }
        if (rValue == null) {
            return 1;
        }
        if (lValue instanceof Comparable) {
            if (!(rValue instanceof Comparable)) {
                return -1;
            }
            return ((Comparable)lValue).compareTo(rValue);
        }
        if (rValue instanceof Comparable) {
            return 1;
        }
        if (lValue.equals(rValue)) {
            return 0;
        }
        String lName = lValue.getClass().getName();
        String rName = rValue.getClass().getName();
        return lName.compareTo(rName);
    }

    public int cmpObject(Object lValue, Object rValue, JavaClassDef rClassDef) {
        int cmp = this.cmpObject(lValue, rValue);
        if (cmp != 0) {
            return cmp;
        }
        for (Map.Entry<StringValue, FieldMarshalPair> lEntry : this._fieldMap.entrySet()) {
            StringValue lFieldName = lEntry.getKey();
            FieldMarshalPair rFieldPair = rClassDef._fieldMap.get(lFieldName);
            if (rFieldPair == null) {
                return 1;
            }
            FieldMarshalPair lFieldPair = lEntry.getValue();
            try {
                Object rResult;
                Object lResult = lFieldPair._field.get(lValue);
                int resultCmp = this.cmpObject(lResult, rResult = rFieldPair._field.get(lValue));
                if (resultCmp == 0) continue;
                return resultCmp;
            }
            catch (IllegalAccessException e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return 0;
            }
        }
        return 0;
    }

    public Value getField(Env env, Value qThis, StringValue name) {
        AbstractJavaMethod get = this._getMap.get(name);
        if (get != null) {
            try {
                return get.callMethod(env, this.getQuercusClass(), qThis);
            }
            catch (Exception e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return null;
            }
        }
        FieldMarshalPair fieldPair = this._fieldMap.get(name);
        if (fieldPair != null) {
            try {
                Object result = fieldPair._field.get(qThis.toJavaObject());
                return fieldPair._marshal.unmarshal(env, result);
            }
            catch (Exception e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return null;
            }
        }
        AbstractFunction phpGet = qThis.getQuercusClass().getFieldGet();
        if (phpGet != null) {
            return phpGet.callMethod(env, this.getQuercusClass(), qThis, (Value)name);
        }
        if (this.__fieldGet != null) {
            try {
                return this.__fieldGet.callMethod(env, this.getQuercusClass(), qThis, (Value)name);
            }
            catch (Exception e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value putField(Env env, Value qThis, StringValue name, Value value) {
        AbstractFunction phpSet;
        AbstractJavaMethod setter = this._setMap.get(name);
        if (setter != null) {
            try {
                return setter.callMethod(env, this.getQuercusClass(), qThis, value);
            }
            catch (Exception e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        FieldMarshalPair fieldPair = this._fieldMap.get(name);
        if (fieldPair != null) {
            try {
                Class<?> type = fieldPair._field.getType();
                Object marshaledValue = fieldPair._marshal.marshal(env, value, type);
                fieldPair._field.set(qThis.toJavaObject(), marshaledValue);
                return value;
            }
            catch (Exception e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        if (!qThis.isFieldInit() && (phpSet = qThis.getQuercusClass().getFieldSet()) != null) {
            qThis.setFieldInit(true);
            try {
                Value value2 = phpSet.callMethod(env, this.getQuercusClass(), qThis, (Value)name, value);
                return value2;
            }
            finally {
                qThis.setFieldInit(false);
            }
        }
        if (this.__fieldSet != null) {
            try {
                return this.__fieldSet.callMethod(env, this.getQuercusClass(), qThis, (Value)name, value);
            }
            catch (Exception e) {
                log.log(Level.FINE, L.l(e.getMessage()), e);
                return NullValue.NULL;
            }
        }
        return null;
    }

    public Marshal getMarshal() {
        return this._marshal;
    }

    @Override
    public ObjectValue newInstance(Env env, QuercusClass qClass) {
        return null;
    }

    public Value newInstance() {
        return null;
    }

    @Override
    public Value callNew(Env env, Value[] args) {
        if (this._cons != null) {
            if (this.__construct != null) {
                Value value = this._cons.call(env, Value.NULL_ARGS);
                this.__construct.callMethod(env, this.__construct.getQuercusClass(), value, args);
                return value;
            }
            return this._cons.call(env, args);
        }
        if (this.__construct != null) {
            return this.__construct.call(env, args);
        }
        return NullValue.NULL;
    }

    public AbstractFunction getCallMethod() {
        return this.__call;
    }

    @Override
    public AbstractFunction getCall() {
        return this.__call;
    }

    public AbstractFunction findFunction(StringValue methodName) {
        return this._functionMap.getRaw(methodName);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value[] args) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, args);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2, a3);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2, a3, a4);
    }

    public Value callMethod(Env env, Value qThis, StringValue methodName, int hash, Value a1, Value a2, Value a3, Value a4, Value a5) {
        AbstractFunction fun = this._functionMap.get(methodName, hash);
        return fun.callMethod(env, this.getQuercusClass(), qThis, a1, a2, a3, a4, a5);
    }

    public Set<? extends Map.Entry<Value, Value>> entrySet(Object obj) {
        try {
            if (this._entrySet == null) {
                return null;
            }
            return (Set)this._entrySet.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new QuercusException(e);
        }
    }

    @Override
    public void initClass(QuercusClass cl) {
        this.init();
        if (this._cons != null) {
            cl.setConstructor(this._cons);
            cl.addMethod(new StringBuilderValue("__construct"), (AbstractFunction)this._cons);
        }
        if (this.__construct != null) {
            cl.setConstructor(this.__construct);
            cl.addMethod(new StringBuilderValue("__construct"), (AbstractFunction)this.__construct);
        }
        for (AbstractJavaMethod abstractJavaMethod : this._functionMap.values()) {
            cl.addMethod(new StringBuilderValue(abstractJavaMethod.getName()), (AbstractFunction)abstractJavaMethod);
        }
        if (this.__fieldGet != null) {
            cl.setFieldGet(this.__fieldGet);
        }
        if (this.__fieldSet != null) {
            cl.setFieldSet(this.__fieldSet);
        }
        if (this.__call != null) {
            cl.setCall(this.__call);
        }
        if (this.__toString != null) {
            cl.addMethod(new StringBuilderValue("__toString"), (AbstractFunction)this.__toString);
        }
        if (this._arrayDelegate != null) {
            cl.setArrayDelegate(this._arrayDelegate);
        } else if (this._funArrayDelegate != null) {
            cl.setArrayDelegate(this._funArrayDelegate);
        }
        if (this._traversableDelegate != null) {
            cl.setTraversableDelegate(this._traversableDelegate);
        } else if (cl.getTraversableDelegate() == null && this._iteratorMethod != null) {
            cl.setTraversableDelegate(new JavaTraversableDelegate(this._iteratorMethod));
        }
        if (this._countDelegate != null) {
            cl.setCountDelegate(this._countDelegate);
        }
        for (Map.Entry entry : this._constMap.entrySet()) {
            cl.addConstant((String)entry.getKey(), new LiteralExpr((Value)entry.getValue()));
        }
        for (Map.Entry entry : this._constJavaMap.entrySet()) {
            cl.addJavaConstant((String)entry.getKey(), entry.getValue());
        }
    }

    public Value findConstant(Env env, String name) {
        return this._constMap.get(name);
    }

    public void initInstance(Env env, Value value) {
    }

    public QuercusClass getQuercusClass() {
        if (this._quercusClass == null) {
            this.init();
            this._quercusClass = new QuercusClass(this._moduleContext, this, null);
        }
        return this._quercusClass;
    }

    @Override
    public AbstractFunction findConstructor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init() {
        if (this._isInit) {
            return;
        }
        JavaClassDef javaClassDef = this;
        synchronized (javaClassDef) {
            if (this._isInit) {
                return;
            }
            super.init();
            try {
                this.initInterfaceList(this._type);
                this.introspect();
            }
            finally {
                this._isInit = true;
            }
        }
    }

    private void initInterfaceList(Class type) {
        Class<?>[] ifaces = type.getInterfaces();
        if (ifaces == null) {
            return;
        }
        for (Class<?> iface : ifaces) {
            JavaClassDef javaClassDef = this._moduleContext.getJavaClassDefinition(iface);
            if (javaClassDef != null) {
                this.addInterface(javaClassDef.getName());
            }
            this.initInterfaceList(iface);
        }
    }

    private void introspect() {
        this.introspectConstants(this._type);
        this.introspectMethods(this._moduleContext, this._type);
        this.introspectFields(this._moduleContext, this._type);
        this._marshal = new JavaMarshal(this, false);
        AbstractJavaMethod consMethod = this.getConsMethod();
        if (consMethod != null) {
            if (consMethod.isStatic()) {
                this._cons = consMethod;
            } else {
                this.__construct = consMethod;
            }
        }
        if (this._cons == null) {
            Constructor<?>[] cons = this._type.getConstructors();
            if (cons.length > 0) {
                int i;
                for (i = 0; i < cons.length && !cons[i].isAnnotationPresent(Construct.class); ++i) {
                }
                if (i < cons.length) {
                    this._cons = new JavaConstructor(this._moduleContext, cons[i]);
                } else {
                    this._cons = new JavaConstructor(this._moduleContext, cons[0]);
                    for (i = 1; i < cons.length; ++i) {
                        this._cons = this._cons.overload(new JavaConstructor(this._moduleContext, cons[i]));
                    }
                }
            } else {
                this._cons = null;
            }
        }
        if (this._cons != null) {
            this._cons.setConstructor(true);
        }
        if (this.__construct != null) {
            this.__construct.setConstructor(true);
        }
        this.introspectAnnotations(this._type);
    }

    private void introspectAnnotations(Class type) {
        try {
            if (type == null) {
                return;
            }
            for (Class<?> iface : type.getInterfaces()) {
                this.introspectAnnotations(iface);
            }
            this.introspectAnnotations(type.getSuperclass());
            for (Annotation annotation : type.getAnnotations()) {
                if (annotation.annotationType() == Delegates.class) {
                    Class<?>[] delegateClasses;
                    for (Class<?> cl : delegateClasses = ((Delegates)annotation).value()) {
                        boolean isDelegate = this.addDelegate(cl);
                        if (isDelegate) continue;
                        throw new IllegalArgumentException(L.l("unknown @Delegate class '{0}'", cl));
                    }
                    continue;
                }
                if (annotation.annotationType() != ResourceType.class) continue;
                this._resourceType = ((ResourceType)annotation).value();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InstantiationException e) {
            throw new QuercusModuleException(e.getCause());
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    private boolean addDelegate(Class cl) throws InstantiationException, IllegalAccessException {
        boolean isDelegate = false;
        if (TraversableDelegate.class.isAssignableFrom(cl)) {
            this._traversableDelegate = (TraversableDelegate)cl.newInstance();
            isDelegate = true;
        }
        if (ArrayDelegate.class.isAssignableFrom(cl)) {
            this._arrayDelegate = (ArrayDelegate)cl.newInstance();
            isDelegate = true;
        }
        if (CountDelegate.class.isAssignableFrom(cl)) {
            this._countDelegate = (CountDelegate)cl.newInstance();
            isDelegate = true;
        }
        return isDelegate;
    }

    private <T> boolean addDelegate(Class<T> cl, ArrayList<T> delegates, Class<? extends Object> delegateClass) {
        if (!cl.isAssignableFrom(delegateClass)) {
            return false;
        }
        for (T delegate : delegates) {
            if (delegate.getClass() != delegateClass) continue;
            return true;
        }
        try {
            delegates.add(delegateClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new QuercusModuleException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusModuleException(e);
        }
        return true;
    }

    private AbstractJavaMethod getConsMethod() {
        for (AbstractJavaMethod method : this._functionMap.values()) {
            if (!method.getName().equals("__construct")) continue;
            return method;
        }
        return null;
    }

    private void introspectFields(ModuleContext moduleContext, Class type) {
        Field[] fields;
        Method[] methods;
        if (type == null) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Method method : methods = type.getMethods()) {
            AbstractJavaMethod newGetter;
            AbstractJavaMethod existingGetter;
            StringValue quercusName;
            String methodName;
            int length;
            if (Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(Hide.class) || (length = (methodName = method.getName()).length()) <= 3) continue;
            if (methodName.startsWith("get")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(3, length));
                existingGetter = this._getMap.get(quercusName);
                newGetter = new JavaMethod(moduleContext, method);
                if (existingGetter != null) {
                    newGetter = existingGetter.overload(newGetter);
                }
                this._getMap.put(quercusName, newGetter);
                continue;
            }
            if (methodName.startsWith("is")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(2, length));
                existingGetter = this._getMap.get(quercusName);
                newGetter = new JavaMethod(moduleContext, method);
                if (existingGetter != null) {
                    newGetter = existingGetter.overload(newGetter);
                }
                this._getMap.put(quercusName, newGetter);
                continue;
            }
            if (methodName.startsWith("set")) {
                quercusName = this.javaToQuercusConvert(methodName.substring(3, length));
                AbstractJavaMethod existingSetter = this._setMap.get(quercusName);
                AbstractJavaMethod newSetter = new JavaMethod(moduleContext, method);
                if (existingSetter != null) {
                    newSetter = existingSetter.overload(newSetter);
                }
                this._setMap.put(quercusName, newSetter);
                continue;
            }
            if ("__get".equals(methodName)) {
                if (this._funArrayDelegate == null) {
                    this._funArrayDelegate = new FunctionArrayDelegate();
                }
                this._funArrayDelegate.setArrayGet(new JavaMethod(moduleContext, method));
                continue;
            }
            if ("__set".equals(methodName)) {
                if (this._funArrayDelegate == null) {
                    this._funArrayDelegate = new FunctionArrayDelegate();
                }
                this._funArrayDelegate.setArrayPut(new JavaMethod(moduleContext, method));
                continue;
            }
            if ("__getField".equals(methodName)) {
                this.__fieldGet = new JavaMethod(moduleContext, method);
                continue;
            }
            if ("__setField".equals(methodName)) {
                this.__fieldSet = new JavaMethod(moduleContext, method);
                continue;
            }
            if ("__fieldGet".equals(methodName)) {
                this.__fieldGet = new JavaMethod(moduleContext, method);
                continue;
            }
            if (!"__fieldSet".equals(methodName)) continue;
            this.__fieldSet = new JavaMethod(moduleContext, method);
        }
        for (Field field : fields = type.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Hide.class)) continue;
            MarshalFactory factory = moduleContext.getMarshalFactory();
            Marshal marshal = factory.create(field.getType(), false);
            this._fieldMap.put(new ConstStringValue(field.getName()), new FieldMarshalPair(field, marshal));
        }
    }

    private StringValue javaToQuercusConvert(String s) {
        if (s.length() == 1) {
            return new ConstStringValue(new char[]{Character.toLowerCase(s.charAt(0))});
        }
        if (Character.isUpperCase(s.charAt(1))) {
            return new ConstStringValue(s);
        }
        StringBuilderValue sb = new StringBuilderValue();
        sb.append(Character.toLowerCase(s.charAt(0)));
        int length = s.length();
        for (int i = 1; i < length; ++i) {
            sb.append(s.charAt(i));
        }
        return sb;
    }

    private void introspectConstants(Class type) {
        Field[] fields;
        if (type == null) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        for (Field field : fields = type.getFields()) {
            if (this._constMap.get(field.getName()) != null || this._constJavaMap.get(field.getName()) != null || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || field.isAnnotationPresent(Hide.class)) continue;
            try {
                Object obj = field.get(null);
                Value value = QuercusContext.objectToValue(obj);
                if (value != null) {
                    this._constMap.put(field.getName().intern(), value);
                    continue;
                }
                this._constJavaMap.put(field.getName().intern(), obj);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    private void introspectMethods(ModuleContext moduleContext, Class<?> type) {
        Method[] methods;
        if (type == null) {
            return;
        }
        for (Method method : methods = type.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.isAnnotationPresent(Hide.class) || this._isPhpClass && method.getDeclaringClass() == Object.class) continue;
            if ("iterator".equals(method.getName()) && method.getParameterTypes().length == 0 && Iterator.class.isAssignableFrom(method.getReturnType())) {
                this._iteratorMethod = method;
            }
            if ("printRImpl".equals(method.getName())) {
                this._printRImpl = method;
                continue;
            }
            if ("varDumpImpl".equals(method.getName())) {
                this._varDumpImpl = method;
                continue;
            }
            if (method.isAnnotationPresent(JsonEncode.class)) {
                this._jsonEncode = method;
                continue;
            }
            if (method.isAnnotationPresent(EntrySet.class)) {
                this._entrySet = method;
                continue;
            }
            if ("__call".equals(method.getName())) {
                this.__call = new JavaMethod(moduleContext, method);
                continue;
            }
            if ("__toString".equals(method.getName())) {
                this.__toString = new JavaMethod(moduleContext, method);
                continue;
            }
            if (method.getName().startsWith("quercus_")) {
                throw new UnsupportedOperationException(L.l("{0}: use @Name instead", method.getName()));
            }
            JavaMethod newFun = new JavaMethod(moduleContext, method);
            StringBuilderValue funName = new StringBuilderValue(newFun.getName());
            AbstractJavaMethod fun = this._functionMap.getRaw(funName);
            fun = fun != null ? fun.overload(newFun) : newFun;
            this._functionMap.put(((Object)funName).toString(), fun);
        }
    }

    public JavaMethod getToString() {
        return this.__toString;
    }

    public StringValue toString(Env env, JavaValue value) {
        if (this.__toString == null) {
            return null;
        }
        return this.__toString.callMethod(env, this.getQuercusClass(), (Value)value, new Expr[0]).toStringValue();
    }

    public boolean jsonEncode(Env env, Object obj, StringValue sb) {
        if (this._jsonEncode == null) {
            return false;
        }
        try {
            this._jsonEncode.invoke(obj, env, sb);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new QuercusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public boolean printRImpl(Env env, Object obj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        try {
            if (this._printRImpl == null) {
                return false;
            }
            this._printRImpl.invoke(obj, env, out, depth, valueSet);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new QuercusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public boolean varDumpImpl(Env env, Value obj, Object javaObj, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        try {
            if (this._varDumpImpl == null) {
                return false;
            }
            this._varDumpImpl.invoke(javaObj, env, obj, out, depth, valueSet);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new QuercusRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    private static class URLClassDef
    extends JavaClassDef {
        URLClassDef(ModuleContext module) {
            super(module, "URL", URL.class);
        }

        public Value wrap(Env env, Object obj) {
            return new JavaURLValue(env, (URL)obj, (JavaClassDef)this);
        }
    }

    private static class DateClassDef
    extends JavaClassDef {
        DateClassDef(ModuleContext module) {
            super(module, "Date", Date.class);
        }

        public Value wrap(Env env, Object obj) {
            return new JavaDateValue(env, (Date)obj, (JavaClassDef)this);
        }
    }

    private static class CalendarClassDef
    extends JavaClassDef {
        CalendarClassDef(ModuleContext module) {
            super(module, "Calendar", Calendar.class);
        }

        public Value wrap(Env env, Object obj) {
            return new JavaCalendarValue(env, (Calendar)obj, (JavaClassDef)this);
        }
    }

    private static class BooleanClassDef
    extends JavaClassDef {
        BooleanClassDef(ModuleContext module) {
            super(module, "Boolean", Boolean.class);
        }

        public Value wrap(Env env, Object obj) {
            if (Boolean.TRUE.equals(obj)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }

    private static class StringClassDef
    extends JavaClassDef {
        StringClassDef(ModuleContext module) {
            super(module, "String", String.class);
        }

        public Value wrap(Env env, Object obj) {
            return env.createString((String)obj);
        }
    }

    private static class BigDecimalClassDef
    extends JavaClassDef {
        BigDecimalClassDef(ModuleContext module) {
            super(module, "BigDecimal", BigDecimal.class);
        }

        public Value wrap(Env env, Object obj) {
            return new BigDecimalValue(env, (BigDecimal)obj, (JavaClassDef)this);
        }
    }

    private static class BigIntegerClassDef
    extends JavaClassDef {
        BigIntegerClassDef(ModuleContext module) {
            super(module, "BigInteger", BigInteger.class);
        }

        public Value wrap(Env env, Object obj) {
            return new BigIntegerValue(env, (BigInteger)obj, (JavaClassDef)this);
        }
    }

    private static class DoubleClassDef
    extends JavaClassDef {
        DoubleClassDef(ModuleContext module) {
            super(module, "Double", Double.class);
        }

        public Value wrap(Env env, Object obj) {
            return new DoubleValue(((Number)obj).doubleValue());
        }
    }

    private static class LongClassDef
    extends JavaClassDef {
        LongClassDef(ModuleContext module) {
            super(module, "Long", Long.class);
        }

        public Value wrap(Env env, Object obj) {
            return LongValue.create(((Number)obj).longValue());
        }
    }

    private class FieldMarshalPair {
        public Field _field;
        public Marshal _marshal;

        public FieldMarshalPair(Field field, Marshal marshal) {
            this._field = field;
            this._marshal = marshal;
        }
    }

    private class MethodMarshalPair {
        public Method _method;
        public Marshal _marshal;

        public MethodMarshalPair(Method method, Marshal marshal) {
            this._method = method;
            this._marshal = marshal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaEntry
    implements Map.Entry<Value, Value> {
        private Value _key;
        private Value _value;

        public JavaEntry(Value key, Value value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        @Override
        public Value getValue() {
            return this._value;
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private Env _env;
        private Iterator _iterator;
        private int _index;

        public JavaIterator(Env env, Iterator iterator) {
            this._env = env;
            this._iterator = iterator;
        }

        @Override
        public Map.Entry<Value, Value> next() {
            Object next = this._iterator.next();
            int index = this._index++;
            if (next instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)next;
                if (entry.getKey() instanceof Value && entry.getValue() instanceof Value) {
                    return entry;
                }
                Value key = this._env.wrapJava(entry.getKey());
                Value val = this._env.wrapJava(entry.getValue());
                return new JavaEntry(key, val);
            }
            return new JavaEntry(LongValue.create(index), this._env.wrapJava(next));
        }

        @Override
        public boolean hasNext() {
            if (this._iterator != null) {
                return this._iterator.hasNext();
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaValueIterator
    implements Iterator<Value> {
        private Env _env;
        private Iterator _iterator;

        public JavaValueIterator(Env env, Iterator iterator) {
            this._env = env;
            this._iterator = iterator;
        }

        @Override
        public Value next() {
            return this._env.wrapJava(this._iterator.next());
        }

        @Override
        public boolean hasNext() {
            if (this._iterator != null) {
                return this._iterator.hasNext();
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaKeyIterator
    implements Iterator<Value> {
        private Iterator _iterator;
        private int _index;

        public JavaKeyIterator(Iterator iterator) {
            this._iterator = iterator;
        }

        @Override
        public Value next() {
            this._iterator.next();
            return LongValue.create(this._index++);
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaTraversableDelegate
    implements TraversableDelegate {
        private Method _iteratorMethod;

        public JavaTraversableDelegate(Method iterator) {
            this._iteratorMethod = iterator;
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> getIterator(Env env, ObjectValue qThis) {
            try {
                Iterator iterator = (Iterator)this._iteratorMethod.invoke(qThis.toJavaObject(), new Object[0]);
                return new JavaIterator(env, iterator);
            }
            catch (InvocationTargetException e) {
                throw new QuercusRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new QuercusRuntimeException(e);
            }
        }

        @Override
        public Iterator<Value> getKeyIterator(Env env, ObjectValue qThis) {
            try {
                Iterator iterator = (Iterator)this._iteratorMethod.invoke(qThis.toJavaObject(), new Object[0]);
                return new JavaKeyIterator(iterator);
            }
            catch (InvocationTargetException e) {
                throw new QuercusRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new QuercusRuntimeException(e);
            }
        }

        @Override
        public Iterator<Value> getValueIterator(Env env, ObjectValue qThis) {
            try {
                Iterator iterator = (Iterator)this._iteratorMethod.invoke(qThis.toJavaObject(), new Object[0]);
                return new JavaValueIterator(env, iterator);
            }
            catch (InvocationTargetException e) {
                throw new QuercusRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new QuercusRuntimeException(e);
            }
        }
    }
}

