/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.quercus.GoogleQuercus;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusLineRuntimeException;
import com.caucho.quercus.QuercusRequestAdapter;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusValueException;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.servlet.QuercusServletImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GoogleQuercusServletImpl
extends QuercusServletImpl {
    private static final L10N L = new L10N(GoogleQuercusServletImpl.class);
    private static final Logger log = Logger.getLogger(GoogleQuercusServletImpl.class.getName());
    private ServletContext _webApp;

    protected void initImpl(ServletConfig config) throws ServletException {
        this._webApp = config.getServletContext();
        this._quercus.setPwd(Vfs.lookup(this._webApp.getRealPath(".")));
    }

    protected QuercusServletImpl getQuercusServlet() {
        return this;
    }

    protected WriteStream openWrite(HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        WriteStream ws = Vfs.openWrite((OutputStream)out);
        return ws;
    }

    Path getPath(HttpServletRequest req) {
        String scriptPath = QuercusRequestAdapter.getPageServletPath(req);
        String pathInfo = QuercusRequestAdapter.getPagePathInfo(req);
        Path pwd = Vfs.lookup();
        Path path = pwd.lookup(req.getRealPath(scriptPath));
        if (path.isFile()) {
            return path;
        }
        String fullPath = pathInfo != null ? scriptPath + pathInfo : scriptPath;
        return Vfs.lookup().lookup(req.getRealPath(fullPath));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Env env = null;
        WriteStream ws = null;
        try {
            QuercusPage page;
            Path path = this.getPath(request);
            try {
                page = this.getQuercus().parse(path);
            }
            catch (FileNotFoundException ex) {
                log.log(Level.FINER, ex.toString(), ex);
                response.sendError(404);
                return;
            }
            ws = this.openWrite(response);
            ws.setNewlineString("\n");
            QuercusContext quercus = this.getQuercus();
            env = quercus.createEnv(page, ws, request, response);
            quercus.setServletContext(this._servletContext);
            try {
                env.start();
                StringValue prepend = quercus.getIniValue("auto_prepend_file").toStringValue(env);
                if (prepend.length() > 0) {
                    Path prependPath = env.lookup(prepend);
                    if (prependPath == null) {
                        env.error(L.l("auto_prepend_file '{0}' not found.", prepend));
                    } else {
                        QuercusPage prependPage = this.getQuercus().parse(prependPath);
                        prependPage.executeTop(env);
                    }
                }
                env.executeTop();
                StringValue append = quercus.getIniValue("auto_append_file").toStringValue(env);
                if (append.length() > 0) {
                    Path appendPath = env.lookup(append);
                    if (appendPath == null) {
                        env.error(L.l("auto_append_file '{0}' not found.", append));
                    } else {
                        QuercusPage appendPage = this.getQuercus().parse(appendPath);
                        appendPage.executeTop(env);
                    }
                }
            }
            catch (QuercusExitException e) {
                throw e;
            }
            catch (QuercusErrorException e) {
                throw e;
            }
            catch (QuercusLineRuntimeException e) {
                log.log(Level.FINE, e.toString(), e);
                ws.println(e.getMessage());
            }
            catch (QuercusValueException e) {
                log.log(Level.FINE, e.toString(), e);
                ws.println(e.toString());
            }
            catch (Throwable e) {
                if (response.isCommitted()) {
                    e.printStackTrace(ws.getPrintWriter());
                }
                ws = null;
                throw e;
            }
            finally {
                if (env != null) {
                    env.close();
                }
                if (ws != null) {
                    ws.close();
                }
            }
        }
        catch (QuercusDieException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (QuercusExitException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (QuercusErrorException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            ServletOutputStream os = response.getOutputStream();
            WriteStream out = Vfs.openWrite((OutputStream)os);
            out.println(e);
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QuercusContext getQuercus() {
        GoogleQuercusServletImpl googleQuercusServletImpl = this;
        synchronized (googleQuercusServletImpl) {
            if (this._quercus == null) {
                this._quercus = new GoogleQuercus();
            }
        }
        return this._quercus;
    }
}

