/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.statement;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.VarExpr;
import com.caucho.quercus.statement.Statement;

public class StaticStatement
extends Statement {
    protected VarExpr _var;
    protected Expr _initValue;
    protected StringValue _staticName;

    public StaticStatement(Location location, VarExpr var, Expr initValue) {
        super(location);
        this._var = var;
        this._initValue = initValue;
    }

    public Value execute(Env env) {
        try {
            if (this._staticName == null) {
                this._staticName = env.createStaticName();
            }
            StringValue staticName = this._staticName;
            Var var = env.getStaticVar(staticName);
            env.setRef(this._var.getName(), var);
            if (!var.isset() && this._initValue != null) {
                var.set(this._initValue.eval(env));
            }
        }
        catch (RuntimeException e) {
            this.rethrow(e, RuntimeException.class);
        }
        return null;
    }
}

