/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.servlet.WebSocketContext;
import com.caucho.servlet.WebSocketListener;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketClient {
    private static final Logger log = Logger.getLogger(WebSocketClient.class.getName());
    private static final L10N L = new L10N(WebSocketClient.class);
    private String _url;
    private String _scheme;
    private String _host;
    private int _port;
    private String _path;
    private String _virtualHost;
    private WebSocketListener _listener;
    private Socket _s;
    private ReadStream _is;
    private WriteStream _os;
    private boolean _isClosed;
    private ClientContext _context;

    public WebSocketClient(String url) {
        this._url = url;
        this.parseUrl(url);
    }

    public void setVirtualHost(String virtualHost) {
        this._virtualHost = virtualHost;
    }

    public void connect(WebSocketListener listener) throws IOException {
        if (listener == null) {
            throw new NullPointerException(L.l("listener is a required argument for connect()"));
        }
        this._listener = listener;
        this.connectImpl();
    }

    private void parseUrl(String url) {
        String server;
        int p = url.indexOf("://");
        if (p < 0) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal URL because it is missing a scheme", url));
        }
        this._scheme = url.substring(0, p);
        int q = url.indexOf(47, p + 3);
        if (q < 0) {
            server = url.substring(p + 3);
            this._path = "/";
        } else {
            server = url.substring(p + 3, q);
            this._path = url.substring(q);
        }
        p = server.indexOf(58);
        if (p < 0) {
            this._host = server;
            this._port = 80;
        } else {
            this._host = server.substring(0, p);
            this._port = Integer.parseInt(server.substring(p + 1));
        }
    }

    protected void connectImpl() throws IOException {
        this._s = new Socket(this._host, this._port);
        this._is = Vfs.openRead(this._s.getInputStream());
        this._os = Vfs.openWrite(this._s.getOutputStream());
        this._os.print("GET " + this._path + " HTTP/1.1\r\n");
        if (this._virtualHost != null) {
            this._os.print("Host: " + this._virtualHost + "\r\n");
        } else if (this._host != null) {
            this._os.print("Host: " + this._host + "\r\n");
        } else {
            this._os.print("Host: localhost\r\n");
        }
        this._os.print("Upgrade: WebSocket\r\n");
        this._os.print("Connection: Upgrade\r\n");
        this._os.print("Origin: Foo\r\n");
        this._os.print("\r\n");
        this._os.flush();
        this.parseHeaders(this._is);
        this._context = new ClientContext();
        this._listener.onStart(this._context);
        Thread thread = new Thread(this._context);
        thread.setDaemon(true);
        thread.start();
    }

    protected void parseHeaders(ReadStream in) throws IOException {
        String line = in.readln();
        if (!line.startsWith("HTTP/1.1 101")) {
            throw new IOException(L.l("Unexpected response {0}", line));
        }
        while ((line = in.readln()) != null && line.length() != 0) {
            int p = line.indexOf(58);
            if (p <= 0) continue;
            String header = line.substring(0, p).trim();
            String value = line.substring(p + 1).trim();
        }
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    public void complete() {
        WriteStream os = this._os;
        try {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void close() {
        this._isClosed = true;
        WriteStream os = this._os;
        this._os = null;
        ReadStream is = this._is;
        this._is = null;
        Socket s = this._s;
        this._s = null;
        try {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._url + "]";
    }

    class ClientContext
    implements Runnable,
    WebSocketContext {
        ClientContext() {
        }

        public InputStream getInputStream() {
            return WebSocketClient.this._is;
        }

        public OutputStream getOutputStream() {
            return WebSocketClient.this._os;
        }

        public void complete() {
            try {
                WebSocketClient.this._os.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }

        public long getTimeout() {
            return 0L;
        }

        public void setTimeout(long timeout) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block10: {
                this.handleRequests();
                Object var3_1 = null;
                try {
                    WebSocketClient.this._listener.onComplete(this);
                }
                catch (IOException e2) {
                    log.log(Level.WARNING, e2.toString(), e2);
                }
                break block10;
                {
                    catch (Exception e) {
                        if (WebSocketClient.this._isClosed) {
                            log.log(Level.FINEST, e.toString(), e);
                        } else {
                            log.log(Level.WARNING, e.toString(), e);
                        }
                        Object var3_2 = null;
                        try {
                            WebSocketClient.this._listener.onComplete(this);
                        }
                        catch (IOException e2) {
                            log.log(Level.WARNING, e2.toString(), e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        WebSocketClient.this._listener.onComplete(this);
                    }
                    catch (IOException e2) {
                        log.log(Level.WARNING, e2.toString(), e2);
                    }
                    throw throwable;
                }
            }
        }

        public void handleRequests() throws IOException {
            while (!WebSocketClient.this.isClosed() && WebSocketClient.this._is.waitForRead()) {
                WebSocketClient.this._listener.onRead(this);
            }
        }
    }
}

