/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class WebSocketOutputStream
extends OutputStream {
    private static final L10N L = new L10N(WebSocketOutputStream.class);
    private OutputStream _os;
    private TempBuffer _tBuf;
    private byte[] _buffer;
    private int _offset;

    public WebSocketOutputStream() {
    }

    public WebSocketOutputStream(OutputStream os) throws IOException {
        this.init(os);
    }

    public void init(OutputStream os) throws IOException {
        this._os = os;
        this._tBuf = TempBuffer.allocate();
        this._buffer = this._tBuf.getBuffer();
        this._offset = 3;
    }

    public void write(int ch) throws IOException {
        byte[] buffer = this._buffer;
        if (buffer == null) {
            return;
        }
        if (this._offset == buffer.length) {
            this.flush();
        }
        buffer[this._offset++] = (byte)ch;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        byte[] wsBuffer = this._buffer;
        if (wsBuffer == null) {
            return;
        }
        while (length > 0) {
            int sublen;
            if (this._offset == wsBuffer.length) {
                this.flush();
            }
            if (length < (sublen = wsBuffer.length - this._offset)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, wsBuffer, this._offset, sublen);
            offset += sublen;
            length -= sublen;
            this._offset += sublen;
        }
    }

    public void complete() throws IOException {
        byte[] buffer = this._buffer;
        if (buffer == null) {
            return;
        }
        int offset = this._offset;
        this._offset = 3;
        if (offset == 3) {
            return;
        }
        int length = offset - 3;
        buffer[0] = -128;
        buffer[1] = (byte)(128 + (length >> 7 & 0x3F));
        buffer[2] = (byte)(0 + (length & 0x3F));
        this._os.write(buffer, 0, offset);
    }

    public void flush() throws IOException {
        this.complete();
        this._os.flush();
    }

    public void close() throws IOException {
        this.flush();
        OutputStream os = this._os;
        this._os = null;
        byte[] buffer = this._buffer;
        this._buffer = null;
        TempBuffer tBuf = this._tBuf;
        this._tBuf = null;
        if (buffer == null) {
            return;
        }
        buffer[0] = -128;
        buffer[1] = 0;
        os.write(buffer, 0, 2);
        TempBuffer.free(tBuf);
    }
}

