/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WebSocketWriter
extends Writer {
    private OutputStream _os;

    public WebSocketWriter() {
    }

    public WebSocketWriter(OutputStream os) throws IOException {
        this.init(os);
    }

    public void init(OutputStream os) throws IOException {
        this._os = os;
        os.write(0);
    }

    public void write(int ch) throws IOException {
        OutputStream os = this._os;
        if (ch < 128) {
            os.write(ch);
        } else if (ch < 2048) {
            os.write(0xC0 | ch >> 6);
            os.write(0x80 | ch & 0x3F);
        } else {
            os.write(0xE0 | ch >> 12 & 0x1F);
            os.write(0x80 | ch >> 6 & 0x3F);
            os.write(0x80 | ch & 0x3F);
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(char[] buf, int offset, int length) throws IOException {
        OutputStream os = this._os;
        int end = offset + length;
        while (offset < end) {
            char ch = buf[offset];
            if (ch < '\u0080') {
                os.write(ch);
            } else if (ch < '\u0800') {
                os.write(0xC0 | ch >> 6);
                os.write(0x80 | ch & 0x3F);
            } else {
                os.write(0xE0 | ch >> 12 & 0x1F);
                os.write(0x80 | ch >> 6 & 0x3F);
                os.write(0x80 | ch & 0x3F);
            }
            ++offset;
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void write(String s, int offset, int length) throws IOException {
        OutputStream os = this._os;
        int end = offset + length;
        while (offset < end) {
            char ch = s.charAt(offset);
            if (ch < '\u0080') {
                os.write(ch);
            } else if (ch < '\u0800') {
                os.write(0xC0 | ch >> 6);
                os.write(0x80 | ch & 0x3F);
            } else {
                os.write(0xE0 | ch >> 12 & 0x1F);
                os.write(0x80 | ch >> 6 & 0x3F);
                os.write(0x80 | ch & 0x3F);
            }
            ++offset;
        }
    }

    public void flush() throws IOException {
        if (this._os != null) {
            this._os.flush();
        }
    }

    public void close() throws IOException {
        OutputStream os = this._os;
        this._os = null;
        if (os != null) {
            os.write(255);
        }
    }
}

