/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.cfg.BeansConfig;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.manager.EjbEnvironmentListener;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.env.jpa.ListenerPersistenceEnvironment;
import com.caucho.inject.ThreadContext;
import com.caucho.java.WorkDir;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.ResourceLoader;
import com.caucho.resin.BeanContainerRequest;
import com.caucho.server.webbeans.ResinCdiProducer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinBeanContainer {
    private static final L10N L = new L10N(ResinBeanContainer.class);
    private static final String SCHEMA = "com/caucho/resin/resin-context.rnc";
    private EnvironmentClassLoader _classLoader;
    private InjectManager _injectManager;
    private ThreadLocal<BeanContainerRequest> _localContext = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResinBeanContainer() {
        this._classLoader = EnvironmentClassLoader.create("resin-context");
        this._injectManager = InjectManager.create(this._classLoader);
        this._injectManager.replaceContext(new RequestScope());
        this._injectManager.replaceContext(ThreadContext.getContext());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            EjbManager.create(this._classLoader);
            Environment.init();
            Environment.addChildLoaderListener(new ListenerPersistenceEnvironment());
            Environment.addChildLoaderListener(new EjbEnvironmentListener());
            Environment.addCloseListener(this);
            this._injectManager.addManagedBean(this._injectManager.createManagedBean(ResinCdiProducer.class));
            Class<?> resinValidatorClass = ResinCdiProducer.createResinValidatorProducer();
            if (this._injectManager != null) {
                this._injectManager.addManagedBean(this._injectManager.createManagedBean(resinValidatorClass));
            }
            this._classLoader.scanRoot();
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void addModule(String modulePath) {
        Path path = Vfs.lookup(modulePath);
        if (modulePath.endsWith(".jar")) {
            this._classLoader.addJar(path);
        } else {
            CompilingLoader loader = new CompilingLoader(this._classLoader);
            loader.setPath(path);
            loader.init();
        }
    }

    public void addPackageModule(String modulePath, String packageName) {
        Path root = Vfs.lookup(modulePath);
        try {
            URL url = new URL(root.getURL());
            this._classLoader.addScanPackage(url, packageName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public void addPackageModule(String packageName) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> e = loader.getResources(packageName.replace('.', '/'));
            URL bestUrl = null;
            block2: while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (bestUrl == null) {
                    bestUrl = url;
                    continue;
                }
                URL urlA = bestUrl;
                Path pathA = Vfs.lookup(urlA);
                Path pathB = Vfs.lookup(url);
                for (String name : pathA.list()) {
                    if (!name.endsWith(".class")) continue;
                    bestUrl = urlA;
                    break;
                }
                for (String name : pathB.list()) {
                    if (!name.endsWith(".class")) continue;
                    bestUrl = url;
                    continue block2;
                }
            }
            if (bestUrl == null) {
                throw new NullPointerException(packageName);
            }
            Path path = Vfs.lookup(bestUrl);
            String moduleName = path.getNativePath();
            if (moduleName.endsWith(packageName.replace('.', '/'))) {
                int prefixLength = moduleName.length() - packageName.length();
                moduleName = moduleName.substring(0, prefixLength);
            }
            this.addResourceRoot(path);
            this.addPackageModule(moduleName, packageName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeansXml(String pathName) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Path path = Vfs.lookup(pathName);
            ContextConfig context = new ContextConfig(this._injectManager, path);
            Config config = new Config();
            config.configure((Object)context, path, SCHEMA);
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public void addResourceRoot(Path path) {
        ResourceLoader loader = new ResourceLoader(this._classLoader, path);
        loader.init();
    }

    public void setWorkDirectory(String path) {
        WorkDir.setLocalWorkDir(Vfs.lookup(path), this._classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            this._classLoader.start();
            InjectManager cdiManager = InjectManager.create();
            cdiManager.update();
            Object var5_4 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public Object getInstance(String className, Annotation ... qualifiers) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Class<?> cl = Class.forName(className, false, this._classLoader);
            Object obj = this.getInstance(cl, qualifiers);
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            return obj;
        }
        catch (ClassNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getInstance(Class<T> type, Annotation ... qualifiers) {
        T t;
        if (type == null) {
            throw new NullPointerException();
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            try {
                thread.setContextClassLoader(this._classLoader);
                Set beans = this._injectManager.getBeans(type, qualifiers);
                if (beans.size() > 0) {
                    Bean bean = this._injectManager.resolve(beans);
                    Object x = this._injectManager.getReference(bean);
                    Object var9_11 = null;
                    thread.setContextClassLoader(oldLoader);
                    return (T)x;
                }
                t = type.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        Object var9_12 = null;
        thread.setContextClassLoader(oldLoader);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBeanByName(String name) {
        ClassLoader oldLoader;
        Thread thread;
        block3: {
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._classLoader);
                Set beans = this._injectManager.getBeans(name);
                if (beans.size() <= 0) break block3;
                Bean bean = this._injectManager.resolve(beans);
                Object x = this._injectManager.getReference(bean);
                Object var8_8 = null;
                thread.setContextClassLoader(oldLoader);
                return x;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        Object var5_6 = null;
        Object var8_9 = null;
        thread.setContextClassLoader(oldLoader);
        return var5_6;
    }

    public BeanContainerRequest beginRequest() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        BeanContainerRequest oldContext = this._localContext.get();
        BeanContainerRequest context = new BeanContainerRequest(this, oldLoader, oldContext);
        thread.setContextClassLoader(this._classLoader);
        this._localContext.set(context);
        return context;
    }

    void completeRequest(BeanContainerRequest context) {
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(context.getOldClassLoader());
        this._localContext.set(context.getOldContext());
    }

    public void close() {
        EnvironmentClassLoader loader = this._classLoader;
        this._classLoader = null;
        if (loader != null) {
            loader.destroy();
        }
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String toString() {
        return this.getClass().getName() + "[]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestScope
    implements Context {
        private RequestScope() {
        }

        public <T> T get(Contextual<T> bean) {
            BeanContainerRequest cxt = (BeanContainerRequest)ResinBeanContainer.this._localContext.get();
            if (cxt == null) {
                throw new IllegalStateException(L.l("No RequestScope is active"));
            }
            return cxt.get(bean);
        }

        public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
            BeanContainerRequest cxt = (BeanContainerRequest)ResinBeanContainer.this._localContext.get();
            if (cxt == null) {
                throw new IllegalStateException(L.l("No RequestScope is active"));
            }
            return cxt.get(bean, creationalContext, ResinBeanContainer.this._injectManager);
        }

        public Class<? extends Annotation> getScope() {
            return RequestScoped.class;
        }

        public boolean isActive() {
            return ResinBeanContainer.this._localContext.get() != null;
        }
    }

    private class SystemContext
    implements EnvironmentBean {
        private SystemContext() {
        }

        public ClassLoader getClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }
    }

    private class ContextConfig
    extends BeansConfig
    implements EnvironmentBean {
        ContextConfig(InjectManager manager, Path root) {
            super(manager, root);
        }

        public ClassLoader getClassLoader() {
            return ResinBeanContainer.this._classLoader;
        }

        public SystemContext createSystem() {
            return new SystemContext();
        }
    }
}

