/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.resin.ServletProtocolEmbed;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.Map;

public class ServletEmbed {
    private static final L10N L = new L10N(ServletEmbed.class);
    private String _servletName;
    private String _servletClass;
    private int _loadOnStartup = -1;
    private HashMap<String, String> _initParamMap = new HashMap();
    private ContainerProgram _init = new ContainerProgram();
    private ServletProtocolEmbed _protocol;

    public ServletEmbed() {
    }

    public ServletEmbed(String servletClass) {
        this.setServletClass(servletClass);
    }

    public ServletEmbed(String servletClass, String servletName) {
        this.setServletClass(servletClass);
        this.setServletName(servletName);
    }

    public void setServletName(String servletName) {
        this._servletName = servletName;
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setServletClass(String servletClass) {
        this._servletClass = servletClass;
    }

    public String getServletClass() {
        return this._servletClass;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this._loadOnStartup = loadOnStartup;
    }

    public void setInitParam(String name, String value) {
        this._initParamMap.put(name, value);
    }

    public void addProperty(String name, Object value) {
        this._init.addProgram(new PropertyValueProgram(name, value));
    }

    public void setProtocol(ServletProtocolEmbed protocol) {
        this._protocol = protocol;
    }

    protected void configure(ServletConfigImpl servletConfig) {
        try {
            if (this._servletClass == null) {
                throw new ConfigException(L.l("servlet-class is required for ServletEmbed."));
            }
            servletConfig.setServletClass(this._servletClass);
            if (this._servletName != null) {
                servletConfig.setServletName(this._servletName);
            } else {
                servletConfig.setServletName(this._servletClass);
            }
            for (Map.Entry<String, String> entry : this._initParamMap.entrySet()) {
                servletConfig.setInitParam(entry.getKey(), entry.getValue());
            }
            servletConfig.setInit(this._init);
            if (this._loadOnStartup >= 0) {
                servletConfig.setLoadOnStartup(this._loadOnStartup);
            }
            if (this._protocol != null) {
                servletConfig.setProtocol(this._protocol.createProtocol());
            }
            servletConfig.init();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

