/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.CronType;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfCron
implements RequestPredicate {
    private static final L10N L = new L10N(IfCron.class);
    private CronType _enableAt;
    private CronType _disableAt;

    @Configurable
    public void setEnableAt(CronType enableAt) {
        this._enableAt = enableAt;
    }

    @Configurable
    public void setDisableAt(CronType disableAt) {
        this._disableAt = disableAt;
    }

    @PostConstruct
    public void init() {
        if (this._enableAt == null) {
            throw new ConfigException(L.l("{0} requires 'enable-at' attribute", this.getClass().getSimpleName()));
        }
        if (this._disableAt == null) {
            throw new ConfigException(L.l("{0} requires 'disable-at' attribute", this.getClass().getSimpleName()));
        }
    }

    public boolean isMatch(HttpServletRequest request) {
        long now = Alarm.getCurrentTime();
        long prevEnable = this._enableAt.prevTime(now);
        long prevDisable = this._disableAt.prevTime(now);
        return prevEnable > 0L && prevDisable <= prevEnable;
    }
}

