/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Admin;
import com.caucho.config.CauchoDeployment;
import com.caucho.config.Service;
import com.caucho.security.PasswordUser;
import com.caucho.security.XmlAuthenticator;
import com.caucho.server.security.PasswordDigest;
import com.caucho.util.Base64;
import com.caucho.util.Crc64;
import javax.enterprise.inject.Default;
import javax.inject.Named;

@Service
@Admin
@Named(value="resinAdmin")
@Default
@CauchoDeployment
public class AdminAuthenticator
extends XmlAuthenticator {
    private String _remoteCookie;

    protected PasswordUser getPasswordUser(String userName) {
        if ("admin.resin".equals(userName)) {
            String hash = this.getHash();
            PasswordDigest digest = this.getPasswordDigest();
            if (digest != null) {
                hash = digest.getPasswordDigest(userName, hash);
            }
            return new PasswordUser(userName, hash);
        }
        return super.getPasswordUser(userName);
    }

    public String getHash() {
        if (this._remoteCookie == null) {
            long crc64 = 0L;
            for (PasswordUser user : this.getUserMap().values()) {
                if (user.isDisabled()) continue;
                crc64 = Crc64.generate(crc64, user.getPrincipal().getName());
                crc64 = Crc64.generate(crc64, ":");
                crc64 = Crc64.generate(crc64, new String(user.getPassword()));
            }
            if (crc64 != 0L) {
                StringBuilder cb = new StringBuilder();
                Base64.encode(cb, crc64);
                this._remoteCookie = cb.toString();
            }
        }
        return this._remoteCookie;
    }

    public String getDefaultGroup() {
        return "resin-admin";
    }
}

