/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.ConfigException;
import com.caucho.config.Service;
import com.caucho.security.AbstractLogin;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.CookieAuthenticator;
import com.caucho.security.PasswordCredentials;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Service
public class FormLogin
extends AbstractLogin {
    private static final L10N L = new L10N(FormLogin.class);
    public static final String LOGIN_CHECK = "com.caucho.security.form.login";
    public static final String LOGIN_SAVED_PATH = "com.caucho.servlet.login.path";
    public static final String LOGIN_SAVED_QUERY = "com.caucho.servlet.login.query";
    protected String _loginPage;
    protected String _errorPage;
    protected boolean _internalForward;
    protected boolean _formURIPriority;
    private WebApp _webApp = WebApp.getCurrent();

    public void setFormLoginPage(String formLoginPage) throws ConfigException {
        int colon = formLoginPage.indexOf(58);
        int slash = formLoginPage.indexOf(47);
        if ((colon <= 0 || colon >= slash) && slash != 0) {
            throw new ConfigException(L.l("form-login-page '{0}' must start with '/'.  The form-login-page is relative to the web-app root.", formLoginPage));
        }
        this._loginPage = formLoginPage;
    }

    public void setLoginPage(String loginPage) {
        this.setFormLoginPage(loginPage);
    }

    public String getFormLoginPage() {
        return this._loginPage;
    }

    public void setFormErrorPage(String formErrorPage) throws ConfigException {
        if (!formErrorPage.startsWith("/")) {
            throw new ConfigException(L.l("form-error-page '{0}' must start with '/'.  The form-error-page is relative to the web-app root.", formErrorPage));
        }
        this._errorPage = formErrorPage;
    }

    public void setErrorPage(String errorPage) {
        this.setFormErrorPage(errorPage);
    }

    public String getFormErrorPage() {
        return this._errorPage;
    }

    public boolean getInternalForward() {
        return this._internalForward;
    }

    public void setInternalForward(boolean internalForward) {
        this._internalForward = internalForward;
    }

    public boolean getFormURIPriority() {
        return this._formURIPriority;
    }

    public void setFormURIPriority(boolean formPriority) {
        this._formURIPriority = formPriority;
    }

    @PostConstruct
    public void init() throws ServletException {
        super.init();
        if (this._errorPage == null) {
            this._errorPage = this._loginPage;
        }
        if (this._loginPage == null) {
            this._loginPage = this._errorPage;
        }
        if (this._loginPage == null) {
            throw new ConfigException(L.l("FormLogin needs an form-login-page"));
        }
    }

    public String getAuthType() {
        return "Form";
    }

    public boolean isLoginUsedForRequest(HttpServletRequest request) {
        return request.getServletPath().indexOf("j_security_check") >= 0;
    }

    public Principal getUserPrincipalImpl(HttpServletRequest request) {
        Principal user;
        Authenticator auth = this.getAuthenticator();
        if (auth instanceof CookieAuthenticator) {
            CookieAuthenticator cookieAuth = (CookieAuthenticator)auth;
            Cookie resinAuth = ((CauchoRequest)request).getCookie("resinauthid");
            if (resinAuth != null && (user = cookieAuth.authenticateByCookie(resinAuth.getValue())) != null) {
                return user;
            }
        }
        String userName = request.getParameter("j_username");
        String passwordString = request.getParameter("j_password");
        if (userName == null || passwordString == null) {
            return null;
        }
        char[] password = passwordString.toCharArray();
        BasicPrincipal basicUser = new BasicPrincipal(userName);
        PasswordCredentials credentials = new PasswordCredentials(password);
        user = auth.authenticate(basicUser, credentials, request);
        return user;
    }

    protected boolean isSavedUserValid(HttpServletRequest request, Principal savedUser) {
        String userName = request.getParameter("j_username");
        return userName == null;
    }

    public void loginSuccessResponse(Principal user, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path;
        if (request.getAttribute(LOGIN_CHECK) != null) {
            return;
        }
        request.setAttribute(LOGIN_CHECK, (Object)"login");
        WebApp app = this._webApp;
        String jUseCookieAuth = request.getParameter("j_use_cookie_auth");
        Authenticator auth = this.getAuthenticator();
        if (auth instanceof CookieAuthenticator && ((CookieAuthenticator)auth).isCookieSupported(jUseCookieAuth)) {
            CookieAuthenticator cookieAuth = (CookieAuthenticator)auth;
            this.generateCookie(user, cookieAuth, app, request, response);
        }
        if ((path = request.getServletPath()) == null) {
            path = request.getPathInfo();
        } else if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        if (path.equals("")) {
            path = request.getContextPath() + "/";
            response.sendRedirect(response.encodeRedirectURL(path));
            return;
        }
        String uri = request.getRequestURI();
        if (path.endsWith("/j_security_check")) {
            RequestDispatcher disp = app.getNamedDispatcher("j_security_check");
            if (disp == null) {
                throw new ServletException(L.l("j_security_check servlet must be defined to use form-based login."));
            }
            disp.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
    }

    public void loginChallenge(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getServletPath();
        if (path == null) {
            path = request.getPathInfo();
        } else if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        if (path.equals("")) {
            path = request.getContextPath() + "/";
            response.sendRedirect(response.encodeRedirectURL(path));
            return;
        }
        WebApp app = this._webApp;
        String uri = request.getRequestURI();
        if (path.endsWith("/j_security_check")) {
            if (response instanceof CauchoResponse) {
                ((CauchoResponse)response).setNoCache(true);
            } else {
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
            }
            RequestDispatcherImpl disp = app.getRequestDispatcher(this._errorPage);
            disp.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (uri.equals(this._loginPage) || uri.equals(this._errorPage)) {
            request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession session = request.getSession();
        session.putValue(LOGIN_SAVED_PATH, (Object)path);
        session.putValue(LOGIN_SAVED_QUERY, (Object)request.getQueryString());
        if (response instanceof CauchoResponse) {
            ((CauchoResponse)response).killCache();
            ((CauchoResponse)response).setNoCache(true);
        } else {
            response.setHeader("Cache-Control", "no-cache");
        }
        if (!this._loginPage.startsWith("/")) {
            response.sendRedirect(response.encodeRedirectURL(this._loginPage));
            return;
        }
        request.setAttribute(LOGIN_CHECK, (Object)"login");
        RequestDispatcherImpl disp = app.getRequestDispatcher(this._loginPage);
        disp.forward((ServletRequest)request, (ServletResponse)response);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " request '" + uri + "' has no authenticated user");
        }
    }

    private void generateCookie(Principal user, CookieAuthenticator auth, WebApp webApp, HttpServletRequest request, HttpServletResponse response) {
        if (webApp == null) {
            return;
        }
        SessionManager manager = webApp.getSessionManager();
        String value = manager.createCookieValue();
        Cookie cookie = new Cookie("resinauthid", value);
        cookie.setVersion(1);
        long cookieMaxAge = 31536000000L;
        cookie.setMaxAge((int)(cookieMaxAge / 1000L));
        cookie.setPath("/");
        cookie.setDomain(webApp.generateCookieDomain(request));
        auth.associateCookie(user, value);
        response.addCookie(cookie);
    }
}

