/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.ConfigException;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import java.security.MessageDigest;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class PasswordDigest {
    private static final L10N L = new L10N(PasswordDigest.class);
    private String _algorithm = "MD5";
    private String _format = "base64";
    private String _realm = null;
    private MessageDigest _digest;
    private byte[] _digestBytes = new byte[256];

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public String getFormat() {
        return this._format;
    }

    public void setRealm(String realm) {
        this._realm = realm;
    }

    public String getRealm() {
        return this._realm;
    }

    public void addText(String value) throws ConfigException {
        int p = value.indexOf(45);
        if (p > 0) {
            String algorithm = value.substring(0, p);
            String format = value.substring(p + 1);
            this.setAlgorithm(algorithm);
            this.setFormat(format);
        } else if (value.equals("none")) {
            this.setAlgorithm(null);
            this.setFormat(null);
        } else {
            throw new ConfigException(L.l("{0} is an illegal algorithm.  Expected 'none' or 'algorithm-format', for example 'MD5-base64'.", value));
        }
    }

    @PostConstruct
    public void init() {
        if (this._algorithm == null) {
            return;
        }
        try {
            this._digest = MessageDigest.getInstance(this._algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPasswordDigest(String password) throws ServletException {
        return this.getPasswordDigest(null, password, this._realm, null);
    }

    public String getPasswordDigest(String user, String password) {
        return this.getPasswordDigest(user, password, this._realm, null);
    }

    public String getPasswordDigest(String user, String password, String realm) {
        return this.getPasswordDigest(user, password, realm, null);
    }

    public String getPasswordDigest(String user, String password, HttpServletRequest request) {
        return this.getPasswordDigest(user, password, this._realm, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPasswordDigest(String user, String password, String realm, HttpServletRequest request) {
        if (this._digest == null) {
            this.init();
            if (this._digest == null) {
                return null;
            }
        }
        try {
            MessageDigest messageDigest = this._digest;
            synchronized (messageDigest) {
                this._digest.reset();
                this.updateDigest(this._digest, user, password.toCharArray(), realm);
                int len = this._digest.digest(this._digestBytes, 0, this._digestBytes.length);
                return this.digestToString(this._digestBytes, len);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public char[] getPasswordDigest(String user, char[] password) {
        return this.getPasswordDigest(user, password, this._realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getPasswordDigest(String user, char[] password, String realm) {
        if (this._digest == null) {
            this.init();
            if (this._digest == null) {
                return null;
            }
        }
        try {
            MessageDigest messageDigest = this._digest;
            synchronized (messageDigest) {
                this._digest.reset();
                this.updateDigest(this._digest, user, password, realm);
                int len = this._digest.digest(this._digestBytes, 0, this._digestBytes.length);
                return this.digestToCharArray(this._digestBytes, len);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void updateDigest(MessageDigest digest, String user, char[] password, String realm) {
        if (user != null) {
            PasswordDigest.addDigestUTF8(digest, user);
            digest.update((byte)58);
        }
        if (realm != null && !realm.equals("none")) {
            PasswordDigest.addDigestUTF8(digest, realm);
            digest.update((byte)58);
        }
        PasswordDigest.addDigestUTF8(digest, password);
    }

    protected static void addDigestUTF8(MessageDigest digest, String string) {
        if (string == null) {
            return;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            PasswordDigest.addDigestUTF8(digest, ch);
        }
    }

    protected static void addDigestUTF8(MessageDigest digest, char[] string) {
        if (string == null) {
            return;
        }
        for (char ch : string) {
            PasswordDigest.addDigestUTF8(digest, ch);
        }
    }

    protected static void addDigestUTF8(MessageDigest digest, char ch) {
        if (ch < '\u0080') {
            digest.update((byte)ch);
        } else if (ch < '\u0800') {
            digest.update((byte)(192 + (ch >> 6)));
            digest.update((byte)(128 + (ch & 0x3F)));
        } else {
            digest.update((byte)(224 + (ch >> 12)));
            digest.update((byte)(128 + (ch >> 6 & 0x3F)));
            digest.update((byte)(128 + (ch & 0x3F)));
        }
    }

    public byte[] stringToDigest(String s) {
        return Base64.decodeToByteArray(s);
    }

    public byte[] stringToDigest(char[] s) {
        return Base64.decodeToByteArray(new String(s));
    }

    protected String digestToString(byte[] digest, int len) {
        return new String(this.digestToCharArray(digest, len));
    }

    protected char[] digestToCharArray(byte[] digest, int len) {
        if (!this._format.equals("base64")) {
            return PasswordDigest.digestToHex(digest, len);
        }
        return PasswordDigest.digestToBase64(digest, len);
    }

    protected static char[] digestToBase64(byte[] digest, int len) {
        StringBuilder sb = new StringBuilder();
        Base64.encode(sb, digest, 0, len);
        char[] string = new char[sb.length()];
        sb.getChars(0, string.length, string, 0);
        sb.setLength(0);
        return string;
    }

    protected static char[] digestToHex(byte[] digest, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int d1 = digest[i] >> 4 & 0xF;
            int d2 = digest[i] & 0xF;
            if (d1 >= 10) {
                sb.append((char)(d1 + 97 - 10));
            } else {
                sb.append((char)(d1 + 48));
            }
            if (d2 >= 10) {
                sb.append((char)(d2 + 97 - 10));
                continue;
            }
            sb.append((char)(d2 + 48));
        }
        char[] string = new char[sb.length()];
        sb.getChars(0, string.length, string, 0);
        sb.setLength(0);
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._algorithm + "," + this._format + "]";
    }
}

