/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.security.SecurityContextException;
import com.caucho.security.SecurityContextProvider;
import com.caucho.util.L10N;
import java.security.Principal;
import javax.ejb.EJBAccessException;

public class SecurityContext {
    private static final L10N L = new L10N(SecurityContext.class);

    private SecurityContext() {
    }

    public static Principal getUserPrincipal() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.getUserPrincipal();
        }
        return null;
    }

    public static boolean isUserInRole(String roleName) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.isUserInRole(roleName);
        }
        return false;
    }

    public static boolean isUserInRole(String[] roleSet) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null && roleSet != null) {
            for (int i = 0; i < roleSet.length; ++i) {
                if (!provider.isUserInRole(roleSet[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static void checkUserInRole(String[] roleSet) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null && roleSet != null) {
            for (int i = 0; i < roleSet.length; ++i) {
                if (!provider.isUserInRole(roleSet[i])) continue;
                return;
            }
            throw new EJBAccessException(L.l("permission denied for user {0}", provider.getUserPrincipal()));
        }
    }

    public static String runAs(String role) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.runAs(role);
        }
        return null;
    }

    public static boolean isTransportSecure() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.isTransportSecure();
        }
        return false;
    }

    public static SecurityContextProvider getProvider() {
        ProtocolConnection request = TcpSocketLink.getCurrentRequest();
        if (request instanceof SecurityContextProvider) {
            return (SecurityContextProvider)((Object)request);
        }
        return null;
    }
}

