/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security.openid;

import com.caucho.config.Config;
import com.caucho.security.openid.YadisXrd;
import com.caucho.util.L10N;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;

public class OpenIdRelay {
    private static final L10N L = new L10N(OpenIdRelay.class);
    private static final Logger log = Logger.getLogger(OpenIdRelay.class.getName());
    private static final String OPEN_ID_2_0_SERVER = "http://specs.openid.net/auth/2.0/server";

    public String discoverOpenId(String urlString) {
        String loc = this.lookupLocation(urlString);
        if (loc == null) {
            return null;
        }
        YadisXrd xrd = this.readXrd(loc);
        if (xrd == null) {
            return null;
        }
        String openIdUrl = xrd.findService(OPEN_ID_2_0_SERVER);
        return openIdUrl;
    }

    public String lookupLocation(String urlString) {
        HttpURLConnection conn;
        block15: {
            block14: {
                int code;
                block13: {
                    conn = null;
                    if (!urlString.startsWith("http")) {
                        urlString = "http://" + urlString;
                    }
                    URL url = new URL(urlString);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("HEAD");
                    HttpURLConnection.setFollowRedirects(true);
                    String host = urlString;
                    int p = host.indexOf("://");
                    host = host.substring(p + 3);
                    p = host.indexOf(47);
                    if (p > 0) {
                        host = host.substring(0, p);
                    }
                    conn.addRequestProperty("Host", host);
                    code = conn.getResponseCode();
                    String location = conn.getHeaderField("X-XRDS-Location");
                    if (location == null) break block13;
                    String string = location;
                    Object var10_13 = null;
                    if (conn != null) {
                        conn.disconnect();
                    }
                    return string;
                }
                if (code == 200) break block14;
                String string = null;
                Object var10_14 = null;
                if (conn != null) {
                    conn.disconnect();
                }
                return string;
            }
            if (!"application/xrds+xml".equals(conn.getHeaderField("Content-Type"))) break block15;
            String string = urlString;
            Object var10_15 = null;
            if (conn != null) {
                conn.disconnect();
            }
            return string;
        }
        try {
            String string = null;
            Object var10_16 = null;
            if (conn != null) {
                conn.disconnect();
            }
            return string;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                block16: {
                    Object var10_17 = null;
                    if (conn == null) break block16;
                    conn.disconnect();
                }
                throw throwable;
            }
        }
    }

    public YadisXrd readXrd(String urlString) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            conn.addRequestProperty("Accept", "application/xrds+xml");
            int code = conn.getResponseCode();
            String contentType = conn.getHeaderField("Content-Type");
            if (code != 200 || !"application/xrds+xml".equals(contentType)) {
                throw new RuntimeException(L.l("bad code '{0}' or content-type '{1}' for URL='{2}'", code, contentType, urlString));
            }
            InputStream is = conn.getInputStream();
            YadisXrd xrd = new YadisXrd();
            Config config = new Config();
            config.configure((Object)xrd, is);
            YadisXrd yadisXrd = xrd;
            Object var12_11 = null;
            if (conn != null) {
                conn.disconnect();
            }
            return yadisXrd;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var12_12 = null;
                    if (conn == null) break block6;
                    conn.disconnect();
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

