/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.bam.ActorError;
import com.caucho.bam.Broker;
import com.caucho.bam.QueryGet;
import com.caucho.bam.QuerySet;
import com.caucho.bam.SimpleActor;
import com.caucho.cloud.deploy.CopyTagQuery;
import com.caucho.cloud.deploy.RemoveTagQuery;
import com.caucho.cloud.deploy.SetTagQuery;
import com.caucho.config.ConfigException;
import com.caucho.config.Service;
import com.caucho.env.deploy.DeployControllerService;
import com.caucho.env.deploy.DeployTagItem;
import com.caucho.env.repository.RepositoryService;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.jmx.Jmx;
import com.caucho.management.server.DeployControllerMXBean;
import com.caucho.management.server.EAppMXBean;
import com.caucho.management.server.EarDeployMXBean;
import com.caucho.management.server.WebAppDeployMXBean;
import com.caucho.management.server.WebAppMXBean;
import com.caucho.server.admin.ControllerDeployQuery;
import com.caucho.server.admin.ControllerStartQuery;
import com.caucho.server.admin.ControllerStopQuery;
import com.caucho.server.admin.ControllerUndeployQuery;
import com.caucho.server.admin.DeployAddFileQuery;
import com.caucho.server.admin.DeployCommitListQuery;
import com.caucho.server.admin.DeploySendQuery;
import com.caucho.server.admin.HostQuery;
import com.caucho.server.admin.ListHostsQuery;
import com.caucho.server.admin.ListTagsQuery;
import com.caucho.server.admin.ListWebAppsQuery;
import com.caucho.server.admin.QueryTagsQuery;
import com.caucho.server.admin.StatusQuery;
import com.caucho.server.admin.TagQuery;
import com.caucho.server.admin.TagResult;
import com.caucho.server.admin.TagStateQuery;
import com.caucho.server.admin.UndeployQuery;
import com.caucho.server.admin.WebAppQuery;
import com.caucho.server.cluster.Server;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostController;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DeployActor
extends SimpleActor {
    private static final Logger log = Logger.getLogger(DeployActor.class.getName());
    private static final L10N L = new L10N(DeployActor.class);
    private Server _server;
    private RepositorySpi _repository;
    private AtomicBoolean _isInit = new AtomicBoolean();

    @Override
    public String getJid() {
        return "deploy@resin.caucho";
    }

    private Broker getBroker() {
        return this._server.getAdminBroker();
    }

    @PostConstruct
    public void init() {
        if (this._isInit.getAndSet(true)) {
            return;
        }
        this._server = Server.getCurrent();
        if (this._server == null) {
            throw new ConfigException(L.l("resin:DeployService requires an active Server.\n  {0}", Thread.currentThread().getContextClassLoader()));
        }
        this._repository = RepositoryService.getCurrentRepositorySpi();
        this.setLinkStream(this.getBroker().getBrokerStream());
        this.getBroker().addActor(this.getActorStream());
    }

    @QueryGet
    public boolean commitList(long id, String to, String from, DeployCommitListQuery commitList) {
        ArrayList<String> uncommittedList = new ArrayList<String>();
        if (commitList.getCommitList() != null) {
            for (String commit : commitList.getCommitList()) {
                if (this._repository.exists(commit)) continue;
                uncommittedList.add(commit);
            }
        }
        DeployCommitListQuery resultList = new DeployCommitListQuery(uncommittedList);
        this.getLinkStream().queryResult(id, from, to, resultList);
        return true;
    }

    @QuerySet
    public void tagCopy(long id, String to, String from, CopyTagQuery query) {
        String tag = query.getTag();
        String sourceTag = query.getSourceTag();
        RepositoryTagEntry entry = this._repository.getTagMap().get(sourceTag);
        if (entry == null) {
            log.fine(this + " copyError dst='" + query.getTag() + "' src='" + query.getSourceTag() + "'");
            this.getLinkStream().queryError(id, from, to, query, new ActorError("cancel", "item-not-found", "unknown tag"));
            return;
        }
        log.fine(this + " copy dst='" + query.getTag() + "' src='" + query.getSourceTag() + "'");
        String server = "default";
        TreeMap<String, String> metaDataMap = new TreeMap<String, String>();
        if (query.getAttributes() != null) {
            metaDataMap.putAll(query.getAttributes());
        }
        if (server != null) {
            metaDataMap.put("server", server);
        }
        boolean result = this._repository.putTag(tag, entry.getRoot(), metaDataMap);
        this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(result));
    }

    @QueryGet
    public void tagState(long id, String to, String from, TagStateQuery query) {
        String tag = query.getTag();
        DeployControllerService deploy = DeployControllerService.getCurrent();
        DeployTagItem item = null;
        if (deploy != null) {
            deploy.update(tag);
            item = deploy.getTagItem(tag);
        }
        if (item != null) {
            TagStateQuery result = new TagStateQuery(tag, item.getState(), item.getDeployException());
            this.getLinkStream().queryResult(id, from, to, result);
        } else {
            this.getLinkStream().queryResult(id, from, to, null);
        }
    }

    @QuerySet
    public void removeTag(long id, String to, String from, RemoveTagQuery query) {
        String server = "default";
        HashMap<String, String> commitMetaData = new HashMap<String, String>();
        if (query.getAttributes() != null) {
            commitMetaData.putAll(query.getAttributes());
        }
        commitMetaData.put("server", server);
        boolean result = this._repository.removeTag(query.getTag(), commitMetaData);
        this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @QuerySet
    public boolean sendFileQuery(long id, String to, String from, DeploySendQuery query) {
        String sha1 = query.getSha1();
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " sendFileQuery sha1=" + sha1);
        }
        InputStream is = null;
        try {
            try {
                is = query.getInputStream();
                this._repository.writeRawGitFile(sha1, is);
                this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(true));
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(false));
                Object var10_8 = null;
                IoUtil.close(is);
                return true;
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            IoUtil.close(is);
            throw throwable;
        }
        IoUtil.close(is);
        return true;
    }

    @QuerySet
    public boolean setTagQuery(long id, String to, String from, SetTagQuery query) {
        String tagName = query.getTag();
        String contentHash = query.getContentHash();
        if (contentHash == null) {
            throw new NullPointerException();
        }
        String server = "default";
        TreeMap<String, String> commitMetaData = new TreeMap<String, String>();
        if (query.getAttributes() != null) {
            commitMetaData.putAll(query.getAttributes());
        }
        commitMetaData.put("server", server);
        boolean result = this._repository.putTag(tagName, contentHash, commitMetaData);
        this.getLinkStream().queryResult(id, from, to, (Serializable)((Object)String.valueOf(result)));
        return true;
    }

    @QueryGet
    public boolean queryTags(long id, String to, String from, QueryTagsQuery tagsQuery) {
        ArrayList<TagResult> tags = new ArrayList<TagResult>();
        Pattern pattern = Pattern.compile(tagsQuery.getPattern());
        for (Map.Entry<String, RepositoryTagEntry> entry : this._repository.getTagMap().entrySet()) {
            String tag = entry.getKey();
            if (!pattern.matcher(tag).matches()) continue;
            tags.add(new TagResult(tag, entry.getValue().getRoot()));
        }
        this.getLinkStream().queryResult(id, from, to, (Serializable)tags.toArray(new TagResult[tags.size()]));
        return true;
    }

    @QuerySet
    public boolean controllerDeploy(long id, String to, String from, ControllerDeployQuery query) {
        String status = this.deploy(query.getTag());
        log.fine(this + " deploy '" + query.getTag() + "' -> " + status);
        this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(true));
        return true;
    }

    private String deploy(String gitPath) {
        int p = gitPath.indexOf(47);
        int q = gitPath.indexOf(47, p + 1);
        int r = gitPath.lastIndexOf(47);
        if (p < 0 || q < 0 || r < 0 || r <= q) {
            return L.l("'{0}' is an unknown type", gitPath);
        }
        String type = gitPath.substring(0, p);
        String name = gitPath.substring(r + 1);
        try {
            ObjectName pattern;
            Iterator<Object> i$;
            if (type.equals("ears")) {
                ObjectName pattern2 = new ObjectName("resin:type=EarDeploy,*");
                Iterator<Object> i$2 = Jmx.query(pattern2).iterator();
                if (i$2.hasNext()) {
                    Object proxy = i$2.next();
                    EarDeployMXBean earDeploy = (EarDeployMXBean)proxy;
                    earDeploy.deploy(name);
                    return this.statusMessage(gitPath);
                }
            } else if (type.equals("wars") && (i$ = Jmx.query(pattern = new ObjectName("resin:type=WebAppDeploy,*")).iterator()).hasNext()) {
                Object proxy = i$.next();
                WebAppDeployMXBean warDeploy = (WebAppDeployMXBean)proxy;
                warDeploy.deploy(name);
                return this.statusMessage(gitPath);
            }
            return L.l("'{0}' is an unknown type", gitPath);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return L.l("deploy '{0}' failed\n{1}", (Object)gitPath, e.toString());
        }
    }

    @QuerySet
    public boolean controllerStart(long id, String to, String from, ControllerStartQuery query) {
        String status = this.start(query.getTag());
        log.fine(this + " start '" + query.getTag() + "' -> " + status);
        this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(true));
        return true;
    }

    private String start(String tag) {
        DeployControllerMXBean controller = this.findController(tag);
        if (controller == null) {
            return L.l("'{0}' is an unknown controller", controller);
        }
        try {
            controller.start();
            return controller.getState();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return e.toString();
        }
    }

    @QuerySet
    public boolean controllerStop(long id, String to, String from, ControllerStopQuery query) {
        String status = this.stop(query.getTag());
        log.fine(this + " stop '" + query.getTag() + "' -> " + status);
        this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(true));
        return true;
    }

    private String stop(String tag) {
        DeployControllerMXBean controller = this.findController(tag);
        if (controller == null) {
            return L.l("'{0}' is an unknown controller", controller);
        }
        try {
            controller.stop();
            return controller.getState();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return e.toString();
        }
    }

    @QuerySet
    public boolean controllerUndeploy(long id, String to, String from, ControllerUndeployQuery query) {
        String status = this.undeploy(query.getTag());
        log.fine(this + " undeploy '" + query.getTag() + "' -> " + status);
        this.getLinkStream().queryResult(id, from, to, Boolean.valueOf(true));
        return true;
    }

    private String undeploy(String tag) {
        DeployControllerMXBean controller = this.findController(tag);
        if (controller == null) {
            return L.l("'{0}' is an unknown controller", controller);
        }
        try {
            Path root = Vfs.lookup(controller.getRootDirectory());
            root.removeAll();
            controller.stop();
            if (controller.destroy()) {
                return "undeployed";
            }
            return L.l("'{0}' failed to undeploy application '{1}'", (Object)controller, tag);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return e.toString();
        }
    }

    @QuerySet
    public boolean controllerUndeploy(long id, String to, String from, UndeployQuery query) {
        throw new UnsupportedOperationException();
    }

    private String undeploy(String tag, Map<String, String> commitMetaData) {
        DeployControllerMXBean controller = this.findController(tag);
        if (controller == null) {
            return L.l("'{0}' is an unknown controller", controller);
        }
        try {
            Path root = Vfs.lookup(controller.getRootDirectory());
            root.removeAll();
            controller.stop();
            if (controller.destroy()) {
                String server = "default";
                HashMap<String, String> metaDataCopy = new HashMap<String, String>();
                if (commitMetaData != null) {
                    metaDataCopy.putAll(commitMetaData);
                }
                metaDataCopy.put("server", server);
                this._repository.removeTag(tag, metaDataCopy);
                return "undeployed";
            }
            return L.l("'{0}' failed to remove application '{1}'", (Object)controller, tag);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return e.toString();
        }
    }

    @QuerySet
    public boolean sendAddFileQuery(long id, String to, String from, DeployAddFileQuery query) {
        String tag = query.getTag();
        String name = query.getName();
        String contentHash = query.getHex();
        try {
            DeployControllerMXBean deploy = this.findController(tag);
            if (deploy == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " sendAddFileQuery '" + tag + "' is an unknown DeployController");
                }
                this.getLinkStream().queryResult(id, from, to, (Serializable)((Object)("no-deploy: " + tag)));
                return true;
            }
            Path root = Vfs.lookup(deploy.getRootDirectory());
            Path path = (root = root.createRoot()).lookup(name);
            if (!path.getParent().exists()) {
                path.getParent().mkdirs();
            }
            this._repository.expandToPath(contentHash, path);
            this.getLinkStream().queryResult(id, from, to, (Serializable)((Object)"ok"));
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            this.getLinkStream().queryResult(id, from, to, (Serializable)((Object)"fail"));
            return true;
        }
    }

    @QueryGet
    public boolean listWebApps(long id, String to, String from, ListWebAppsQuery listQuery) {
        ArrayList<WebAppQuery> apps = new ArrayList<WebAppQuery>();
        String stage = this._server.getStage();
        for (HostController host : this._server.getHostControllers()) {
            if (!listQuery.getHost().equals(host.getName())) continue;
            WebAppContainer webAppContainer = ((Host)host.getDeployInstance()).getWebAppContainer();
            for (WebAppController webApp : webAppContainer.getWebAppList()) {
                WebAppQuery q = new WebAppQuery();
                String name = webApp.getId();
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                q.setTag("wars/" + stage + "/" + host.getName() + "/" + name);
                q.setHost(host.getName());
                q.setUrl(webApp.getURL());
                apps.add(q);
            }
        }
        this.getLinkStream().queryResult(id, from, to, (Serializable)apps.toArray(new WebAppQuery[apps.size()]));
        return true;
    }

    @QueryGet
    public boolean listTags(long id, String to, String from, ListTagsQuery listQuery) {
        ArrayList<TagQuery> tags = new ArrayList<TagQuery>();
        for (String tag : this._repository.getTagMap().keySet()) {
            int p;
            int q;
            if (!tag.startsWith("wars/default") && !tag.startsWith("ears/default") || (q = tag.indexOf(47, (p = "wars/default/".length()) + 1)) < 0) continue;
            String host = tag.substring(p, q);
            tags.add(new TagQuery(host, tag));
        }
        this.getLinkStream().queryResult(id, from, to, (Serializable)tags.toArray(new TagQuery[tags.size()]));
        return true;
    }

    @QueryGet
    public boolean listHosts(long id, String to, String from, ListHostsQuery query) {
        ArrayList<HostQuery> hosts = new ArrayList<HostQuery>();
        for (HostController controller : this._server.getHostControllers()) {
            if ("admin.resin".equals(controller.getName())) continue;
            HostQuery q = new HostQuery();
            q.setName(controller.getName());
            hosts.add(q);
        }
        this.getLinkStream().queryResult(id, from, to, (Serializable)hosts.toArray(new HostQuery[hosts.size()]));
        return true;
    }

    @QueryGet
    public boolean status(long id, String to, String from, StatusQuery query) {
        String tag = query.getTag();
        String errorMessage = this.statusMessage(tag);
        String state = null;
        StatusQuery result = new StatusQuery(tag, state, errorMessage);
        this.getLinkStream().queryResult(id, from, to, result);
        return true;
    }

    private String statusMessage(String tag) {
        int p = tag.indexOf(47);
        int q = tag.indexOf(47, p + 1);
        int r = tag.lastIndexOf(47);
        if (p < 0 || q < 0 || r < 0) {
            return L.l("'{0}' is an unknown type", tag);
        }
        String type = tag.substring(0, p);
        String host = tag.substring(q + 1, r);
        String name = tag.substring(r + 1);
        String errorMessage = tag + " is an unknown resource";
        try {
            if (type.equals("ears")) {
                String pattern = "resin:type=EApp,Host=" + host + ",name=" + name;
                EAppMXBean ear = (EAppMXBean)Jmx.findGlobal(pattern);
                if (ear != null) {
                    ear.update();
                    errorMessage = ear.getErrorMessage();
                    return errorMessage;
                }
                return L.l("'{0}' is an unknown ear", tag);
            }
            if (type.equals("wars")) {
                String pattern = "resin:type=WebApp,Host=" + host + ",name=/" + name;
                WebAppMXBean war = (WebAppMXBean)Jmx.findGlobal(pattern);
                if (war != null) {
                    war.update();
                    errorMessage = war.getErrorMessage();
                    return errorMessage;
                }
                return L.l("'{0}' is an unknown war", tag);
            }
            return L.l("'{0}' is an unknown tag", tag);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return errorMessage;
        }
    }

    private DeployControllerMXBean findController(String tag) {
        String name;
        String host;
        int p = tag.indexOf(47);
        int q = tag.indexOf(47, p + 1);
        int r = tag.lastIndexOf(47);
        if (p < 0 || q < 0 || r < 0) {
            return null;
        }
        String type = tag.substring(0, p);
        if (q < r) {
            host = tag.substring(q + 1, r);
            name = tag.substring(r + 1);
        } else {
            host = tag.substring(q + 1);
            name = "";
        }
        try {
            if (type.equals("ears")) {
                String pattern = "resin:type=EApp,Host=" + host + ",name=" + name;
                EAppMXBean ear = (EAppMXBean)Jmx.findGlobal(pattern);
                return ear;
            }
            if (type.equals("wars")) {
                String pattern = "resin:type=WebApp,Host=" + host + ",name=/" + name;
                WebAppMXBean war = (WebAppMXBean)Jmx.findGlobal(pattern);
                return war;
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        return null;
    }
}

