/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.config.ConfigException;
import com.caucho.server.admin.TransactionManager;
import com.caucho.server.cluster.Server;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.xalog.AbstractXALogManager;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransactionLog {
    private static final Logger log = Logger.getLogger(TransactionLog.class.getName());
    private static final L10N L = new L10N(TransactionLog.class);
    private final TransactionManager _manager;
    private boolean _isEnable = true;
    private String _path;
    private AbstractXALogManager _xaLog;

    public TransactionLog(TransactionManager manager) {
        this._manager = manager;
    }

    public void setPath(String path) throws IOException {
        this._path = path;
    }

    public boolean isEnable() {
        return this._isEnable;
    }

    public void setEnable(boolean enable) {
        this._isEnable = enable;
    }

    public void start() {
        if (this._path == null) {
            Server server = Server.getCurrent();
            if (server == null) {
                return;
            }
            String serverId = server.getServerId();
            if (serverId == null || serverId.length() == 0) {
                serverId = "default";
            }
            this._path = "xa-" + serverId + ".log";
        }
        if (!this._isEnable) {
            return;
        }
        try {
            Class<?> cl = Class.forName("com.caucho.transaction.xalog.XALogManager");
            this._xaLog = (AbstractXALogManager)cl.newInstance();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (this._xaLog == null) {
            throw new ConfigException(L.l("<transaction-log> requires Resin Professional.  See http://www.caucho.com for information and licensing."));
        }
        try {
            if (this._manager.getPath() != null) {
                this._xaLog.setPath(this._manager.getPath().lookup(this._path));
            } else {
                this._xaLog.setPath(Vfs.lookup(this._path));
            }
            TransactionManagerImpl tm = TransactionManagerImpl.getLocal();
            tm.setXALogManager(this._xaLog);
            this._xaLog.start();
        }
        catch (IOException e) {
            throw ConfigException.create(e);
        }
    }

    public void destroy() {
        AbstractXALogManager xaLog = this._xaLog;
        this._xaLog = null;
        if (xaLog != null) {
            try {
                xaLog.close();
            }
            catch (Exception ex) {
                log.log(Level.INFO, ex.toString(), ex);
            }
        }
    }
}

