/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cache;

import com.caucho.config.ConfigException;
import com.caucho.db.Database;
import com.caucho.db.block.BlockStore;
import com.caucho.server.cache.TempFileInode;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.logging.Logger;

public class TempFileManager {
    private static final L10N L = new L10N(TempFileManager.class);
    private static final Logger log = Logger.getLogger(TempFileManager.class.getName());
    private final BlockStore _store;

    public TempFileManager(Path path) {
        try {
            path.getParent().mkdirs();
            Database database = new Database();
            database.ensureMemoryCapacity(0x100000L);
            database.init();
            Resin resin = Resin.getCurrent();
            String serverId = "";
            if (resin != null) {
                serverId = resin.getUniqueServerName();
            }
            if ("".equals(serverId)) {
                serverId = "default";
            }
            String name = "temp_file_" + serverId;
            Path storePath = path.lookup(name);
            storePath.remove();
            if (storePath.exists()) {
                log.warning(L.l("Removal of old temp file '{0}' failed. Please check permissions.", storePath.getNativePath()));
            }
            this._store = new BlockStore(database, name, null, storePath);
            this._store.setFlushDirtyBlocksOnCommit(false);
            this._store.create();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public TempFileInode createInode() {
        return new TempFileInode(this._store);
    }
}

