/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cache;

import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectoryService;
import com.caucho.server.cache.TempFileManager;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;

public class TempFileService
extends AbstractResinService {
    private static final L10N L = new L10N(TempFileService.class);
    private final TempFileManager _manager;

    private TempFileService(TempFileManager manager) {
        this._manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TempFileService create() {
        Class<TempFileService> clazz = TempFileService.class;
        synchronized (TempFileService.class) {
            ResinSystem resinSystem = ResinSystem.getCurrent();
            if (resinSystem == null) {
                throw new IllegalStateException(L.l("TempFileService cannot start because it depends on ResinSystem"));
            }
            TempFileService service = resinSystem.getService(TempFileService.class);
            if (service == null) {
                RootDirectoryService rootService = RootDirectoryService.getCurrent();
                if (rootService == null) {
                    throw new IllegalStateException(L.l("TempFileService cannot start because it depends on RootDirectoryService"));
                }
                Path dataDirectory = rootService.getDataDirectory();
                TempFileManager manager = new TempFileManager(dataDirectory.lookup("tmp"));
                service = new TempFileService(manager);
                resinSystem.addService(service);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public TempFileManager getManager() {
        return this._manager;
    }
}

