/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.config.ConfigException;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.OwnerServerTriad;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClusterPod {
    private static final L10N L = new L10N(ClusterPod.class);
    private static final Logger log = Logger.getLogger(ClusterPod.class.getName());
    public static final Owner[] OWNER_VALUES = (Owner[])Owner.class.getEnumConstants();
    private final Cluster _cluster;
    private final int _index;
    private String _id;

    protected ClusterPod(Cluster cluster, int index) {
        this._cluster = cluster;
        this._index = index;
        this._id = index == 0 ? "main" : String.valueOf(index);
    }

    public String getId() {
        return this._id;
    }

    public int getIndex() {
        return this._index;
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public abstract ClusterServer[] getServerList();

    public abstract ArrayList<ClusterServer> getStaticServerList();

    public abstract ClusterServer getServerA();

    public abstract ClusterServer getServerB();

    public abstract ClusterServer getServerC();

    public boolean isTriad(ClusterServer server) {
        return this.getServerA() == server || this.getServerB() == server || this.getServerC() == server;
    }

    public ClusterServer findServer(int index) {
        for (ClusterServer server : this.getServerList()) {
            if (server == null || server.getIndex() != index) continue;
            return server;
        }
        return null;
    }

    public abstract ClusterServer createServer();

    public void addServer(ClusterServer server) {
    }

    public void addDynamicServer(String serverId, String address, int port) throws ConfigException {
        throw new ConfigException(L.l("addDynamicServer requires Resin Professional"));
    }

    public void removeDynamicServer(String serverId, String address, int port) throws ConfigException {
        throw new ConfigException(L.l("removeDynamicServer requires Resin Professional"));
    }

    public ClusterServer setActiveDynamicServer(String serverId, String address, int port, int index) throws ConfigException {
        throw new ConfigException(L.l("setDynamicServer requires Resin Professional"));
    }

    public void init() {
        for (ClusterServer server : this.getServerList()) {
            try {
                server.init();
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
    }

    public void start() {
    }

    public void update() {
    }

    public void close() {
        for (ClusterServer server : this.getServerList()) {
            try {
                server.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public ClusterServer findServer(String id) {
        for (ClusterServer server : this.getServerList()) {
            if (server == null || !id.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    public ClusterServer findServerByPrefix(String id) {
        for (ClusterServer server : this.getServerList()) {
            if (server == null || !id.equals(server.getServerClusterId())) continue;
            return server;
        }
        return null;
    }

    public ClusterServer findServer(String address, int port) {
        for (ClusterServer server : this.getServerList()) {
            if (server == null || !address.equals(server.getAddress()) || port != server.getPort()) continue;
            return server;
        }
        return null;
    }

    public abstract OwnerServerTriad getOwnerServerTriad(Owner var1);

    public ClusterServer getPrimary(Owner owner) {
        switch (owner) {
            case A_B: 
            case A_C: {
                return this.getServerA();
            }
            case B_C: 
            case B_A: {
                if (this.getServerB() != null) {
                    return this.getServerB();
                }
                return this.getServerA();
            }
            case C_A: {
                if (this.getServerC() != null) {
                    return this.getServerC();
                }
                return this.getServerB();
            }
            case C_B: {
                if (this.getServerC() != null) {
                    return this.getServerC();
                }
                return this.getServerA();
            }
        }
        throw new IllegalStateException(L.l("'{0}' is an unknown owner", (Object)owner));
    }

    public ClusterServer getSecondary(Owner owner) {
        if (this.getServerB() == null) {
            return null;
        }
        switch (owner) {
            case B_A: 
            case C_A: {
                return this.getServerA();
            }
            case A_B: {
                if (this.getServerB() != null) {
                    return this.getServerB();
                }
                return this.getServerC();
            }
            case A_C: {
                if (this.getServerC() != null) {
                    return this.getServerC();
                }
                return this.getServerB();
            }
            case B_C: {
                if (this.getServerC() != null) {
                    return this.getServerC();
                }
                return this.getServerA();
            }
            case C_B: {
                if (this.getServerB() != null) {
                    return this.getServerB();
                }
                return this.getServerA();
            }
        }
        throw new IllegalStateException(L.l("'{0}' is an unknown owner", (Object)owner));
    }

    public ClusterServer getTertiary(Owner owner) {
        if (this.getServerC() == null) {
            return null;
        }
        switch (owner) {
            case B_C: 
            case C_B: {
                return this.getServerA();
            }
            case A_C: 
            case C_A: {
                return this.getServerB();
            }
            case A_B: 
            case B_A: {
                return this.getServerC();
            }
        }
        throw new IllegalStateException(L.l("'{0}' is an unknown owner", (Object)owner));
    }

    public ClusterServer getActiveServer(Owner owner, ClusterServer oldServer) {
        ClientSocketFactory pool;
        ClusterServer server = this.getPrimary(owner);
        if (server != null && server.isActive() && (pool = server.getServerPool()) != null && pool.isActive() && server != oldServer) {
            return server;
        }
        server = this.getSecondary(owner);
        if (server != null && server.isActive() && (pool = server.getServerPool()) != null && pool.isActive() && server != oldServer) {
            return server;
        }
        server = this.getTertiary(owner);
        if (server != null && server.isActive() && (pool = server.getServerPool()) != null && pool.isActive() && server != oldServer) {
            return server;
        }
        server = this.getPrimary(owner);
        ClientSocketFactory clientSocketFactory = pool = server != null ? server.getServerPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        server = this.getSecondary(owner);
        ClientSocketFactory clientSocketFactory2 = pool = server != null ? server.getServerPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        server = this.getTertiary(owner);
        ClientSocketFactory clientSocketFactory3 = pool = server != null ? server.getServerPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        return null;
    }

    public ClusterServer getActiveOrSelfServer(Owner owner, ClusterServer oldServer) {
        ClientSocketFactory pool;
        ClusterServer server = this.getPrimary(owner);
        if (server != null && server.isActive()) {
            pool = server.getServerPool();
            if (pool == null) {
                return server;
            }
            if (pool.isActive() && server != oldServer) {
                return server;
            }
        }
        if ((server = this.getSecondary(owner)) != null && server.isActive()) {
            pool = server.getServerPool();
            if (pool == null) {
                return server;
            }
            if (pool.isActive() && server != oldServer) {
                return server;
            }
        }
        if ((server = this.getTertiary(owner)) != null && server.isActive()) {
            pool = server.getServerPool();
            if (pool == null) {
                return server;
            }
            if (pool.isActive() && server != oldServer) {
                return server;
            }
        }
        ClientSocketFactory clientSocketFactory = pool = (server = this.getPrimary(owner)) != null ? server.getServerPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        server = this.getSecondary(owner);
        ClientSocketFactory clientSocketFactory2 = pool = server != null ? server.getServerPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        server = this.getTertiary(owner);
        ClientSocketFactory clientSocketFactory3 = pool = server != null ? server.getServerPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        return null;
    }

    public static Owner getOwner(long index) {
        return OWNER_VALUES[(int)((index & Long.MAX_VALUE) % (long)OWNER_VALUES.length)];
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getIndex() + "," + this.getId() + ",cluster=" + this._cluster.getId() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Owner {
        A_B,
        B_C,
        C_A,
        A_C,
        B_A,
        C_B;

    }
}

