/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ContainerProgram;
import com.caucho.network.listen.AbstractProtocol;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolPortConfig
extends SocketLinkListener {
    private static final L10N L = new L10N(ProtocolPortConfig.class);
    private Class<?> _protocolClass;
    private ContainerProgram _init;

    public void setType(Class<?> cl) {
        this.setClass(cl);
    }

    public void setClass(Class<?> cl) {
        Config.validate(cl, AbstractProtocol.class);
        this._protocolClass = cl;
    }

    public void setInit(ContainerProgram init) {
        if (this._protocolClass == null) {
            throw new ConfigException(L.l("<init> requires a protocol class"));
        }
        this._init = init;
    }

    public void add(Protocol protocol) {
        this.setProtocol(protocol);
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        if (this.getProtocol() == null) {
            if (this._protocolClass != null) {
                InjectManager webBeans = InjectManager.create();
                InjectionTarget<?> target = webBeans.createInjectionTarget(this._protocolClass);
                CreationalContext env = webBeans.createCreationalContext(null);
                AbstractProtocol protocol = (AbstractProtocol)target.produce(env);
                target.inject((Object)protocol, env);
                if (this._init != null) {
                    this._init.configure(protocol);
                }
                target.postConstruct((Object)protocol);
                this.setProtocol(protocol);
            } else {
                throw new ConfigException(L.l("protocol requires either a class"));
            }
        }
        super.init();
    }
}

