/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.annotation.DisableConfig;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.InitParam;
import com.caucho.server.dispatch.FilterManager;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterConfigImpl
implements FilterConfig,
FilterRegistration.Dynamic {
    private String _filterName;
    private String _filterClassName;
    private Class<?> _filterClass;
    private String _displayName;
    private HashMap<String, String> _initParams = new HashMap();
    private ContainerProgram _init;
    private WebApp _webApp;
    private ServletContext _servletContext;
    private FilterManager _filterManager;
    private Filter _filter;
    private boolean _isAsyncSupported;

    public void setId(String id) {
    }

    public void setFilterName(String name) {
        this._filterName = name;
    }

    public String getFilterName() {
        return this._filterName;
    }

    public void setFilterClass(String filterClassName) throws ConfigException, ClassNotFoundException {
        this._filterClassName = filterClassName;
        this._filterClass = CauchoSystem.loadClass(filterClassName);
        Config.validate(this._filterClass, Filter.class);
    }

    @DisableConfig
    public void setFilterClass(Class<?> filterClass) {
        this._filterClass = filterClass;
        Config.validate(this._filterClass, Filter.class);
    }

    public Class<?> getFilterClass() {
        return this._filterClass;
    }

    public String getFilterClassName() {
        return this._filterClassName;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    public void setInitParam(String param, String value) {
        this._initParams.put(param, value);
    }

    public void setInitParam(InitParam initParam) {
        this._initParams.putAll(initParam.getParameters());
    }

    public Map<String, String> getInitParamMap() {
        return this._initParams;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public void setWebApp(WebApp webApp) {
        this._webApp = webApp;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext app) {
        this._servletContext = app;
    }

    public FilterManager getFilterManager() {
        return this._filterManager;
    }

    public void setFilterManager(FilterManager filterManager) {
        this._filterManager = filterManager;
    }

    public void setInit(ContainerProgram init) {
        this._init = init;
    }

    public ContainerProgram getInit() {
        return this._init;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        try {
            FilterMapping mapping = new FilterMapping();
            mapping.setServletContext(this._webApp);
            mapping.setFilterName(this._filterName);
            if (dispatcherTypes != null) {
                for (DispatcherType dispatcherType : dispatcherTypes) {
                    mapping.addDispatcher(dispatcherType);
                }
            }
            for (String servletName : servletNames) {
                mapping.addServletName(servletName);
            }
            this._webApp.addFilterMapping(mapping);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Collection<String> getServletNameMappings() {
        Set<String> names = this._filterManager.getServletNameMappings(this._filterName);
        if (names == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(names);
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        try {
            FilterMapping mapping = new FilterMapping();
            mapping.setServletContext(this._webApp);
            mapping.setFilterName(this._filterName);
            if (dispatcherTypes != null) {
                for (DispatcherType dispatcherType : dispatcherTypes) {
                    mapping.addDispatcher(dispatcherType);
                }
            }
            FilterMapping.URLPattern urlPattern = mapping.createUrlPattern();
            for (String pattern : urlPatterns) {
                urlPattern.addText(pattern);
            }
            urlPattern.init();
            this._webApp.addFilterMapping(mapping);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Collection<String> getUrlPatternMappings() {
        Set<String> patterns = this._filterManager.getUrlPatternMappings(this._filterName);
        if (patterns == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(patterns);
    }

    public String getName() {
        return this._filterName;
    }

    public String getClassName() {
        return this._filterClassName;
    }

    public boolean setInitParameter(String name, String value) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        if (this._initParams.containsKey(name)) {
            return false;
        }
        this._initParams.put(name, value);
        return true;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        HashSet<String> conflicts = new HashSet<String>();
        for (Map.Entry<String, String> parameter : initParameters.entrySet()) {
            if (this._initParams.containsKey(parameter.getKey())) {
                conflicts.add(parameter.getKey());
                continue;
            }
            this._initParams.put(parameter.getKey(), parameter.getValue());
        }
        return conflicts;
    }

    public Map<String, String> getInitParameters() {
        return this._initParams;
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        if (this._webApp != null && !this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this._isAsyncSupported = isAsyncSupported;
    }

    public boolean isAsyncSupported() {
        return this._isAsyncSupported;
    }

    public void setDescription(String description) {
    }

    public void setIcon(String icon) {
    }

    public String toString() {
        return "FilterConfigImpl[name=" + this._filterName + ",class=" + this._filterClass + "]";
    }
}

