/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMapping
extends FilterConfigImpl {
    static L10N L = new L10N(FilterMapping.class);
    private String _urlPattern;
    private final LinkedHashSet<String> _urlPatterns = new LinkedHashSet();
    private final ArrayList<String> _servletNames = new ArrayList();
    private final ArrayList<Match> _matchList = new ArrayList();
    private HashSet<DispatcherType> _dispatcher;

    public URLPattern createUrlPattern() throws ServletException {
        return new URLPattern();
    }

    public String getURLPattern() {
        return this._urlPattern;
    }

    public HashSet<String> getURLPatterns() {
        return this._urlPatterns;
    }

    public void setURLRegexp(String pattern) throws ServletException {
        Pattern regexp = CauchoSystem.isCaseInsensitive() ? Pattern.compile(pattern, 2) : Pattern.compile(pattern, 0);
        this._matchList.add(Match.createInclude(regexp));
    }

    public void addServletName(String servletName) {
        if (servletName == null) {
            throw new NullPointerException();
        }
        this._servletNames.add(servletName);
    }

    public ArrayList<String> getServletNames() {
        return this._servletNames;
    }

    public void addDispatcher(String dispatcher) throws ConfigException {
        try {
            this.addDispatcher(DispatcherType.valueOf((String)dispatcher));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(L.l("'{0}' is an unknown value for <dispatcher>  'REQUEST', 'FORWARD', 'INCLUDE', and 'ERROR' are the valid values.", dispatcher));
        }
    }

    public void addDispatcher(DispatcherType dispather) {
        if (this._dispatcher == null) {
            this._dispatcher = new HashSet();
        }
        this._dispatcher.add(dispather);
    }

    public boolean isRequest() {
        return this._dispatcher == null || this._dispatcher.contains(DispatcherType.REQUEST);
    }

    public boolean isInclude() {
        return this._dispatcher != null && this._dispatcher.contains(DispatcherType.INCLUDE);
    }

    public boolean isForward() {
        return this._dispatcher != null && this._dispatcher.contains(DispatcherType.FORWARD);
    }

    public boolean isError() {
        return this._dispatcher != null && this._dispatcher.contains(DispatcherType.ERROR);
    }

    boolean isMatch(String servletName) {
        for (int i = 0; i < this._servletNames.size(); ++i) {
            String matchName = this._servletNames.get(i);
            if (!matchName.equals(servletName) && !"*".equals(matchName)) continue;
            return true;
        }
        return false;
    }

    boolean isMatch(ServletInvocation invocation) {
        return this.isMatch(invocation.getServletPath(), invocation.getPathInfo());
    }

    public boolean isMatch(String servletPath, String pathInfo) {
        String uri = pathInfo == null ? servletPath : (servletPath == null ? pathInfo : servletPath + pathInfo);
        int size = this._matchList.size();
        for (int i = 0; i < size; ++i) {
            Match match = this._matchList.get(i);
            int value = match.match(uri);
            switch (value) {
                case 1: {
                    return true;
                }
                case -1: {
                    return false;
                }
            }
        }
        return false;
    }

    private Pattern urlPatternToRegexp(String pattern, int flags) throws ServletException {
        if (pattern.length() == 0 || pattern.length() == 1 && pattern.charAt(0) == '/') {
            try {
                return Pattern.compile("^/$", flags);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        int length = pattern.length();
        boolean isExact = true;
        if (pattern.charAt(0) != '/' && pattern.charAt(0) != '*') {
            pattern = "/" + pattern;
            ++length;
        }
        int prefixLength = -1;
        boolean isShort = false;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '*' && i + 1 == length && i > 0) {
                isExact = false;
                if (pattern.charAt(i - 1) == '/') {
                    cb.setLength(cb.length() - 1);
                    if (prefixLength < 0) {
                        prefixLength = i - 1;
                    }
                } else if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (prefixLength != 0) continue;
                prefixLength = 1;
                continue;
            }
            if (ch == '*') {
                isExact = false;
                cb.append(".*");
                if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (i != 0) continue;
                isShort = true;
                continue;
            }
            if (ch == '.' || ch == '[' || ch == '^' || ch == '$' || ch == '{' || ch == '}' || ch == '|' || ch == '(' || ch == ')' || ch == '?') {
                cb.append('\\');
                cb.append(ch);
                continue;
            }
            cb.append(ch);
        }
        if (isExact) {
            cb.append('$');
        } else {
            cb.append("(?=/)|" + cb.toString() + "$");
        }
        try {
            return Pattern.compile(cb.close(), flags);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "FilterMapping[pattern=" + this._urlPattern + ",name=" + this.getFilterName() + "]";
    }

    static class Match {
        static final int INCLUDE = 1;
        static final int EXCLUDE = -1;
        static final int NO_MATCH = 0;
        private final Pattern _regexp;
        private final int _value;

        private Match(Pattern regexp, int value) {
            this._regexp = regexp;
            this._value = value;
        }

        static Match createInclude(Pattern regexp) {
            return new Match(regexp, 1);
        }

        static Match createExclude(Pattern regexp) {
            return new Match(regexp, -1);
        }

        int match(String uri) {
            if (this._regexp.matcher(uri).find()) {
                return this._value;
            }
            return 0;
        }
    }

    public class URLPattern {
        boolean _hasInclude = false;

        public URLPattern addText(String pattern) throws ServletException {
            pattern = pattern.trim();
            FilterMapping.this._urlPattern = pattern;
            FilterMapping.this._urlPatterns.add(pattern);
            Pattern regexp = CauchoSystem.isCaseInsensitive() ? FilterMapping.this.urlPatternToRegexp(pattern, 2) : FilterMapping.this.urlPatternToRegexp(pattern, 0);
            this._hasInclude = true;
            FilterMapping.this._matchList.add(Match.createInclude(regexp));
            return this;
        }

        public void addIncludePattern(String pattern) throws ServletException {
            pattern = pattern.trim();
            Pattern regexp = CauchoSystem.isCaseInsensitive() ? FilterMapping.this.urlPatternToRegexp(pattern, 2) : FilterMapping.this.urlPatternToRegexp(pattern, 0);
            this._hasInclude = true;
            FilterMapping.this._matchList.add(Match.createInclude(regexp));
        }

        public void addExcludePattern(String pattern) throws ServletException {
            pattern = pattern.trim();
            Pattern regexp = CauchoSystem.isCaseInsensitive() ? FilterMapping.this.urlPatternToRegexp(pattern, 2) : FilterMapping.this.urlPatternToRegexp(pattern, 0);
            FilterMapping.this._matchList.add(Match.createExclude(regexp));
        }

        public void addIncludeRegexp(String pattern) {
            pattern = pattern.trim();
            Pattern regexp = CauchoSystem.isCaseInsensitive() ? Pattern.compile(pattern, 2) : Pattern.compile(pattern, 0);
            this._hasInclude = true;
            FilterMapping.this._matchList.add(Match.createInclude(regexp));
        }

        public void addExcludeRegexp(String pattern) {
            pattern = pattern.trim();
            Pattern regexp = CauchoSystem.isCaseInsensitive() ? Pattern.compile(pattern, 2) : Pattern.compile(pattern, 0);
            FilterMapping.this._matchList.add(Match.createExclude(regexp));
        }

        @PostConstruct
        public void init() throws Exception {
            if (FilterMapping.this._matchList.size() > 0 && !this._hasInclude) {
                Pattern regexp = Pattern.compile("");
                FilterMapping.this._matchList.add(Match.createInclude(regexp));
            }
        }
    }
}

