/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.i18n.CharacterEncoding;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.ByteToChar;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InvocationDecoder {
    private static final Logger log = Logger.getLogger(InvocationDecoder.class.getName());
    private static final L10N L = new L10N(InvocationDecoder.class);
    private static final FreeList<ByteToChar> _freeConverters = new FreeList(256);
    private String _encoding = CharacterEncoding.getLocalEncoding();
    private String _sessionCookie = "JSESSIONID";
    private String _sslSessionCookie;
    private String _sessionSuffix = ";jsessionid=";
    private String _sessionPrefix;
    private int _maxURILength = 1024;

    public InvocationDecoder() {
        if (this._encoding == null) {
            this._encoding = "UTF-8";
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setSessionCookie(String cookie) {
        this._sessionCookie = cookie;
    }

    public String getSessionCookie() {
        return this._sessionCookie;
    }

    public void setSSLSessionCookie(String cookie) {
        this._sslSessionCookie = cookie;
    }

    public String getSSLSessionCookie() {
        if (this._sslSessionCookie != null) {
            return this._sslSessionCookie;
        }
        return this._sessionCookie;
    }

    public void setSessionURLPrefix(String prefix) {
        this._sessionSuffix = prefix;
    }

    public String getSessionURLPrefix() {
        return this._sessionSuffix;
    }

    public void setAlternateSessionURLPrefix(String prefix) throws ConfigException {
        if (!prefix.startsWith("/")) {
            prefix = '/' + prefix;
        }
        if (prefix.lastIndexOf(47) > 0) {
            throw new ConfigException(L.l("`{0}' is an invalidate alternate-session-url-prefix.  The url-prefix must not have any embedded '/'.", prefix));
        }
        this._sessionPrefix = prefix;
        this._sessionSuffix = null;
    }

    public String getAlternateSessionURLPrefix() {
        return this._sessionPrefix;
    }

    public int getMaxURILength() {
        return this._maxURILength;
    }

    public void setMaxURILength(int maxURILength) {
        this._maxURILength = maxURILength;
    }

    public void splitQueryAndUnescape(Invocation invocation, byte[] rawURI, int uriLength) throws IOException {
        for (int i = 0; i < uriLength; ++i) {
            if (rawURI[i] != 63) continue;
            String queryString = this.byteToChar(rawURI, ++i, uriLength - i, "ISO-8859-1");
            invocation.setQueryString(queryString);
            uriLength = i - 1;
            break;
        }
        String rawURIString = this.byteToChar(rawURI, 0, uriLength, "ISO-8859-1");
        invocation.setRawURI(rawURIString);
        String decodedURI = InvocationDecoder.normalizeUriEscape(rawURI, 0, uriLength, this._encoding);
        if (this._sessionSuffix != null) {
            int p = decodedURI.indexOf(this._sessionSuffix);
            if (p >= 0) {
                int suffixLength = this._sessionSuffix.length();
                int tail = decodedURI.indexOf(59, p + suffixLength);
                String sessionId = tail > 0 ? decodedURI.substring(p + suffixLength, tail) : decodedURI.substring(p + suffixLength);
                decodedURI = decodedURI.substring(0, p);
                invocation.setSessionId(sessionId);
                p = rawURIString.indexOf(this._sessionSuffix);
                if (p > 0) {
                    rawURIString = rawURIString.substring(0, p);
                    invocation.setRawURI(rawURIString);
                }
            }
        } else if (this._sessionPrefix != null && decodedURI.startsWith(this._sessionPrefix)) {
            String sessionId;
            int prefixLength = this._sessionPrefix.length();
            int tail = decodedURI.indexOf(47, prefixLength);
            if (tail > 0) {
                sessionId = decodedURI.substring(prefixLength, tail);
                decodedURI = decodedURI.substring(tail);
                invocation.setRawURI(rawURIString.substring(tail));
            } else {
                sessionId = decodedURI.substring(prefixLength);
                decodedURI = "/";
                invocation.setRawURI("/");
            }
            invocation.setSessionId(sessionId);
        }
        String uri = this.normalizeUri(decodedURI);
        invocation.setURI(uri);
        invocation.setContextURI(uri);
    }

    public void splitQuery(Invocation invocation, String rawURI) throws IOException {
        int p = rawURI.indexOf(63);
        if (p > 0) {
            invocation.setQueryString(rawURI.substring(p + 1));
            rawURI = rawURI.substring(0, p);
        }
        invocation.setRawURI(rawURI);
        String uri = this.normalizeUri(rawURI);
        invocation.setURI(uri);
        invocation.setContextURI(uri);
    }

    public void normalizeURI(Invocation invocation, String rawURI) throws IOException {
        invocation.setRawURI(rawURI);
        String uri = this.normalizeUri(rawURI);
        invocation.setURI(uri);
        invocation.setContextURI(uri);
    }

    private String byteToChar(byte[] buffer, int offset, int length, String encoding) {
        String result;
        ByteToChar converter = InvocationDecoder.allocateConverter();
        if (encoding == null) {
            encoding = "utf-8";
        }
        try {
            converter.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            while (length > 0) {
                converter.addByte(buffer[offset++]);
                --length;
            }
            result = converter.getConvertedString();
            InvocationDecoder.freeConverter(converter);
        }
        catch (IOException e) {
            result = "unknown";
        }
        return result;
    }

    public String normalizeUri(String uri) throws IOException {
        return this.normalizeUri(uri, CauchoSystem.isWindows());
    }

    public String normalizeUri(String uri, boolean isWindows) throws IOException {
        char ch;
        CharBuffer cb = new CharBuffer();
        int len = uri.length();
        if (len > this._maxURILength) {
            throw new BadRequestException(L.l("The request contains an illegal URL."));
        }
        if (len == 0 || (ch = uri.charAt(0)) != '/' && ch != '\\') {
            cb.append('/');
        }
        for (int i = 0; i < len; ++i) {
            ch = uri.charAt(i);
            if (ch == '/' || ch == '\\') {
                while (i + 1 < len) {
                    ch = uri.charAt(i + 1);
                    if (ch == '/' || ch == '\\') {
                        ++i;
                        continue;
                    }
                    if (ch != '.') break;
                    if (len <= i + 2 || (ch = uri.charAt(i + 2)) == '/' || ch == '\\') {
                        i += 2;
                        continue;
                    }
                    if (ch != '.') break;
                    if (len <= i + 3 || (ch = uri.charAt(i + 3)) == '/' || ch == '\\') {
                        int j;
                        for (j = cb.length() - 1; j >= 0 && (ch = cb.charAt(j)) != '/' && ch != '\\'; --j) {
                        }
                        if (j > 0) {
                            cb.setLength(j);
                        } else {
                            cb.setLength(0);
                        }
                        i += 3;
                        continue;
                    }
                    throw new BadRequestException(L.l("The request contains an illegal URL."));
                }
                while (isWindows && cb.getLength() > 0 && ((ch = cb.getLastChar()) == '.' || ch == ' ')) {
                    cb.setLength(cb.getLength() - 1);
                    if ((cb.getLength() <= 0 || (ch = cb.getLastChar()) != '/') && ch != '\\') continue;
                    cb.setLength(cb.getLength() - 1);
                }
                cb.append('/');
                continue;
            }
            if (ch == '\u0000') {
                throw new BadRequestException(L.l("The request contains an illegal URL."));
            }
            cb.append(ch);
        }
        while (isWindows && cb.getLength() > 0 && ((ch = cb.getLastChar()) == '.' || ch == ' ')) {
            cb.setLength(cb.getLength() - 1);
        }
        return cb.toString();
    }

    private static String normalizeUriEscape(byte[] rawUri, int i, int len, String encoding) throws IOException {
        ByteToChar converter = InvocationDecoder.allocateConverter();
        if (encoding == null) {
            encoding = "utf-8";
        }
        try {
            converter.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            while (i < len) {
                int ch;
                if ((ch = rawUri[i++] & 0xFF) == 37) {
                    i = InvocationDecoder.scanUriEscape(converter, rawUri, i, len);
                    continue;
                }
                converter.addByte(ch);
            }
            String result = converter.getConvertedString();
            InvocationDecoder.freeConverter(converter);
            return result;
        }
        catch (Exception e) {
            throw new BadRequestException(L.l("The URL contains escaped bytes unsupported by the {0} encoding.", encoding));
        }
    }

    private static int scanUriEscape(ByteToChar converter, byte[] rawUri, int i, int len) throws IOException {
        int ch1;
        int n = ch1 = i < len ? rawUri[i++] & 0xFF : -1;
        if (ch1 == 117) {
            ch1 = i < len ? rawUri[i++] & 0xFF : -1;
            int ch2 = i < len ? rawUri[i++] & 0xFF : -1;
            int ch3 = i < len ? rawUri[i++] & 0xFF : -1;
            int ch4 = i < len ? rawUri[i++] & 0xFF : -1;
            converter.addChar((char)((InvocationDecoder.toHex(ch1) << 12) + (InvocationDecoder.toHex(ch2) << 8) + (InvocationDecoder.toHex(ch3) << 4) + InvocationDecoder.toHex(ch4)));
        } else {
            int ch2 = i < len ? rawUri[i++] & 0xFF : -1;
            int b = (InvocationDecoder.toHex(ch1) << 4) + InvocationDecoder.toHex(ch2);
            converter.addByte(b);
        }
        return i;
    }

    private static int toHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }

    private static ByteToChar allocateConverter() {
        ByteToChar converter = _freeConverters.allocate();
        if (converter == null) {
            converter = ByteToChar.create();
        } else {
            converter.clear();
        }
        return converter;
    }

    private static void freeConverter(ByteToChar converter) {
        _freeConverters.free(converter);
    }
}

