/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.http.AbstractHttpRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletInvocation {
    private static final Logger log = Logger.getLogger(ServletInvocation.class.getName());
    private final boolean _isFiner;
    private ClassLoader _classLoader;
    private String _contextPath = "";
    private String _contextUri;
    private String _servletPath;
    private String _pathInfo;
    private String _queryString;
    private String _servletName;
    private FilterChain _filterChain;
    private boolean _isAsyncSupported = true;
    private MultipartConfigElement _multipartConfig;
    private AtomicLong _requestCount = new AtomicLong();
    private HashMap<String, String> _securityRoleMap;

    public ServletInvocation() {
        this._classLoader = Thread.currentThread().getContextClassLoader();
        this._isFiner = log.isLoggable(Level.FINER);
    }

    public final String getContextPath() {
        return this._contextPath;
    }

    public void setContextPath(String path) {
        this._contextPath = path;
    }

    public void setContextURI(String contextURI) {
        this._contextUri = contextURI;
        this._servletPath = contextURI;
    }

    public final String getContextURI() {
        return this._contextUri;
    }

    public final String getServletPath() {
        return this._servletPath;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public final String getPathInfo() {
        return this._pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public final String getQueryString() {
        return this._queryString;
    }

    public final void setQueryString(String queryString) {
        this._queryString = queryString;
    }

    public void setClassLoader(ClassLoader loader) {
        this._classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setServletName(String servletName) {
        this._servletName = servletName;
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setFilterChain(FilterChain chain) {
        this._filterChain = chain;
    }

    public FilterChain getFilterChain() {
        return this._filterChain;
    }

    public HashMap<String, String> getSecurityRoleMap() {
        return this._securityRoleMap;
    }

    public void setSecurityRoleMap(HashMap<String, String> roleMap) {
        this._securityRoleMap = roleMap;
    }

    public long getRequestCount() {
        return this._requestCount.get();
    }

    public boolean isAsyncSupported() {
        return this._isAsyncSupported;
    }

    public void clearAsyncSupported() {
        this._isAsyncSupported = false;
    }

    public MultipartConfigElement getMultipartConfig() {
        return this._multipartConfig;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this._multipartConfig = multipartConfig;
    }

    public static ServletRequest getContextRequest() {
        ProtocolConnection req = TcpSocketLink.getCurrentRequest();
        if (req instanceof AbstractHttpRequest) {
            return ((AbstractHttpRequest)req).getRequestFacade();
        }
        return null;
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this._requestCount.incrementAndGet();
        if (this._isFiner) {
            log.finer("Dispatch '" + this._contextUri + "' to " + this._filterChain);
        }
        this._filterChain.doFilter(request, response);
    }

    public void copyFrom(ServletInvocation invocation) {
        this._classLoader = invocation._classLoader;
        this._contextPath = invocation._contextPath;
        this._contextUri = invocation._contextUri;
        this._servletPath = invocation._servletPath;
        this._pathInfo = invocation._pathInfo;
        this._queryString = invocation._queryString;
        this._servletName = invocation._servletName;
        this._filterChain = invocation._filterChain;
        this._securityRoleMap = invocation._securityRoleMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._contextUri);
        if (this._queryString != null) {
            sb.append("?").append(this._queryString);
        }
        sb.append("]");
        return sb.toString();
    }
}

