/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.distcache.CacheSerializer;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.env.distcache.AbstractCacheClusterBacking;
import com.caucho.env.distcache.CacheClusterBacking;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.service.ResinSystem;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.DataCacheBacking;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.DistributedCacheManager;
import com.caucho.server.distcache.HashManager;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.Alarm;
import com.caucho.util.HashKey;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.Sha256OutputStream;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.cache.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheManager<E extends DistCacheEntry>
extends DistributedCacheManager {
    private static final Logger log = Logger.getLogger(AbstractCacheManager.class.getName());
    private static final L10N L = new L10N(AbstractCacheManager.class);
    private DataCacheBacking _dataBacking;
    private CacheClusterBacking _clusterBacking;
    private final LruCache<HashKey, E> _entryCache = new LruCache(65536);

    public AbstractCacheManager(ResinSystem resinSystem) {
        this._dataBacking = new DataCacheBacking();
        this._clusterBacking = new AbstractCacheClusterBacking();
    }

    protected CacheDataBacking getDataBacking() {
        return this._dataBacking;
    }

    protected void setClusterBacking(CacheClusterBacking clusterBacking) {
        this._clusterBacking = clusterBacking;
    }

    protected CacheClusterBacking getClusterBacking() {
        return this._clusterBacking;
    }

    public final E getCacheEntry(Object key, CacheConfig config) {
        HashKey hashKey = this.createHashKey(key, config);
        DistCacheEntry cacheEntry = (DistCacheEntry)this._entryCache.get(hashKey);
        while (cacheEntry == null) {
            cacheEntry = this.createCacheEntry(key, hashKey);
            cacheEntry = this._entryCache.putIfNew(cacheEntry.getKeyHash(), cacheEntry);
        }
        return (E)cacheEntry;
    }

    protected abstract E createCacheEntry(Object var1, HashKey var2);

    public final E getCacheEntry(HashKey hashKey) {
        DistCacheEntry cacheEntry = (DistCacheEntry)this._entryCache.get(hashKey);
        while (cacheEntry == null) {
            cacheEntry = this.createCacheEntry(null, hashKey);
            if (this._entryCache.compareAndPut(null, cacheEntry.getKeyHash(), cacheEntry)) continue;
            cacheEntry = (DistCacheEntry)this._entryCache.get(hashKey);
        }
        return (E)cacheEntry;
    }

    public final Object get(E entry, CacheConfig config, long now) {
        return this.get(entry, config, now, false);
    }

    public final Object getLazy(E entry, CacheConfig config, long now) {
        return this.get(entry, config, now, true);
    }

    private Object get(E entry, CacheConfig config, long now, boolean isLazy) {
        MnodeValue mnodeValue = this.getMnodeValue(entry, config, now, isLazy);
        if (mnodeValue == null) {
            return null;
        }
        Object value = mnodeValue.getValue();
        if (value != null) {
            return value;
        }
        HashKey valueHash = mnodeValue.getValueHashKey();
        if (valueHash == null || valueHash == HashManager.NULL) {
            return null;
        }
        this.updateAccessTime(entry, mnodeValue, now);
        value = this.readData(valueHash, config.getFlags(), config.getValueSerializer());
        if (value == null) {
            log.warning("Missing or corrupted data for " + mnodeValue);
            this.remove(entry, config);
        }
        mnodeValue.setObjectValue(value);
        return value;
    }

    public final boolean getStream(E entry, OutputStream os, CacheConfig config) throws IOException {
        long now = Alarm.getCurrentTime();
        MnodeValue mnodeValue = this.getMnodeValue(entry, config, now, false);
        if (mnodeValue == null) {
            return false;
        }
        this.updateAccessTime(entry, mnodeValue, now);
        HashKey valueHash = mnodeValue.getValueHashKey();
        if (valueHash == null || valueHash == HashManager.NULL) {
            return false;
        }
        boolean isData = this.readData(valueHash, config.getFlags(), os);
        if (!isData) {
            log.warning("Missing or corrupted data for " + mnodeValue);
            this.remove(entry, config);
        }
        return isData;
    }

    public final MnodeValue getMnodeValue(E entry, CacheConfig config, long now, boolean isLazy) {
        MnodeValue mnodeValue = this.loadMnodeValue((DistCacheEntry)entry);
        if (mnodeValue == null) {
            this.reloadValue(entry, config, now);
        } else if (!this.isLocalReadValid(mnodeValue, now)) {
            if (!isLazy) {
                this.reloadValue(entry, config, now);
            } else {
                this.lazyValueUpdate(entry, config);
            }
        }
        mnodeValue = ((DistCacheEntry)entry).getMnodeValue();
        if (mnodeValue != null) {
            this.updateIdleTime(entry, mnodeValue);
        }
        return ((DistCacheEntry)entry).getMnodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadValue(E entry, CacheConfig config, long now) {
        if (((DistCacheEntry)entry).startReadUpdate()) {
            try {
                this.loadExpiredValue(entry, config, now);
            }
            finally {
                ((DistCacheEntry)entry).finishReadUpdate();
            }
        }
    }

    protected void lazyValueUpdate(E entry, CacheConfig config) {
        this.reloadValue(entry, config, Alarm.getCurrentTime());
    }

    protected boolean isLocalReadValid(MnodeValue mnodeValue, long now) {
        return !mnodeValue.isEntryExpired(now);
    }

    private void updateAccessTime(E entry, MnodeValue mnodeValue, long now) {
        if (mnodeValue != null) {
            long idleTimeout = mnodeValue.getIdleTimeout();
            long updateTime = mnodeValue.getLastUpdateTime();
            if (idleTimeout < 0x3FFFFFFFFFFFFFFFL && updateTime + mnodeValue.getIdleWindow() < now) {
                MnodeValue newMnodeValue = new MnodeValue(mnodeValue, idleTimeout, now);
                this.saveUpdateTime(entry, newMnodeValue);
            }
        }
    }

    private void loadExpiredValue(E entry, CacheConfig config, long now) {
        MnodeValue mnodeValue = this.getClusterBacking().loadClusterValue(entry, config);
        if (mnodeValue == null || mnodeValue.isEntryExpired(now)) {
            Object value;
            CacheLoader loader = config.getCacheLoader();
            if (loader != null && ((DistCacheEntry)entry).getKey() != null && (value = loader.load(((DistCacheEntry)entry).getKey())) != null) {
                this.put(entry, value, config, now, mnodeValue);
                return;
            }
            MnodeValue nullMnodeValue = new MnodeValue(null, null, null, 0, 0L, config.getExpireTimeout(), config.getIdleTimeout(), config.getLeaseTimeout(), config.getLocalReadTimeout(), now, now, true, true);
            ((DistCacheEntry)entry).compareAndSet(mnodeValue, nullMnodeValue);
        } else {
            mnodeValue.setLastAccessTime(now);
        }
    }

    public final Object put(E entry, Object value, CacheConfig config) {
        long now = Alarm.getCurrentTime();
        MnodeValue mnodeValue = this.getMnodeValue(entry, config, now, false);
        return this.put(entry, value, config, now, mnodeValue);
    }

    protected final Object put(E entry, Object value, CacheConfig config, long now, MnodeValue mnodeValue) {
        long idleTimeout = config.getIdleTimeout() * 5L / 4L;
        HashKey key = ((DistCacheEntry)entry).getKeyHash();
        HashKey oldValueHash = mnodeValue != null ? mnodeValue.getValueHashKey() : null;
        Object oldValue = mnodeValue != null ? mnodeValue.getValue() : null;
        long version = mnodeValue != null ? mnodeValue.getVersion() : 0L;
        HashKey valueHash = this.writeData(oldValueHash, value, config.getValueSerializer());
        HashKey cacheKey = config.getCacheKey();
        int leaseOwner = mnodeValue != null ? mnodeValue.getLeaseOwner() : -1;
        mnodeValue = this.putLocalValue((DistCacheEntry)entry, version + 1L, valueHash, value, cacheKey, config.getFlags(), config.getExpireTimeout(), idleTimeout, config.getLeaseTimeout(), config.getLocalReadTimeout(), leaseOwner);
        if (mnodeValue == null) {
            return oldValue;
        }
        this.getClusterBacking().putCluster(key, valueHash, cacheKey, mnodeValue);
        return oldValue;
    }

    public final ExtCacheEntry putStream(E entry, InputStream is, CacheConfig config, long idleTimeout) throws IOException {
        HashKey key = ((DistCacheEntry)entry).getKeyHash();
        MnodeValue mnodeValue = this.loadMnodeValue((DistCacheEntry)entry);
        HashKey oldValueHash = mnodeValue != null ? mnodeValue.getValueHashKey() : null;
        long version = mnodeValue != null ? mnodeValue.getVersion() : 0L;
        HashKey valueHash = this.writeData(oldValueHash, is);
        if (valueHash != null && valueHash.equals(oldValueHash)) {
            return mnodeValue;
        }
        HashKey cacheHash = config.getCacheKey();
        idleTimeout = idleTimeout * 5L / 4L;
        int leaseOwner = mnodeValue != null ? mnodeValue.getLeaseOwner() : -1;
        mnodeValue = this.putLocalValue((DistCacheEntry)entry, version + 1L, valueHash, null, cacheHash, config.getFlags(), config.getExpireTimeout(), idleTimeout, config.getLeaseTimeout(), config.getLocalReadTimeout(), leaseOwner);
        if (mnodeValue == null) {
            return null;
        }
        this.getClusterBacking().putCluster(key, valueHash, cacheHash, mnodeValue);
        return mnodeValue;
    }

    final E getLocalEntry(HashKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        E entry = this.getCacheEntry(key);
        return entry;
    }

    final E loadLocalEntry(HashKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        E entry = this.getCacheEntry(key);
        long now = Alarm.getCurrentTime();
        if (((DistCacheEntry)entry).getMnodeValue() == null || ((DistCacheEntry)entry).getMnodeValue().isEntryExpired(now)) {
            this.forceLoadMnodeValue((DistCacheEntry)entry);
        }
        return entry;
    }

    final E getLocalEntryAndUpdateIdle(HashKey key) {
        E entry = this.getLocalEntry(key);
        MnodeValue mnodeValue = ((DistCacheEntry)entry).getMnodeValue();
        if (mnodeValue != null) {
            this.updateIdleTime(entry, mnodeValue);
        }
        return entry;
    }

    protected final void updateIdleTime(E entry, MnodeValue mnodeValue) {
        long idleTimeout = mnodeValue.getIdleTimeout();
        long updateTime = mnodeValue.getLastUpdateTime();
        long now = Alarm.getCurrentTime();
        if (idleTimeout < 0x3FFFFFFFFFFFFFFFL && updateTime + mnodeValue.getIdleWindow() < now) {
            MnodeValue newMnodeValue = new MnodeValue(mnodeValue, idleTimeout, now);
            this.saveUpdateTime(entry, newMnodeValue);
        }
    }

    public final MnodeValue loadMnodeValue(DistCacheEntry cacheEntry) {
        HashKey key = cacheEntry.getKeyHash();
        MnodeValue mnodeValue = cacheEntry.getMnodeValue();
        if (mnodeValue == null) {
            MnodeValue newMnodeValue = this.getDataBacking().loadLocalEntryValue(key);
            cacheEntry.compareAndSet(null, newMnodeValue);
            mnodeValue = cacheEntry.getMnodeValue();
        }
        return mnodeValue;
    }

    private MnodeValue forceLoadMnodeValue(DistCacheEntry cacheEntry) {
        HashKey key = cacheEntry.getKeyHash();
        MnodeValue mnodeValue = cacheEntry.getMnodeValue();
        MnodeValue newMnodeValue = this.getDataBacking().loadLocalEntryValue(key);
        cacheEntry.compareAndSet(mnodeValue, newMnodeValue);
        mnodeValue = cacheEntry.getMnodeValue();
        return mnodeValue;
    }

    final MnodeValue putLocalValue(HashKey key, MnodeValue mnodeValue) {
        E entry = this.getCacheEntry(key);
        long timeout = 60000L;
        MnodeValue oldEntryValue = ((DistCacheEntry)entry).getMnodeValue();
        if (oldEntryValue != null && mnodeValue.compareTo(oldEntryValue) <= 0) {
            return oldEntryValue;
        }
        if (!((DistCacheEntry)entry).compareAndSet(oldEntryValue, mnodeValue)) {
            log.fine(this + " mnodeValue update failed due to timing conflict" + " (key=" + key + ")");
            return ((DistCacheEntry)entry).getMnodeValue();
        }
        return this.getDataBacking().insertLocalValue(key, mnodeValue, oldEntryValue, timeout);
    }

    final MnodeValue saveUpdateTime(E entryKey, MnodeValue mnodeValue) {
        MnodeValue newEntryValue = this.saveLocalUpdateTime((DistCacheEntry)entryKey, mnodeValue);
        if (newEntryValue.getVersion() != mnodeValue.getVersion()) {
            return newEntryValue;
        }
        this.updateCacheTime(((DistCacheEntry)entryKey).getKeyHash(), mnodeValue);
        return mnodeValue;
    }

    protected void updateCacheTime(HashKey key, MnodeValue mnodeValue) {
    }

    final void saveLocalUpdateTime(HashKey key, long version, long idleTimeout, long updateTime) {
        DistCacheEntry entry = (DistCacheEntry)this._entryCache.get(key);
        if (entry == null) {
            return;
        }
        MnodeValue oldEntryValue = entry.getMnodeValue();
        if (oldEntryValue == null || version != oldEntryValue.getVersion()) {
            return;
        }
        MnodeValue mnodeValue = new MnodeValue(oldEntryValue, idleTimeout, updateTime);
        this.saveLocalUpdateTime(entry, mnodeValue);
    }

    final MnodeValue saveLocalUpdateTime(DistCacheEntry entry, MnodeValue mnodeValue) {
        MnodeValue oldEntryValue = entry.getMnodeValue();
        if (oldEntryValue != null && mnodeValue.getVersion() < oldEntryValue.getVersion()) {
            return oldEntryValue;
        }
        if (!entry.compareAndSet(oldEntryValue, mnodeValue)) {
            log.fine(this + " mnodeValue updateTime failed due to timing conflict" + " (key=" + entry.getKeyHash() + ")");
            return entry.getMnodeValue();
        }
        return this.getDataBacking().saveLocalUpdateTime(entry.getKeyHash(), mnodeValue, oldEntryValue);
    }

    public final boolean remove(E entry, CacheConfig config) {
        int leaseOwner;
        long localReadTimeout;
        long leaseTimeout;
        long idleTimeout;
        long expireTimeout;
        int flags;
        HashKey cacheKey;
        HashKey key = ((DistCacheEntry)entry).getKeyHash();
        MnodeValue mnodeValue = this.loadMnodeValue((DistCacheEntry)entry);
        HashKey oldValueHash = mnodeValue != null ? mnodeValue.getValueHashKey() : null;
        long version = mnodeValue != null ? mnodeValue.getVersion() : 0L;
        if ((mnodeValue = this.putLocalValue((DistCacheEntry)entry, version + 1L, null, null, cacheKey = ((DistCacheEntry)entry).getCacheHash(), flags = mnodeValue != null ? mnodeValue.getFlags() : 0, expireTimeout = config.getExpireTimeout(), idleTimeout = mnodeValue != null ? mnodeValue.getIdleTimeout() : config.getIdleTimeout(), leaseTimeout = mnodeValue != null ? mnodeValue.getLeaseTimeout() : config.getLeaseTimeout(), localReadTimeout = mnodeValue != null ? mnodeValue.getLocalReadTimeout() : config.getLocalReadTimeout(), leaseOwner = mnodeValue != null ? mnodeValue.getLeaseOwner() : -1)) == null) {
            return oldValueHash != null;
        }
        this.getClusterBacking().removeCluster(key, cacheKey, mnodeValue);
        return oldValueHash != null;
    }

    @Override
    public final boolean remove(HashKey key) {
        int leaseOwner;
        long localReadTimeout;
        long leaseTimeout;
        long idleTimeout;
        long expireTimeout;
        int flags;
        HashKey cacheKey;
        E entry = this.getCacheEntry(key);
        MnodeValue mnodeValue = ((DistCacheEntry)entry).getMnodeValue();
        HashKey oldValueHash = mnodeValue != null ? mnodeValue.getValueHashKey() : null;
        long version = mnodeValue != null ? mnodeValue.getVersion() : 0L;
        if ((mnodeValue = this.putLocalValue((DistCacheEntry)entry, version + 1L, null, null, cacheKey = mnodeValue != null ? mnodeValue.getCacheHashKey() : null, flags = mnodeValue != null ? mnodeValue.getFlags() : 0, expireTimeout = mnodeValue != null ? mnodeValue.getExpireTimeout() : -1L, idleTimeout = mnodeValue != null ? mnodeValue.getIdleTimeout() : -1L, leaseTimeout = mnodeValue != null ? mnodeValue.getLeaseTimeout() : -1L, localReadTimeout = mnodeValue != null ? mnodeValue.getLocalReadTimeout() : -1L, leaseOwner = mnodeValue != null ? mnodeValue.getLeaseOwner() : -1)) == null) {
            return oldValueHash != null;
        }
        this.getClusterBacking().putCluster(key, null, cacheKey, mnodeValue);
        return oldValueHash != null;
    }

    final MnodeValue putLocalValue(DistCacheEntry entry, long version, HashKey valueHash, Object value, HashKey cacheHash, int flags, long expireTimeout, long idleTimeout, long leaseTimeout, long localReadTimeout, int leaseOwner) {
        long accessTime;
        HashKey key = entry.getKeyHash();
        MnodeValue oldEntryValue = this.loadMnodeValue(entry);
        HashKey oldValueHash = oldEntryValue != null ? oldEntryValue.getValueHashKey() : null;
        long oldVersion = oldEntryValue != null ? oldEntryValue.getVersion() : 0L;
        long now = Alarm.getCurrentTime();
        if (version < oldVersion || version == oldVersion && valueHash != null && valueHash.compareTo(oldValueHash) <= 0) {
            if (oldEntryValue != null) {
                oldEntryValue.setLeaseOwner(leaseOwner, now);
                oldEntryValue.setLastAccessTime(now);
            }
            return oldEntryValue;
        }
        long updateTime = accessTime = now;
        MnodeValue mnodeValue = new MnodeValue(valueHash, value, cacheHash, flags, version, expireTimeout, idleTimeout, leaseTimeout, localReadTimeout, accessTime, updateTime, true, false);
        mnodeValue.setLeaseOwner(leaseOwner, now);
        if (!entry.compareAndSet(oldEntryValue, mnodeValue)) {
            log.fine(this + " mnodeValue update failed due to timing conflict" + " (key=" + key + ")");
            return null;
        }
        return this.getDataBacking().putLocalValue(mnodeValue, key, oldEntryValue, version, valueHash, value, cacheHash, flags, expireTimeout, idleTimeout, leaseTimeout, localReadTimeout, leaseOwner);
    }

    protected final HashKey writeData(HashKey oldValueHash, Object value, CacheSerializer serializer) {
        TempOutputStream os = null;
        try {
            os = new TempOutputStream();
            Sha256OutputStream mOut = new Sha256OutputStream(os);
            DeflaterOutputStream gzOut = new DeflaterOutputStream(mOut);
            serializer.serialize(value, gzOut);
            gzOut.finish();
            mOut.close();
            byte[] hash = mOut.getDigest();
            HashKey valueHash = new HashKey(hash);
            if (valueHash.equals(oldValueHash)) {
                HashKey hashKey = valueHash;
                return hashKey;
            }
            int length = os.getLength();
            StreamSource source = new StreamSource(os);
            if (!this.getDataBacking().saveData(valueHash, source, length)) {
                throw new IllegalStateException(L.l("Can't save the data '{0}'", valueHash));
            }
            HashKey hashKey = valueHash;
            return hashKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    protected final HashKey writeData(HashKey oldValueHash, InputStream is) throws IOException {
        TempOutputStream os = null;
        try {
            os = new TempOutputStream();
            Sha256OutputStream mOut = new Sha256OutputStream(os);
            WriteStream out = Vfs.openWrite(mOut);
            out.writeStream(is);
            out.close();
            mOut.close();
            byte[] hash = mOut.getDigest();
            HashKey valueHash = new HashKey(hash);
            if (valueHash.equals(oldValueHash)) {
                os.destroy();
                HashKey hashKey = valueHash;
                return hashKey;
            }
            int length = os.getLength();
            StreamSource source = new StreamSource(os);
            if (!this.getDataBacking().saveData(valueHash, source, length)) {
                throw new RuntimeException(L.l("Can't save the data '{0}'", valueHash));
            }
            HashKey hashKey = valueHash;
            return hashKey;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object readData(HashKey valueKey, int flags, CacheSerializer serializer) {
        if (valueKey == null || valueKey == HashManager.NULL) {
            return null;
        }
        TempOutputStream os = null;
        try {
            Object object;
            os = new TempOutputStream();
            WriteStream out = Vfs.openWrite(os);
            if (!this.getDataBacking().loadData(valueKey, out)) {
                this.requestClusterData(valueKey, flags);
                if (!this.getDataBacking().loadData(valueKey, out)) {
                    out.close();
                    System.out.println("MISSING_DATA: " + valueKey);
                    Object var6_7 = null;
                    return var6_7;
                }
            }
            out.close();
            InputStream is = os.openInputStream();
            try {
                InflaterInputStream gzIn = new InflaterInputStream(is);
                Object value = serializer.deserialize(gzIn);
                gzIn.close();
                object = value;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var6_8 = null;
                    return var6_8;
                }
            }
            is.close();
            return object;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean readData(HashKey valueKey, int flags, OutputStream os) throws IOException {
        if (valueKey == null || valueKey == HashManager.NULL) {
            throw new IllegalStateException(L.l("readData may not be called with a null value"));
        }
        WriteStream out = Vfs.openWrite(os);
        try {
            if (this.getDataBacking().loadData(valueKey, out)) {
                boolean bl = true;
                return bl;
            }
            this.requestClusterData(valueKey, flags);
            if (this.getDataBacking().loadData(valueKey, out)) {
                boolean bl = true;
                return bl;
            }
            log.warning(this + " unexpected load failure");
            boolean bl = false;
            return bl;
        }
        finally {
            out.close();
        }
    }

    protected void requestClusterData(HashKey valueKey, int flags) {
    }

    public final void clearLeases() {
        Iterator<E> iter = this._entryCache.values();
        while (iter.hasNext()) {
            DistCacheEntry entry = (DistCacheEntry)iter.next();
            entry.clearLease();
        }
    }

    public void clearEphemeralEntries() {
    }

    @Override
    public void start() {
        super.start();
        if (this.getDataBacking() == null) {
            throw new NullPointerException();
        }
        if (this.getClusterBacking() == null) {
            throw new NullPointerException();
        }
        this._dataBacking.start();
    }

    @Override
    public void close() {
        this.getDataBacking().close();
    }
}

