/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.config.Configurable;
import com.caucho.distcache.AbstractCache;
import com.caucho.distcache.CacheSerializer;
import com.caucho.distcache.HessianSerializer;
import com.caucho.util.Alarm;
import com.caucho.util.HashKey;
import javax.cache.CacheLoader;

public class CacheConfig {
    public static final long TIME_INFINITY = 0x3FFFFFFFFFFFFFFFL;
    public static final long TIME_HOUR = 3600000L;
    public static final int FLAG_EPHEMERAL = 1;
    public static final int FLAG_BACKUP = 2;
    public static final int FLAG_TRIPLICATE = 4;
    public static final int FLAG_CLUSTER = 8;
    public static final int FLAG_GLOBAL = 16;
    private String _guid;
    private HashKey _cacheKey;
    private int _flags = 6;
    private long _expireTimeout = 86400000L;
    private long _expireTimeoutWindow = 0L;
    private long _idleTimeout = 86400000L;
    private long _idleTimeoutWindow = -1L;
    private long _localReadTimeout = Alarm.isTest() ? -1L : 250L;
    private long _leaseTimeout = 300000L;
    private CacheLoader _cacheLoader;
    private CacheSerializer _keySerializer;
    private CacheSerializer _valueSerializer;
    private int _accuracy;
    private AbstractCache.Scope _scope;

    public CacheLoader getCacheLoader() {
        return this._cacheLoader;
    }

    public void setCacheLoader(CacheLoader cacheLoader) {
        this._cacheLoader = cacheLoader;
    }

    public String getGuid() {
        return this._guid;
    }

    public void setGuid(String guid) {
        this._guid = guid;
    }

    public HashKey getCacheKey() {
        return this._cacheKey;
    }

    public void setCacheKey(HashKey cacheKey) {
        this._cacheKey = cacheKey;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public long getExpireTimeout() {
        return this._expireTimeout;
    }

    public long getExpireTimeoutWindow() {
        return this._expireTimeoutWindow;
    }

    @Configurable
    public void setExpireTimeout(long expireTimeout) {
        if (expireTimeout < 0L || 0x3FFFFFFFFFFFFFFFL <= expireTimeout) {
            expireTimeout = 0x3FFFFFFFFFFFFFFFL;
        } else {
            this._expireTimeout = expireTimeout;
        }
    }

    public long getExpireCheckWindow() {
        return this._expireTimeoutWindow > 0L ? this._expireTimeoutWindow : this._expireTimeout / 4L;
    }

    @Configurable
    public void setExpireTimeoutWindow(long expireTimeoutWindow) {
        this._expireTimeoutWindow = expireTimeoutWindow;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public long getIdleTimeoutWindow() {
        return this._idleTimeoutWindow;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout < 0L || 0x3FFFFFFFFFFFFFFFL <= idleTimeout) {
            idleTimeout = 0x3FFFFFFFFFFFFFFFL;
        } else {
            this._idleTimeout = idleTimeout;
        }
    }

    public long getIdleCheckWindow() {
        return this._idleTimeoutWindow > 0L ? this._idleTimeoutWindow : this._idleTimeout / 4L;
    }

    public void setIdleTimeoutWindow(long idleTimeoutWindow) {
        this._idleTimeoutWindow = idleTimeoutWindow;
    }

    public long getLeaseTimeout() {
        return this._leaseTimeout;
    }

    public void setLeaseTimeout(long timeout) {
        this._leaseTimeout = timeout;
    }

    public long getLocalReadTimeout() {
        return this._localReadTimeout;
    }

    public void setLocalReadTimeout(long timeout) {
        this._localReadTimeout = timeout;
    }

    public CacheSerializer getKeySerializer() {
        return this._keySerializer;
    }

    public CacheSerializer getValueSerializer() {
        return this._valueSerializer;
    }

    public void setValueSerializer(CacheSerializer serializer) {
        this._valueSerializer = serializer;
    }

    public boolean isBackup() {
        return (this.getFlags() & 2) != 0;
    }

    public void setBackup(boolean isBackup) {
        if (isBackup) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFD);
        }
    }

    public boolean isGlobal() {
        return (this.getFlags() & 0x10) != 0;
    }

    public void setGlobal(boolean isGlobal) {
        if (isGlobal) {
            this.setFlags(this.getFlags() | 0x10);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFEF);
        }
    }

    public boolean isTriplicate() {
        return (this.getFlags() & 4) != 0;
    }

    public void setTriplicate(boolean isTriplicate) {
        if (isTriplicate) {
            this.setFlags(this.getFlags() | 4);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFB);
        }
    }

    public int getCacheStatisticsAccuraccy() {
        return this._accuracy;
    }

    public void setScopeMode(AbstractCache.Scope scope) {
        this._scope = scope;
    }

    public AbstractCache.Scope getScopeMode() {
        return this._scope;
    }

    public void init() {
        if (this._keySerializer == null) {
            this._keySerializer = new HessianSerializer();
        }
        if (this._valueSerializer == null) {
            this._valueSerializer = new HessianSerializer();
        }
        this._accuracy = 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

