/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.db.index.SqlIndexAlreadyExistsException;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.FreeList;
import com.caucho.util.HashKey;
import com.caucho.util.Hex;
import com.caucho.util.IoUtil;
import com.caucho.util.JdbcUtil;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataStore
implements AlarmListener {
    private static final Logger log = Logger.getLogger(DataStore.class.getName());
    private FreeList<DataConnection> _freeConn = new FreeList(32);
    private final String _tableName;
    private final String _mnodeTableName;
    private long _expireTimeout = 3600000L;
    private DataSource _dataSource;
    private final String _insertQuery;
    private final String _loadQuery;
    private final String _dataAvailableQuery;
    private final String _selectAllLimitQuery;
    private final String _updateExpiresQuery;
    private final String _deleteTimeoutQuery;
    private final String _validateQuery;
    private final String _countQuery;
    private Alarm _alarm;

    public DataStore(String serverName, MnodeStore mnodeStore) throws Exception {
        this._dataSource = mnodeStore.getDataSource();
        this._mnodeTableName = mnodeStore.getTableName();
        this._tableName = "data";
        if (this._tableName == null) {
            throw new NullPointerException();
        }
        this._loadQuery = "SELECT data FROM " + this._tableName + " WHERE id=?";
        this._dataAvailableQuery = "SELECT 1 FROM " + this._tableName + " WHERE id=?";
        this._insertQuery = "INSERT into " + this._tableName + " (id,expire_time,data) " + "VALUES(?,?,?)";
        this._updateExpiresQuery = "UPDATE " + this._tableName + " SET expire_time=?" + " WHERE id=?";
        this._selectAllLimitQuery = "SELECT value, resin_oid FROM " + this._mnodeTableName + " WHERE resin_oid > ?";
        this._deleteTimeoutQuery = "DELETE FROM " + this._tableName + " WHERE expire_time < ?";
        this._validateQuery = "VALIDATE " + this._tableName;
        this._countQuery = "SELECT count(*) FROM " + this._tableName;
        this.init();
    }

    DataSource getDataSource() {
        return this._dataSource;
    }

    private void init() throws Exception {
        this.initDatabase();
        this._alarm = new Alarm(this);
        this._alarm.queue(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            try {
                String sql = "SELECT id, expire_time, data FROM " + this._tableName + " WHERE 1=0";
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                return;
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
                log.finer(this + " " + e.toString());
                try {
                    stmt.executeQuery("DROP TABLE " + this._tableName);
                }
                catch (Exception e2) {
                    log.log(Level.FINEST, e2.toString(), e2);
                }
                String sql = "CREATE TABLE " + this._tableName + " (\n" + "  id BINARY(32) PRIMARY KEY,\n" + "  expire_time BIGINT,\n" + "  data BLOB)";
                log.fine(sql);
                stmt.executeUpdate(sql);
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(HashKey id, WriteStream os) {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareLoad();
            pstmt.setBytes(1, id.getHash());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                if (is == null) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    os.writeStream(is);
                }
                finally {
                    is.close();
                }
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " load " + id + " length:" + os.getPosition());
                }
                boolean bl = true;
                return bl;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " no data loaded for " + id);
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable(HashKey id) {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareLoad();
            pstmt.setBytes(1, id.getHash());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream(HashKey id) {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareLoad();
            pstmt.setBytes(1, id.getHash());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                DataInputStream dataInputStream = new DataInputStream(conn, rs, is);
                conn = null;
                DataInputStream dataInputStream2 = dataInputStream;
                return dataInputStream2;
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return null;
    }

    public boolean save(HashKey id, StreamSource source, int length) throws IOException {
        if (this.updateExpires(id)) {
            return true;
        }
        if (this.insert(id, source.openInputStream(), length)) {
            return true;
        }
        log.warning(this + " can't save data '" + id + "'");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(HashKey id, InputStream is, int length) {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareInsert();
            stmt.setBytes(1, id.getHash());
            stmt.setLong(2, this._expireTimeout + Alarm.getCurrentTime());
            stmt.setBinaryStream(3, is, length);
            if (is == null) {
                Thread.dumpStack();
            }
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " insert " + id + " length:" + length);
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SqlIndexAlreadyExistsException e) {
            log.finer(this + " " + e.toString());
            log.log(Level.FINEST, e.toString(), e);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.finer(this + " " + e.toString());
            log.log(Level.FINEST, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateExpires(HashKey id) {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareUpdateExpires();
            long expireTime = this._expireTimeout + Alarm.getCurrentTime();
            pstmt.setLong(1, expireTime);
            pstmt.setBytes(2, id.getHash());
            int count = pstmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " updateExpires " + id);
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredData() {
        this.validateDatabase();
        long now = Alarm.getCurrentTime();
        this.updateExpire(now);
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareDeleteTimeout();
            pstmt.setLong(1, now);
            int count = pstmt.executeUpdate();
            if (count > 0) {
                log.finer(this + " expired " + count + " old data");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExpire(long now) {
        DataConnection conn = null;
        try {
            int subCount;
            conn = this.getConnection();
            long resinOid = 0L;
            PreparedStatement pstmt = conn.prepareSelectAllLimitExpires();
            PreparedStatement pstmtUpdate = conn.prepareUpdateExpires();
            long expires = now + this._expireTimeout;
            int totalCount = 0;
            int fetchSize = 65536;
            do {
                pstmt.setLong(1, resinOid);
                pstmt.setFetchSize(fetchSize);
                ResultSet rs = pstmt.executeQuery();
                subCount = 0;
                while (rs.next()) {
                    ++subCount;
                    byte[] key = rs.getBytes(1);
                    resinOid = rs.getLong(2);
                    if (key == null) continue;
                    try {
                        pstmtUpdate.setLong(1, expires);
                        pstmtUpdate.setBytes(2, key);
                        int count = pstmtUpdate.executeUpdate();
                        if (count > 0 || Alarm.isTest()) continue;
                        System.out.println(this + " no-update COUNT: " + count + " " + Hex.toHex(key));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
                totalCount += subCount;
            } while (subCount == fetchSize);
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDatabase() {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareValidate();
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        DataConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareCount();
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                long value = rs.getLong(1);
                rs.close();
                long l = value;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (this._dataSource != null) {
            try {
                this.removeExpiredData();
            }
            finally {
                alarm.queue(this._expireTimeout / 2L);
            }
        }
    }

    public void destroy() {
        this._dataSource = null;
        this._freeConn = null;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
    }

    private DataConnection getConnection() throws SQLException {
        DataConnection cConn = this._freeConn.allocate();
        if (cConn == null) {
            Connection conn = this._dataSource.getConnection();
            cConn = new DataConnection(conn);
        }
        return cConn;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tableName + "]";
    }

    class DataConnection {
        private Connection _conn;
        private PreparedStatement _loadStatement;
        private PreparedStatement _dataAvailableStatement;
        private PreparedStatement _insertStatement;
        private PreparedStatement _selectAllLimitStatement;
        private PreparedStatement _updateExpiresStatement;
        private PreparedStatement _deleteTimeoutStatement;
        private PreparedStatement _validateStatement;
        private PreparedStatement _countStatement;

        DataConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareLoad() throws SQLException {
            if (this._loadStatement == null) {
                this._loadStatement = this._conn.prepareStatement(DataStore.this._loadQuery);
            }
            return this._loadStatement;
        }

        PreparedStatement prepareDataAvailable() throws SQLException {
            if (this._dataAvailableStatement == null) {
                this._dataAvailableStatement = this._conn.prepareStatement(DataStore.this._dataAvailableQuery);
            }
            return this._dataAvailableStatement;
        }

        PreparedStatement prepareInsert() throws SQLException {
            if (this._insertStatement == null) {
                this._insertStatement = this._conn.prepareStatement(DataStore.this._insertQuery);
            }
            return this._insertStatement;
        }

        PreparedStatement prepareSelectAllLimitExpires() throws SQLException {
            if (this._selectAllLimitStatement == null) {
                this._selectAllLimitStatement = this._conn.prepareStatement(DataStore.this._selectAllLimitQuery);
            }
            return this._selectAllLimitStatement;
        }

        PreparedStatement prepareUpdateExpires() throws SQLException {
            if (this._updateExpiresStatement == null) {
                this._updateExpiresStatement = this._conn.prepareStatement(DataStore.this._updateExpiresQuery);
            }
            return this._updateExpiresStatement;
        }

        PreparedStatement prepareDeleteTimeout() throws SQLException {
            if (this._deleteTimeoutStatement == null) {
                this._deleteTimeoutStatement = this._conn.prepareStatement(DataStore.this._deleteTimeoutQuery);
            }
            return this._deleteTimeoutStatement;
        }

        PreparedStatement prepareValidate() throws SQLException {
            if (this._validateStatement == null) {
                this._validateStatement = this._conn.prepareStatement(DataStore.this._validateQuery);
            }
            return this._validateStatement;
        }

        PreparedStatement prepareCount() throws SQLException {
            if (this._countStatement == null) {
                this._countStatement = this._conn.prepareStatement(DataStore.this._countQuery);
            }
            return this._countStatement;
        }

        void close() {
            if (DataStore.this._freeConn == null || !DataStore.this._freeConn.freeCareful(this)) {
                try {
                    this._conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    class DataInputStream
    extends InputStream {
        private DataConnection _conn;
        private ResultSet _rs;
        private InputStream _is;

        DataInputStream(DataConnection conn, ResultSet rs, InputStream is) {
            this._conn = conn;
            this._rs = rs;
            this._is = is;
        }

        public int read() throws IOException {
            return this._is.read();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return this._is.read(buffer, offset, length);
        }

        public void close() {
            DataConnection conn = this._conn;
            this._conn = null;
            ResultSet rs = this._rs;
            this._rs = null;
            InputStream is = this._is;
            this._is = null;
            IoUtil.close(is);
            JdbcUtil.close(rs);
            if (conn != null) {
                conn.close();
            }
        }
    }
}

