/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.server.distcache.CacheData;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.FreeList;
import com.caucho.util.HashKey;
import com.caucho.util.JdbcUtil;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MnodeStore
implements AlarmListener {
    private static final Logger log = Logger.getLogger(MnodeStore.class.getName());
    private FreeList<CacheMapConnection> _freeConn = new FreeList(32);
    private final Path _path;
    private final String _tableName;
    private DataSource _dataSource;
    private String _loadQuery;
    private String _insertQuery;
    private String _updateSaveQuery;
    private String _updateUpdateTimeQuery;
    private String _updateVersionQuery;
    private String _expireQuery;
    private String _countQuery;
    private String _updatesSinceQuery;
    private String _globalUpdatesSinceQuery;
    private long _serverVersion;
    private long _startupLastUpdateTime;
    private Alarm _alarm;
    private long _expireReaperTimeout = 3600000L;

    public MnodeStore(Path path, String serverName) throws Exception {
        this._path = path.lookup("distcache");
        this._tableName = "mnode";
        if (this._path == null) {
            throw new NullPointerException();
        }
        if (this._tableName == null) {
            throw new NullPointerException();
        }
        try {
            this._path.mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        DataSourceImpl dataSource = new DataSourceImpl();
        dataSource.setPath(this._path);
        dataSource.setRemoveOnError(true);
        dataSource.init();
        this._dataSource = dataSource;
        this.init();
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public String getTableName() {
        return this._tableName;
    }

    public long getStartupLastUpdateTime() {
        return this._startupLastUpdateTime;
    }

    private void init() throws Exception {
        this._loadQuery = "SELECT value,cache_id,flags,server_version,item_version,expire_timeout,idle_timeout,lease_timeout,local_read_timeout,update_time FROM " + this._tableName + " WHERE id=?";
        this._insertQuery = "INSERT into " + this._tableName + " (id,value,cache_id,flags," + "  item_version,server_version," + "  expire_timeout,idle_timeout," + "  lease_timeout,local_read_timeout," + "  update_time)" + " VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        this._updateSaveQuery = "UPDATE " + this._tableName + " SET value=?," + "     server_version=?,item_version=?," + "     idle_timeout=?,update_time=?" + " WHERE id=? AND item_version<=?";
        this._updateUpdateTimeQuery = "UPDATE " + this._tableName + " SET idle_timeout=?,update_time=?" + " WHERE id=? AND item_version=?";
        this._updateVersionQuery = "UPDATE " + this._tableName + " SET update_time=?, server_version=?" + " WHERE id=? AND value=?";
        this._expireQuery = "DELETE FROM " + this._tableName + " WHERE update_time + 5 * idle_timeout / 4 < ?" + " OR update_time + expire_timeout < ?";
        this._countQuery = "SELECT count(*) FROM " + this._tableName;
        this._updatesSinceQuery = "SELECT id,value,cache_id,flags,item_version,update_time,expire_timeout,idle_timeout,lease_timeout,local_read_timeout FROM " + this._tableName + " WHERE ? <= update_time" + " LIMIT 1024";
        int global = 16;
        this._globalUpdatesSinceQuery = "SELECT id,value,cache_id,flags,item_version,update_time, expire_timeout,idle_timeout,lease_timeout,local_read_timeout FROM " + this._tableName + " WHERE ? <= update_time" + "   AND bitand(flags, " + global + ") <> 0" + " LIMIT 1024";
        this.initDatabase();
        this._serverVersion = this.initVersion();
        this._startupLastUpdateTime = this.initLastUpdateTime();
        this._alarm = new Alarm(this);
        this.handleAlarm(this._alarm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            try {
                String sql = "SELECT id, value, cache_id, flags,     expire_timeout, idle_timeout,     lease_timeout, local_read_timeout,     update_time,     server_version, item_version FROM " + this._tableName + " WHERE 1=0";
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                return;
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
                log.finer(this + " " + e.toString());
                try {
                    stmt.executeQuery("DROP TABLE " + this._tableName);
                }
                catch (Exception e2) {
                    log.log(Level.FINEST, e2.toString(), e2);
                }
                String sql = "CREATE TABLE " + this._tableName + " (\n" + "  id BINARY(32) PRIMARY KEY,\n" + "  value BINARY(32),\n" + "  cache_id BINARY(32),\n" + "  expire_timeout BIGINT,\n" + "  idle_timeout BIGINT,\n" + "  lease_timeout BIGINT,\n" + "  local_read_timeout BIGINT,\n" + "  update_time BIGINT,\n" + "  item_version BIGINT,\n" + "  flags INTEGER,\n" + "  server_version INTEGER)";
                log.fine(sql);
                stmt.executeUpdate(sql);
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initVersion() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            String sql = "SELECT MAX(server_version) FROM " + this._tableName;
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1) + 1;
                return n;
            }
        }
        finally {
            conn.close();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initLastUpdateTime() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            String sql = "SELECT MAX(update_time) FROM " + this._tableName;
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        finally {
            conn.close();
        }
        return 0L;
    }

    public void close() {
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.close();
        }
    }

    public ArrayList<CacheData> getUpdates(long updateTime, int offset) {
        return this.getUpdates(updateTime, offset, false);
    }

    public ArrayList<CacheData> getGlobalUpdates(long updateTime, int offset) {
        return this.getUpdates(updateTime, offset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CacheData> getUpdates(long updateTime, int offset, boolean isGlobal) {
        Connection conn = null;
        try {
            ArrayList<CacheData> arrayList;
            conn = this._dataSource.getConnection();
            String sql = isGlobal ? this._globalUpdatesSinceQuery : this._updatesSinceQuery;
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, updateTime);
            ArrayList<CacheData> entryList = new ArrayList<CacheData>();
            ResultSet rs = pstmt.executeQuery();
            rs.relative(offset);
            while (rs.next()) {
                HashKey cacheKey;
                byte[] keyHash = rs.getBytes(1);
                byte[] valueHash = rs.getBytes(2);
                byte[] cacheHash = rs.getBytes(3);
                int flags = rs.getInt(4);
                long version = rs.getLong(5);
                long itemUpdateTime = rs.getLong(6);
                long expireTimeout = rs.getLong(7);
                long idleTimeout = rs.getLong(8);
                long leaseTimeout = rs.getLong(9);
                long localReadTimeout = rs.getLong(10);
                HashKey value = valueHash != null ? new HashKey(valueHash) : null;
                HashKey hashKey = cacheKey = cacheHash != null ? new HashKey(cacheHash) : null;
                if (keyHash == null) continue;
                entryList.add(new CacheData(new HashKey(keyHash), value, cacheKey, flags, version, itemUpdateTime, expireTimeout, idleTimeout, leaseTimeout, localReadTimeout));
            }
            if (entryList.size() > 0) {
                arrayList = entryList;
                return arrayList;
            }
            arrayList = null;
            return arrayList;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            JdbcUtil.close(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MnodeValue load(HashKey id) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareLoad();
            pstmt.setBytes(1, id.getHash());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                HashKey valueHashKey;
                byte[] valueHash = rs.getBytes(1);
                byte[] cacheHash = rs.getBytes(2);
                int flags = rs.getInt(3);
                long serverVersion = rs.getLong(4);
                long itemVersion = rs.getLong(5);
                long expireTimeout = rs.getLong(6);
                long idleTimeout = rs.getLong(7);
                long leaseTimeout = rs.getLong(8);
                long localReadTimeout = rs.getLong(9);
                long updateTime = rs.getLong(10);
                long accessTime = Alarm.getExactTime();
                HashKey cacheHashKey = cacheHash != null ? new HashKey(cacheHash) : null;
                HashKey hashKey = valueHashKey = valueHash != null ? new HashKey(valueHash) : null;
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " load " + id + " value=" + valueHashKey + " cache=" + cacheHashKey);
                }
                MnodeValue mnodeValue = new MnodeValue(valueHashKey, null, cacheHashKey, flags, itemVersion, expireTimeout, idleTimeout, leaseTimeout, localReadTimeout, accessTime, updateTime, serverVersion == this._serverVersion, false);
                return mnodeValue;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " load: no mnode for " + id);
            }
            MnodeValue mnodeValue = null;
            return mnodeValue;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(HashKey id, HashKey value, HashKey cacheId, int flags, long version, long expireTimeout, long idleTimeout, long leaseTimeout, long localReadTimeout) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareInsert();
            stmt.setBytes(1, id.getHash());
            if (value != null) {
                stmt.setBytes(2, value.getHash());
            } else {
                stmt.setBytes(2, null);
            }
            if (cacheId != null) {
                stmt.setBytes(3, cacheId.getHash());
            } else {
                stmt.setBytes(3, null);
            }
            stmt.setLong(4, flags);
            stmt.setLong(5, version);
            stmt.setLong(6, this._serverVersion);
            stmt.setLong(7, expireTimeout);
            stmt.setLong(8, idleTimeout);
            stmt.setLong(9, leaseTimeout);
            stmt.setLong(10, localReadTimeout);
            stmt.setLong(11, Alarm.getCurrentTime());
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " insert key=" + id + " value=" + value + " count=" + count);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSave(HashKey id, HashKey value, long itemVersion, long idleTimeout) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareUpdateSave();
            if (value != null) {
                stmt.setBytes(1, value.getHash());
            } else {
                stmt.setBytes(1, null);
            }
            stmt.setLong(2, this._serverVersion);
            stmt.setLong(3, itemVersion);
            stmt.setLong(4, idleTimeout);
            stmt.setLong(5, Alarm.getCurrentTime());
            stmt.setBytes(6, id.getHash());
            stmt.setLong(7, itemVersion);
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " updateSave key=" + id + " value=" + value);
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUpdateTime(HashKey id, long itemVersion, long idleTimeout, long updateTime) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareUpdateUpdateTime();
            stmt.setLong(1, idleTimeout);
            stmt.setLong(2, updateTime);
            stmt.setBytes(3, id.getHash());
            stmt.setLong(4, itemVersion);
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " updateUpdateTime key=" + id);
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredData() {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareExpire();
            long now = Alarm.getCurrentTime();
            pstmt.setLong(1, now);
            pstmt.setLong(2, now);
            int count = pstmt.executeUpdate();
            if (count > 0) {
                log.finer(this + " expired " + count + " old data");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareCount();
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                long value = rs.getLong(1);
                rs.close();
                long l = value;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            conn.close();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        if (this._dataSource != null) {
            try {
                this.removeExpiredData();
            }
            finally {
                alarm.queue(this._expireReaperTimeout);
            }
        }
    }

    public void destroy() {
        this._dataSource = null;
        this._freeConn = null;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
    }

    private CacheMapConnection getConnection() throws SQLException {
        CacheMapConnection cConn = this._freeConn.allocate();
        if (cConn == null) {
            Connection conn = this._dataSource.getConnection();
            cConn = new CacheMapConnection(conn);
        }
        return cConn;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tableName + "]";
    }

    class CacheMapConnection {
        private Connection _conn;
        private PreparedStatement _loadStatement;
        private PreparedStatement _insertStatement;
        private PreparedStatement _updateSaveStatement;
        private PreparedStatement _updateUpdateTimeStatement;
        private PreparedStatement _updateVersionStatement;
        private PreparedStatement _expireStatement;
        private PreparedStatement _countStatement;

        CacheMapConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareLoad() throws SQLException {
            if (this._loadStatement == null) {
                this._loadStatement = this._conn.prepareStatement(MnodeStore.this._loadQuery);
            }
            return this._loadStatement;
        }

        PreparedStatement prepareInsert() throws SQLException {
            if (this._insertStatement == null) {
                this._insertStatement = this._conn.prepareStatement(MnodeStore.this._insertQuery);
            }
            return this._insertStatement;
        }

        PreparedStatement prepareUpdateSave() throws SQLException {
            if (this._updateSaveStatement == null) {
                this._updateSaveStatement = this._conn.prepareStatement(MnodeStore.this._updateSaveQuery);
            }
            return this._updateSaveStatement;
        }

        PreparedStatement prepareUpdateUpdateTime() throws SQLException {
            if (this._updateUpdateTimeStatement == null) {
                this._updateUpdateTimeStatement = this._conn.prepareStatement(MnodeStore.this._updateUpdateTimeQuery);
            }
            return this._updateUpdateTimeStatement;
        }

        PreparedStatement prepareUpdateVersion() throws SQLException {
            if (this._updateVersionStatement == null) {
                this._updateVersionStatement = this._conn.prepareStatement(MnodeStore.this._updateVersionQuery);
            }
            return this._updateVersionStatement;
        }

        PreparedStatement prepareExpire() throws SQLException {
            if (this._expireStatement == null) {
                this._expireStatement = this._conn.prepareStatement(MnodeStore.this._expireQuery);
            }
            return this._expireStatement;
        }

        PreparedStatement prepareCount() throws SQLException {
            if (this._countStatement == null) {
                this._countStatement = this._conn.prepareStatement(MnodeStore.this._countQuery);
            }
            return this._countStatement;
        }

        void close() {
            if (MnodeStore.this._freeConn == null || !MnodeStore.this._freeConn.freeCareful(this)) {
                try {
                    this._conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

