/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.fastcgi;

import com.caucho.server.fastcgi.FastCgiRequest;
import com.caucho.server.fastcgi.FastCgiResponse;
import com.caucho.server.http.ResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FastCgiResponseStream
extends ResponseStream {
    private static final Logger log = Logger.getLogger(FastCgiResponseStream.class.getName());
    private static final L10N L = new L10N(FastCgiResponseStream.class);
    private FastCgiRequest _request;
    private WriteStream _next;

    FastCgiResponseStream(FastCgiRequest request, FastCgiResponse response, WriteStream next) {
        super(response);
        this._request = request;
        this._next = next;
    }

    protected byte[] getNextBuffer() {
        return this._next.getBuffer();
    }

    protected int getNextBufferOffset() throws IOException {
        return this._next.getBufferOffset();
    }

    protected void setNextBufferOffset(int offset) {
        this._next.setBufferOffset(offset);
    }

    protected byte[] writeNextBuffer(int offset) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "write-chunk(" + offset + ")");
        }
        return this._next.nextBuffer(offset);
    }

    public void flushNext() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "flush()");
        }
        this._next.flush();
    }

    protected void closeNext() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "flush()");
        }
        this._next.flush();
    }

    protected void writeTail(boolean isClose) throws IOException {
        this.flushBuffer();
        this._request.writeTail();
    }
}

