/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.server.hmux.HmuxExtension;
import com.caucho.server.hmux.HmuxRequest;
import com.caucho.server.http.AbstractHttpProtocol;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class HmuxProtocol
extends AbstractHttpProtocol {
    private static EnvironmentLocal<HmuxProtocol> _localManager = new EnvironmentLocal();
    private HashMap<Integer, WeakReference<HmuxExtension>> _extensionMap = new HashMap();

    public HmuxProtocol() {
        this.setProtocolName("server");
        _localManager.set(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HmuxProtocol getLocal() {
        EnvironmentLocal<HmuxProtocol> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            return _localManager.get();
        }
    }

    public ProtocolConnection createConnection(SocketLink conn) {
        return new HmuxRequest(this.getServer(), conn, this);
    }

    public HmuxExtension getExtension(Integer id) {
        WeakReference<HmuxExtension> ref = this._extensionMap.get(id);
        if (ref != null) {
            return (HmuxExtension)ref.get();
        }
        return null;
    }

    public void putExtension(Integer id, HmuxExtension extension) {
        this._extensionMap.put(id, new WeakReference<HmuxExtension>(extension));
    }
}

