/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployMode;
import com.caucho.env.deploy.ExpandDeployGenerator;
import com.caucho.env.deploy.ExpandVersion;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostExpandDeployGeneratorAdmin;
import com.caucho.server.host.HostRegexpVar;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostExpandDeployGenerator
extends ExpandDeployGenerator<HostController> {
    private static final Logger log = Logger.getLogger(HostExpandDeployGenerator.class.getName());
    private final HostExpandDeployGeneratorAdmin _admin = new HostExpandDeployGeneratorAdmin(this);
    private HostContainer _container;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private String _hostName;

    public HostExpandDeployGenerator(String id, DeployContainer<HostController> container, HostContainer hostContainer) {
        super(id, container, hostContainer.getRootDirectory());
        this._container = hostContainer;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setHostName(RawString name) {
        this._hostName = name.getValue();
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode(DeployMode.LAZY);
        } else {
            this.setStartupMode(DeployMode.AUTOMATIC);
        }
    }

    public void addHostDefault(HostConfig config) {
        this._hostDefaults.add(config);
    }

    @Override
    protected void initImpl() throws ConfigException {
        super.initImpl();
    }

    @Override
    protected void startImpl() throws ConfigException {
        super.startImpl();
        this._admin.register();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public HostController createController(ExpandVersion version) {
        String key = version.getKey();
        Path rootDirectory = this.getExpandPath(key);
        String hostName = this.keyToName(key);
        String stage = this._container.getServer().getStage();
        String id = stage + "/host/" + key;
        String hostNamePattern = this.getHostName();
        if (hostNamePattern != null && !key.equals("default")) {
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            varMap.put("host", new HostRegexpVar(key));
            ELContext parentEnv = Config.getEnvironment();
            MapVariableResolver resolver = new MapVariableResolver(varMap);
            ConfigELContext env = new ConfigELContext(resolver);
            hostName = EL.evalString(hostNamePattern, env);
        }
        HostController controller = new HostController(id, rootDirectory, hostName, this._container);
        Path jarPath = this.getArchivePath(key);
        controller.setArchivePath(jarPath);
        for (int i = 0; i < this._hostDefaults.size(); ++i) {
            controller.addConfigDefault((DeployConfig)this._hostDefaults.get(i));
        }
        return controller;
    }

    @Override
    protected HostController mergeController(HostController controller, String key) {
        try {
            Path expandDirectory = this.getExpandDirectory();
            Path rootDirectory = controller.getRootDirectory();
            if (!expandDirectory.equals(rootDirectory.getParent())) {
                return controller;
            }
            controller = super.mergeController(controller, key);
            controller.setStartupMode(this.getStartupMode());
            for (int i = 0; i < this._hostDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._hostDefaults.get(i));
            }
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINER, e.toString(), e);
            controller.setConfigException(e);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            controller.setConfigException(e);
        }
        return controller;
    }

    @Override
    public String nameToKey(String name) {
        if (name.isEmpty()) {
            return "default";
        }
        return name;
    }

    @Override
    public String keyToName(String key) {
        if (key.equals("default")) {
            return "";
        }
        return key;
    }

    @Override
    protected void destroyImpl() {
        this._admin.unregister();
        super.destroyImpl();
    }

    @Override
    public boolean equals(Object o) {
        Path deployExpandPath;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        HostExpandDeployGenerator deploy = (HostExpandDeployGenerator)o;
        Path expandPath = this.getExpandDirectory();
        return expandPath == (deployExpandPath = deploy.getExpandDirectory()) || expandPath != null && expandPath.equals(deployExpandPath);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getExpandDirectory() + "]";
    }
}

