/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostSingleDeployGenerator
extends DeployGenerator<HostController> {
    private static final Logger log = Logger.getLogger(HostSingleDeployGenerator.class.getName());
    private HostContainer _container;
    private HostConfig _config;
    private HostController _controller;

    public HostSingleDeployGenerator(DeployContainer<HostController> container) {
        super(container);
    }

    public HostSingleDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer, HostConfig config) {
        super(container);
        this._container = hostContainer;
        this._config = config;
        this.init();
    }

    public HostContainer getContainer() {
        return this._container;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this._container.getClassLoader();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public void initImpl() {
        super.initImpl();
        String hostName = "";
        String hostId = null;
        String rawId = this._config.getId();
        String rawHostName = this._config.getHostName();
        if (rawId != null && (hostId = Config.evalString(rawId)).equals("*")) {
            hostId = "";
        }
        if (rawHostName != null) {
            hostName = Config.evalString(rawHostName);
            if (rawHostName.equals("*")) {
                hostName = "";
            }
        }
        String stage = this._container.getServer().getStage();
        String id = hostName.equals("") ? stage + "/host/default" : stage + "/host/" + hostName;
        Path rootDirectory = this._config.calculateRootDirectory();
        if (hostName != null) {
            this._controller = new HostController(id, rootDirectory, hostName, this._config, this._container, null);
            if (hostId != null) {
                this._controller.addHostAlias(hostId);
            }
        } else {
            this._controller = new HostController(id, rootDirectory, hostId, this._config, this._container, null);
        }
    }

    @Override
    protected void fillDeployedNames(Set<String> names) {
        String key = this._controller.getName();
        if (key.equals("default")) {
            names.add("");
        } else {
            names.add(key);
        }
    }

    @Override
    public void generateController(String name, ArrayList<HostController> list) {
        if (this._controller.isNameMatch(name)) {
            Path rootDirectory = this._config.calculateRootDirectory();
            HostController host = new HostController(this._controller.getId(), rootDirectory, this._controller.getHostName(), this._config, this._container, null);
            list.add(host);
        }
    }

    @Override
    public Throwable getConfigException() {
        Throwable configException = super.getConfigException();
        if (configException == null && this._controller != null) {
            configException = this._controller.getConfigException();
        }
        return configException;
    }

    @Override
    public String toString() {
        if (this._config == null) {
            return this.getClass().getSimpleName() + "[]";
        }
        return this.getClass().getSimpleName() + "[" + this._config.getHostName() + "]";
    }
}

