/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.env.thread.ThreadPool;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.CometHandler;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AsyncListenerNode;
import com.caucho.server.http.ConnectionCometController;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncContextImpl
implements AsyncContext,
CometHandler {
    private static final L10N L = new L10N(ConnectionCometController.class);
    private static final Logger log = Logger.getLogger(ConnectionCometController.class.getName());
    private AsyncController _cometController;
    private final ServletRequest _request;
    private final ServletResponse _response;
    private boolean _isOriginal;
    private AsyncListenerNode _listenerNode;
    private WebApp _dispatchWebApp;
    private String _dispatchPath;

    public AsyncContextImpl(AbstractHttpRequest httpConn, ServletRequest request, ServletResponse response, boolean isOriginal) {
        this._request = request;
        this._response = response;
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalStateException(L.l("startAsync requires a HttpServletRequest"));
        }
        this._dispatchWebApp = (WebApp)request.getServletContext();
        HttpServletRequest req = (HttpServletRequest)request;
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        this._dispatchPath = pathInfo == null ? servletPath : (servletPath == null ? pathInfo : servletPath + pathInfo);
        this._cometController = httpConn.getConnection().toComet(this);
        this._isOriginal = isOriginal;
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this._isOriginal;
    }

    public void setTimeout(long idleTimeout) {
        this._cometController.setMaxIdleTime(idleTimeout);
    }

    public long getTimeout() {
        return this._cometController.getMaxIdleTime();
    }

    private boolean isActive() {
        return this._cometController != null;
    }

    ServletContext getDispatchContext() {
        return this._dispatchWebApp;
    }

    String getDispatchPath() {
        return this._dispatchPath;
    }

    public void addListener(AsyncListener listener) {
        this.addListener(listener, this._request, this._response);
    }

    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        this._listenerNode = new AsyncListenerNode(listener, request, response, this._listenerNode);
    }

    public <T extends AsyncListener> T createListener(Class<T> cl) throws ServletException {
        return (T)((AsyncListener)this._request.getServletContext().createListener(cl));
    }

    public void dispatch() {
        AsyncController cometController = this._cometController;
        if (cometController == null) {
            throw new IllegalStateException(L.l("dispatch is not valid when no AsyncContext is available"));
        }
        cometController.wake();
    }

    public void dispatch(String path) {
        this._dispatchPath = path;
        this.dispatch();
    }

    public void dispatch(ServletContext context, String path) {
        this._dispatchWebApp = (WebApp)context;
        this._dispatchPath = path;
        this.dispatch();
    }

    public void start(Runnable task) {
        if (!this.isActive()) {
            throw new IllegalStateException(L.l("AsyncContext.start() is not allowed because the AsyncContext has been completed."));
        }
        ThreadPool.getCurrent().schedule(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        AsyncController cometController = this._cometController;
        if (cometController == null) {
            return;
        }
        try {
            cometController.complete();
        }
        finally {
            this._cometController = null;
        }
    }

    public void onStart(ServletContext webApp, ServletRequest request, ServletResponse response) {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, request, response);
        Thread.dumpStack();
        for (AsyncListenerNode node = this._listenerNode; node != null; node = node.getNext()) {
            try {
                node.onStart(event);
                continue;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    @Override
    public void onTimeout() {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this._request, this._response);
        for (AsyncListenerNode node = this._listenerNode; node != null; node = node.getNext()) {
            try {
                node.onTimeout(event);
                continue;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public void onError() {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this._request, this._response);
        for (AsyncListenerNode node = this._listenerNode; node != null; node = node.getNext()) {
            try {
                node.onError(event);
                continue;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    @Override
    public void onComplete() {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this._request, this._response);
        for (AsyncListenerNode node = this._listenerNode; node != null; node = node.getNext()) {
            try {
                node.onComplete(event);
                continue;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cometController + "]";
    }
}

