/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.network.listen.AsyncController;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.util.Alarm;
import java.util.HashMap;
import javax.servlet.ServletRequest;

public class HttpConnectionController
extends AsyncController {
    private HttpServletRequestImpl _request;
    private HashMap<String, Object> _map = new HashMap(8);
    private long _maxIdleTime;

    public HttpConnectionController(ServletRequest request) {
        this(HttpConnectionController.getAbstractHttpRequest(request));
    }

    public HttpConnectionController(HttpServletRequestImpl request) {
        this._request = request;
    }

    private static HttpServletRequestImpl getAbstractHttpRequest(ServletRequest request) {
        return (HttpServletRequestImpl)request;
    }

    public void setMaxIdleTime(long idleTime) {
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            this._maxIdleTime = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                return this._map.get(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                this._map.put(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (this._map != null) {
            HashMap<String, Object> hashMap = this._map;
            synchronized (hashMap) {
                this._map.remove(name);
            }
        }
    }

    public void closeImpl() {
        this._request = null;
        super.closeImpl();
    }

    public String toString() {
        HttpServletRequestImpl request = this._request;
        if (request == null || request.getConnection() == null) {
            return "HttpConnectionController[closed]";
        }
        if (Alarm.isTest()) {
            return "HttpConnectionController[]";
        }
        return "HttpConectionController[" + request.getConnection().getId() + "]";
    }
}

