/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.cluster.Server;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.http.HttpResponseStream;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.Cookie;

public class HttpResponse
extends AbstractHttpResponse {
    static final byte[] _http10ok = "HTTP/1.0 200 OK".getBytes();
    static final byte[] _http11ok = "HTTP/1.1 200 OK".getBytes();
    static final byte[] _contentLengthBytes = "\r\nContent-Length: ".getBytes();
    static final byte[] _contentTypeBytes = "\r\nContent-Type: ".getBytes();
    static final byte[] _textHtmlBytes = "\r\nContent-Type: text/html".getBytes();
    static final byte[] _charsetBytes = "; charset=".getBytes();
    static final byte[] _textHtmlLatin1Bytes = "\r\nContent-Type: text/html; charset=iso-8859-1".getBytes();
    static final byte[] _connectionCloseBytes = "\r\nConnection: close".getBytes();
    final byte[] _resinServerBytes;
    static final char[] _connectionCb = "Connection".toCharArray();
    static final CharBuffer _closeCb = new CharBuffer("Close");
    private final HttpRequest _request;
    private final byte[] _dateBuffer = new byte[256];
    private final CharBuffer _dateCharBuffer = new CharBuffer();
    private int _dateBufferLength;
    private long _lastDate;
    private boolean _isChunked;
    private WriteStream _rawWrite;

    HttpResponse(HttpRequest request, WriteStream rawWrite) {
        super(request);
        this._request = request;
        this._rawWrite = rawWrite;
        Server server = request.getServer();
        this._resinServerBytes = ("\r\nServer: " + server.getServerHeader()).getBytes();
    }

    protected AbstractResponseStream createResponseStream() {
        HttpRequest request = (HttpRequest)this.getRequest();
        return new HttpResponseStream(this, request.getRawWrite());
    }

    boolean isChunkedEncoding() {
        return this._isChunked;
    }

    protected WriteStream getRawWrite() {
        return this._rawWrite;
    }

    protected void writeContinueInt() throws IOException {
        WriteStream os = this.getRawWrite();
        os.print("HTTP/1.1 100 Continue\r\n\r\n");
        os.flush();
    }

    protected boolean writeHeadersInt(int length, boolean isHead) throws IOException {
        HttpServletRequestImpl request = this._request.getRequestFacade();
        HttpServletResponseImpl response = this._request.getResponseFacade();
        if (request == null) {
            return false;
        }
        this._isChunked = false;
        int version = this._request.getVersion();
        boolean debug = log.isLoggable(Level.FINE);
        if (version < 256) {
            this._request.killKeepalive();
            return false;
        }
        TcpSocketLink tcpConn = null;
        if (this._request.getConnection() instanceof TcpSocketLink) {
            tcpConn = (TcpSocketLink)this._request.getConnection();
        }
        WebApp webApp = request.getWebApp();
        String contentType = response.getContentTypeImpl();
        String charEncoding = response.getCharacterEncodingImpl();
        WriteStream os = this.getRawWrite();
        int statusCode = response.getStatus();
        if (statusCode == 200) {
            if (version < 257) {
                os.write(_http10ok, 0, _http10ok.length);
            } else {
                os.write(_http11ok, 0, _http11ok.length);
            }
        } else {
            if (version < 257) {
                os.printLatin1("HTTP/1.0 ");
            } else {
                os.printLatin1("HTTP/1.1 ");
            }
            os.write(statusCode / 100 % 10 + 48);
            os.write(statusCode / 10 % 10 + 48);
            os.write(statusCode % 10 + 48);
            os.write(32);
            os.printLatin1(response.getStatusMessage());
        }
        if (debug) {
            log.fine(this._request.dbgId() + "HTTP/1.1 " + statusCode + " " + response.getStatusMessage());
        }
        boolean isUpgrade = false;
        if (tcpConn != null && tcpConn.isDuplex()) {
            isUpgrade = true;
            String upgrade = this.getHeader("Upgrade");
            if (upgrade != null) {
                os.printLatin1("\r\nUpgrade: ");
                os.printLatin1(upgrade);
            }
            os.printLatin1("\r\nConnection: Upgrade");
            this._request.killKeepalive();
            if (debug) {
                log.fine(this._request.dbgId() + "Connection: Upgrade");
            }
        }
        if (!this.containsHeader("Server")) {
            os.write(this._resinServerBytes, 0, this._resinServerBytes.length);
        }
        if (statusCode >= 400) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
        } else if (statusCode == 304 || statusCode == 204) {
            contentType = null;
        } else if (!response.isCacheControl()) {
            if (response.isNoCache()) {
                this.removeHeader("ETag");
                this.removeHeader("Last-Modified");
                this.setHeaderImpl("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
                os.printLatin1("\r\nCache-Control: no-cache");
                if (debug) {
                    log.fine(this._request.dbgId() + "" + "Cache-Control: no-cache");
                }
            } else if (response.isNoCacheUnlessVary() && !this.containsHeader("Vary")) {
                os.printLatin1("\r\nCache-Control: private");
                if (debug) {
                    log.fine(this._request.dbgId() + "Cache-Control: private");
                }
            } else if (response.isPrivateCache()) {
                if (257 <= version) {
                    os.printLatin1("\r\nCache-Control: private");
                    if (debug) {
                        log.fine(this._request.dbgId() + "Cache-Control: private");
                    }
                } else {
                    this.setHeaderImpl("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
                    os.printLatin1("\r\nCache-Control: no-cache");
                    if (debug) {
                        log.fine(this._request.dbgId() + "CacheControl: no-cache");
                    }
                }
            }
        }
        int size = this._headerKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)this._headerKeys.get(i);
            if (isUpgrade && "Upgrade".equalsIgnoreCase(key)) continue;
            os.write(13);
            os.write(10);
            os.printLatin1(key);
            os.write(58);
            os.write(32);
            os.printLatin1((String)this._headerValues.get(i));
            if (!debug) continue;
            log.fine(this._request.dbgId() + "" + key + ": " + (String)this._headerValues.get(i));
        }
        long now = Alarm.getCurrentTime();
        ArrayList<Cookie> cookiesOut = response.getCookies();
        if (cookiesOut != null) {
            for (int i = 0; i < cookiesOut.size(); ++i) {
                Cookie cookie = cookiesOut.get(i);
                int cookieVersion = cookie.getVersion();
                CharBuffer cb = this._cb;
                this.fillCookie(cb, cookie, now, cookieVersion, false);
                os.printLatin1("\r\nSet-Cookie: ");
                os.printLatin1(cb.getBuffer(), 0, cb.getLength());
                if (cookieVersion > 0) {
                    this.fillCookie(cb, cookie, now, cookieVersion, true);
                    os.printLatin1("\r\nSet-Cookie2: ");
                    os.printLatin1(cb.getBuffer(), 0, cb.getLength());
                }
                if (!debug) continue;
                log.fine(this._request.dbgId() + "Set-Cookie: " + cb);
            }
        }
        if (contentType != null) {
            if (charEncoding == null) {
                if (webApp != null) {
                    charEncoding = webApp.getCharacterEncoding();
                }
                if (charEncoding == null) {
                    charEncoding = "utf-8";
                }
            }
            os.write(_contentTypeBytes, 0, _contentTypeBytes.length);
            os.printLatin1(contentType);
            os.write(_charsetBytes, 0, _charsetBytes.length);
            os.printLatin1(charEncoding);
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Type: " + contentType + "; charset=" + charEncoding);
            }
        }
        if (this.hasFooter()) {
            this._contentLength = -1L;
            length = -1;
        }
        boolean hasContentLength = false;
        if (this._contentLength >= 0L) {
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(this._contentLength);
            hasContentLength = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: " + this._contentLength);
            }
        } else if (statusCode == 304) {
            hasContentLength = true;
            this.setHead();
        } else if (statusCode == 204) {
            hasContentLength = true;
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(0);
            this.setHead();
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: 0");
            }
        } else if (length >= 0) {
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(length);
            hasContentLength = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: " + length);
            }
        }
        if (version < 257) {
            this._request.killKeepalive();
        } else if (!this._request.isKeepaliveAllowed() && !isUpgrade) {
            os.write(_connectionCloseBytes, 0, _connectionCloseBytes.length);
            this._request.killKeepalive();
            if (debug) {
                log.fine(this._request.dbgId() + "Connection: close");
            }
        }
        if (257 <= version && !hasContentLength && !isHead) {
            os.printLatin1("\r\nTransfer-Encoding: chunked");
            this._isChunked = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Transfer-Encoding: chunked");
            }
        }
        if (this._lastDate / 1000L != now / 1000L) {
            this.fillDate(now);
        }
        if (this._isChunked) {
            os.write(this._dateBuffer, 0, this._dateBufferLength - 2);
        } else {
            os.write(this._dateBuffer, 0, this._dateBufferLength);
        }
        return this._isChunked;
    }

    private void fillDate(long now) {
        if (this._lastDate / 60000L == now / 60000L) {
            int min = (int)(now / 60000L % 60L);
            int sec = (int)(now / 1000L % 60L);
            int m2 = 48 + min / 10;
            int m1 = 48 + min % 10;
            int s2 = 48 + sec / 10;
            int s1 = 48 + sec % 10;
            this._dateBuffer[28] = (byte)m2;
            this._dateBuffer[29] = (byte)m1;
            this._dateBuffer[31] = (byte)s2;
            this._dateBuffer[32] = (byte)s1;
            this._lastDate = now;
            return;
        }
        this._lastDate = now;
        this._calendar.setGMTTime(now);
        this._dateCharBuffer.clear();
        this._dateCharBuffer.append("\r\nDate: ");
        this._calendar.printDate(this._dateCharBuffer);
        char[] cb = this._dateCharBuffer.getBuffer();
        int len = this._dateCharBuffer.getLength();
        for (int i = len - 1; i >= 0; --i) {
            this._dateBuffer[i] = (byte)cb[i];
        }
        this._dateBuffer[len] = 13;
        this._dateBuffer[len + 1] = 10;
        this._dateBuffer[len + 2] = 13;
        this._dateBuffer[len + 3] = 10;
        this._dateBufferLength = len + 4;
    }

    public String toString() {
        return "HttpResponse" + this._request.dbgId();
    }
}

