/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.config.scope.ScopeRemoveListener;
import com.caucho.i18n.CharacterEncoding;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.security.Login;
import com.caucho.server.cluster.Server;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.AbstractCauchoRequest;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AsyncContextImpl;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.Form;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.MultipartForm;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.servlet.WebSocketContext;
import com.caucho.servlet.WebSocketListener;
import com.caucho.servlet.WebSocketServletRequest;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.Part;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpServletRequestImpl
extends AbstractCauchoRequest
implements CauchoRequest,
WebSocketServletRequest {
    private static final Logger log = Logger.getLogger(HttpServletRequestImpl.class.getName());
    private static final L10N L = new L10N(HttpServletRequestImpl.class);
    private static final String CHAR_ENCODING = "resin.form.character.encoding";
    private static final String FORM_LOCALE = "resin.form.local";
    private static final String CAUCHO_CHAR_ENCODING = "caucho.form.character.encoding";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private AbstractHttpRequest _request;
    private final HttpServletResponseImpl _response;
    private Boolean _isSecure;
    private Invocation _invocation;
    private HashMapImpl<String, String[]> _filledForm;
    private List<Part> _parts;
    private Cookie[] _cookiesIn;
    private boolean _varyCookies;
    private boolean _hasCookie;
    private boolean _isSessionIdFromCookie;
    private String _runAs;
    private boolean _isLoginRequested;
    private boolean _hasReader;
    private boolean _hasInputStream;
    private HashMapImpl<String, Object> _attributes;
    private boolean _isSyntheticCacheHeader;
    private long _asyncTimeout = 10000L;
    private AsyncContextImpl _asyncContext;
    private ArrayList<Path> _closeOnExit;

    public HttpServletRequestImpl(AbstractHttpRequest request) {
        this._request = request;
        this._response = new HttpServletResponseImpl(this, request.getAbstractHttpResponse());
    }

    @Override
    public HttpServletResponseImpl getResponse() {
        return this._response;
    }

    public String getProtocol() {
        return this._request.getProtocol();
    }

    public String getScheme() {
        String scheme = this._request.getScheme();
        if (this.isSecure() && "http".equals(scheme)) {
            return "https";
        }
        return scheme;
    }

    public String getServerName() {
        return this._request.getServerName();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public String getRemoteAddr() {
        return this._request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this._request.getRemoteHost();
    }

    public int getRemotePort() {
        return this._request.getRemotePort();
    }

    public String getLocalAddr() {
        return this._request.getLocalHost();
    }

    public String getLocalName() {
        return this._request.getLocalHost();
    }

    public int getLocalPort() {
        return this._request.getLocalPort();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._request.setCharacterEncoding(encoding);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._hasReader) {
            throw new IllegalStateException(L.l("getInputStream() can't be called after getReader()"));
        }
        this._hasInputStream = true;
        return this._request.getInputStream();
    }

    public BufferedReader getReader() throws IOException, IllegalStateException {
        if (this._hasInputStream) {
            throw new IllegalStateException(L.l("getReader() can't be called after getInputStream()"));
        }
        this._hasReader = true;
        return this._request.getReader();
    }

    public String getCharacterEncoding() {
        return this._request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this._request.getContentLength();
    }

    public String getContentType() {
        return this._request.getContentType();
    }

    public Locale getLocale() {
        return this._request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this._request.getLocales();
    }

    public boolean isSecure() {
        if (this._isSecure != null) {
            return this._isSecure;
        }
        AbstractHttpRequest request = this._request;
        if (request != null) {
            return request.isSecure();
        }
        return false;
    }

    public Object getAttribute(String name) {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes != null) {
            return attributes.get(name);
        }
        if (this.isSecure()) {
            attributes = this._attributes = new HashMapImpl();
            this._request.initAttributes(this);
            return attributes.get(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes != null) {
            return Collections.enumeration(attributes.keySet());
        }
        if (this.isSecure()) {
            attributes = this._attributes = new HashMapImpl();
            this._request.initAttributes(this);
            return Collections.enumeration(attributes.keySet());
        }
        return NullEnumeration.create();
    }

    public void setAttribute(String name, Object value) {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (value != null) {
            if (attributes == null) {
                this._attributes = attributes = new HashMapImpl();
                this._request.initAttributes(this);
            }
            Object oldValue = attributes.put(name, value);
            WebApp webApp = this.getWebApp();
            if (webApp != null) {
                for (ServletRequestAttributeListener listener : webApp.getRequestAttributeListeners()) {
                    ServletRequestAttributeEvent event;
                    if (oldValue != null) {
                        event = new ServletRequestAttributeEvent((ServletContext)webApp, (ServletRequest)this, name, oldValue);
                        listener.attributeReplaced(event);
                        continue;
                    }
                    event = new ServletRequestAttributeEvent((ServletContext)webApp, (ServletRequest)this, name, value);
                    listener.attributeAdded(event);
                }
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes == null) {
            return;
        }
        Object oldValue = attributes.remove(name);
        WebApp webApp = this.getWebApp();
        for (ServletRequestAttributeListener listener : webApp.getRequestAttributeListeners()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)webApp, (ServletRequest)this, name, oldValue);
            listener.attributeRemoved(event);
        }
        if (oldValue instanceof ScopeRemoveListener) {
            ((ScopeRemoveListener)oldValue).removeEvent(this, name);
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getWebApp().getRequestDispatcher(path);
        }
        CharBuffer cb = new CharBuffer();
        WebApp webApp = this.getWebApp();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (webApp != null) {
            return webApp.getRequestDispatcher(cb.toString());
        }
        return null;
    }

    public ServletContext getServletContext() {
        Invocation invocation = this._invocation;
        if (invocation != null) {
            return invocation.getWebApp();
        }
        return null;
    }

    @Override
    public ServletResponse getServletResponse() {
        return this._response;
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public String getRequestURI() {
        if (this._invocation != null) {
            return this._invocation.getRawURI();
        }
        return "";
    }

    @Override
    public String getPageURI() {
        return this._invocation.getRawURI();
    }

    public String getContextPath() {
        if (this._invocation != null) {
            return this._invocation.getContextPath();
        }
        return "";
    }

    @Override
    public String getPageContextPath() {
        return this.getContextPath();
    }

    public String getServletPath() {
        if (this._invocation != null) {
            return this._invocation.getServletPath();
        }
        return "";
    }

    @Override
    public String getPageServletPath() {
        if (this._invocation != null) {
            return this._invocation.getServletPath();
        }
        return "";
    }

    public String getPathInfo() {
        if (this._invocation != null) {
            return this._invocation.getPathInfo();
        }
        return null;
    }

    @Override
    public String getPagePathInfo() {
        if (this._invocation != null) {
            return this._invocation.getPathInfo();
        }
        return null;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        int port = this.getServerPort();
        if (port > 0 && port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    @Override
    public String getRealPath(String path) {
        int p;
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return this._invocation.getWebApp().getRealPath(path);
        }
        String uri = this.getPageURI();
        String context = this.getPageContextPath();
        if (context != null) {
            uri = uri.substring(context.length());
        }
        if ((p = uri.lastIndexOf(47)) >= 0) {
            path = uri.substring(0, p + 1) + path;
        }
        return this._invocation.getWebApp().getRealPath(path);
    }

    @Override
    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    public String getQueryString() {
        if (this._invocation != null) {
            return this._invocation.getQueryString();
        }
        return null;
    }

    @Override
    public String getPageQueryString() {
        return this.getQueryString();
    }

    public String getHeader(String name) {
        return this._request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this._request.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this._request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this._request.getIntHeader(name);
    }

    public long getDateHeader(String name) {
        return this._request.getDateHeader(name);
    }

    public Enumeration<String> getParameterNames() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.enumeration(this._filledForm.keySet());
    }

    public Map<String, String[]> getParameterMap() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.unmodifiableMap(this._filledForm);
    }

    public String[] getParameterValues(String name) {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return this._filledForm.get(name);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        MultipartConfigElement multipartConfig = this._invocation.getMultipartConfig();
        if (multipartConfig == null) {
            throw new ServletException(L.l("multipart-form is disabled; check @MultipartConfig annotation on `{0}'.", this._invocation.getServletName()));
        }
        if (!this.getContentType().startsWith("multipart/form-data")) {
            throw new ServletException("Content-Type must be of 'multipart/form-data'.");
        }
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return this._parts;
    }

    Part createPart(String name, Map<String, List<String>> headers) {
        return new PartImpl(name, headers);
    }

    public Part getPart(String name) throws IOException, ServletException {
        for (Part part : this.getParts()) {
            if (!name.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    private HashMapImpl<String, String[]> parseQuery() {
        HashMapImpl<String, String[]> form;
        block25: {
            form = this._request.getForm();
            try {
                String query = this.getQueryString();
                CharSegment contentType = this._request.getContentTypeBuffer();
                if (query == null && contentType == null) {
                    return form;
                }
                Form formParser = this._request.getFormParser();
                long contentLength = this._request.getLongContentLength();
                String charEncoding = this.getCharacterEncoding();
                if (charEncoding == null) {
                    Locale locale;
                    charEncoding = (String)this.getAttribute(CAUCHO_CHAR_ENCODING);
                    if (charEncoding == null) {
                        charEncoding = (String)this.getAttribute(CHAR_ENCODING);
                    }
                    if (charEncoding == null && (locale = (Locale)this.getAttribute(FORM_LOCALE)) != null) {
                        charEncoding = Encoding.getMimeName(locale);
                    }
                }
                if (query != null) {
                    String queryEncoding = charEncoding;
                    if (queryEncoding == null && this.getServer() != null) {
                        queryEncoding = this.getServer().getURLCharacterEncoding();
                    }
                    if (queryEncoding == null) {
                        queryEncoding = CharacterEncoding.getLocalEncoding();
                    }
                    String javaEncoding = Encoding.getJavaName(queryEncoding);
                    formParser.parseQueryString(form, query, javaEncoding, true);
                }
                if (charEncoding == null) {
                    charEncoding = CharacterEncoding.getLocalEncoding();
                }
                String javaEncoding = Encoding.getJavaName(charEncoding);
                MultipartConfigElement multipartConfig = this._invocation.getMultipartConfig();
                if (contentType == null || !"POST".equalsIgnoreCase(this.getMethod())) break block25;
                if (contentType.startsWith("application/x-www-form-urlencoded")) {
                    formParser.parsePostData(form, (InputStream)this.getInputStream(), javaEncoding);
                    break block25;
                }
                if (!this.getWebApp().doMultipartForm() && multipartConfig == null || !contentType.startsWith("multipart/form-data")) break block25;
                int length = contentType.length();
                int i = contentType.indexOf("boundary=");
                if (i < 0) {
                    return form;
                }
                long formUploadMax = this.getWebApp().getFormUploadMax();
                Object uploadMax = this.getAttribute("caucho.multipart.form.upload-max");
                if (uploadMax instanceof Number) {
                    formUploadMax = ((Number)uploadMax).longValue();
                }
                if (formUploadMax >= 0L && formUploadMax < contentLength) {
                    this.setAttribute("caucho.multipart.form.error", L.l("Multipart form upload of '{0}' bytes was too large.", String.valueOf(contentLength)));
                    this.setAttribute("caucho.multipart.form.error.size", new Long(contentLength));
                    return form;
                }
                long fileUploadMax = -1L;
                if (multipartConfig != null) {
                    formUploadMax = multipartConfig.getMaxRequestSize();
                    fileUploadMax = multipartConfig.getMaxFileSize();
                }
                if (multipartConfig != null && formUploadMax > 0L && formUploadMax < contentLength) {
                    throw new IllegalStateException(L.l("multipart form data request's Content-Length '{0}' is greater then configured in @MultipartConfig.maxRequestSize value: '{1}'", (Object)contentLength, formUploadMax));
                }
                char ch = contentType.charAt(i += "boundary=".length());
                CharBuffer boundary = new CharBuffer();
                if (ch == '\'') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\'') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else if (ch == '\"') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\"') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else {
                    while (i < length && (ch = contentType.charAt(i)) != ' ' && ch != ';') {
                        boundary.append(ch);
                        ++i;
                    }
                }
                this._parts = new ArrayList<Part>();
                try {
                    MultipartForm.parsePostData(form, this._parts, this.getStream(false), boundary.toString(), this, javaEncoding, formUploadMax, fileUploadMax);
                }
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                    this.setAttribute("caucho.multipart.form.error", e.getMessage());
                }
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return form;
    }

    public Cookie[] getCookies() {
        if (this._cookiesIn == null) {
            this._cookiesIn = this._request.getCookies();
            SessionManager sessionManager = this.getSessionManager();
            String sessionCookieName = this.getSessionCookie(sessionManager);
            for (int i = 0; i < this._cookiesIn.length; ++i) {
                Cookie cookie = this._cookiesIn[i];
                if (!cookie.getName().equals(sessionCookieName) || !sessionManager.isSecure()) continue;
                cookie.setSecure(true);
                break;
            }
        }
        if (this._cookiesIn == null || this._cookiesIn.length == 0) {
            return null;
        }
        return this._cookiesIn;
    }

    @Override
    public Cookie getCookie(String name) {
        return this.findCookie(name);
    }

    private Cookie findCookie(String name) {
        Cookie[] cookies = this.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            this.setHasCookie();
            return cookie;
        }
        return null;
    }

    public String getRequestedSessionId() {
        String id;
        SessionManager manager = this.getSessionManager();
        if (manager != null && manager.enableSessionCookies()) {
            this.setVaryCookie(this.getSessionCookie(manager));
            id = this.findSessionIdFromCookie();
            if (id != null) {
                this._isSessionIdFromCookie = true;
                this.setHasCookie();
                return id;
            }
        }
        if ((id = this.findSessionIdFromUrl()) != null) {
            return id;
        }
        if (manager != null && manager.enableSessionCookies()) {
            return null;
        }
        return this._request.findSessionIdFromConnection();
    }

    protected String findSessionIdFromCookie() {
        SessionManager manager = this.getSessionManager();
        if (manager == null || !manager.enableSessionCookies()) {
            return null;
        }
        Cookie cookie = this.getCookie(this.getSessionCookie(manager));
        if (cookie != null) {
            this._isSessionIdFromCookie = true;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public boolean isSessionIdFromCookie() {
        return this._isSessionIdFromCookie;
    }

    @Override
    public String getSessionId() {
        String sessionId = this.getResponse().getSessionId();
        if (sessionId != null) {
            return sessionId;
        }
        return this.getRequestedSessionId();
    }

    @Override
    public void setSessionId(String sessionId) {
        this.getResponse().setSessionId(sessionId);
    }

    private String findSessionIdFromUrl() {
        String id;
        String string = id = this._invocation != null ? this._invocation.getSessionId() : null;
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.findSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.findSessionIdFromUrl() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getRequestedSessionIdNoVary() {
        boolean varyCookies = this._varyCookies;
        boolean hasCookie = this._hasCookie;
        boolean privateCache = this._response.getPrivateCache();
        String id = this.getRequestedSessionId();
        this._varyCookies = varyCookies;
        this._hasCookie = hasCookie;
        this._response.setPrivateOrResinCache(privateCache);
        return id;
    }

    @Override
    protected String getRunAs() {
        return this._runAs;
    }

    public String getAuthType() {
        Object login = this.getAttribute("caucho.login");
        if (login instanceof X509Certificate) {
            return "CLIENT_CERT";
        }
        WebApp app = this.getWebApp();
        if (app != null && app.getLogin() != null && this.getUserPrincipal() != null) {
            return app.getLogin().getAuthType();
        }
        return null;
    }

    protected Login getLogin() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.getLogin();
        }
        return null;
    }

    @Override
    public boolean isLoginRequested() {
        return this._isLoginRequested;
    }

    @Override
    public void requestLogin() {
        this._isLoginRequested = true;
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public String getRemoteUser(boolean create) {
        Principal user = (Principal)this.getAttribute("caucho.login");
        if (user == null && create) {
            user = this.getUserPrincipal();
        }
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public void logout() {
        Login login = this.getLogin();
        if (login != null) {
            login.logout(this.getUserPrincipal(), this, this.getResponse());
        }
    }

    public void logoutUserPrincipal() {
    }

    public String runAs(String role) {
        String oldRunAs = this._runAs;
        this._runAs = role;
        return oldRunAs;
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    @Override
    public ReadStream getStream() throws IOException {
        return this._request.getStream();
    }

    public ReadStream getStream(boolean isFlush) throws IOException {
        return this._request.getStream(isFlush);
    }

    @Override
    public int getRequestDepth(int depth) {
        return depth;
    }

    @Override
    public void setHeader(String key, String value) {
        this._request.setHeader(key, value);
    }

    @Override
    public void setSyntheticCacheHeader(boolean isTop) {
        this._isSyntheticCacheHeader = isTop;
    }

    @Override
    public boolean isSyntheticCacheHeader() {
        return this._isSyntheticCacheHeader;
    }

    @Override
    public void setVaryCookie(String cookie) {
        this._varyCookies = true;
    }

    @Override
    public boolean getVaryCookies() {
        return this._varyCookies;
    }

    @Override
    public void setHasCookie() {
        this._hasCookie = true;
    }

    @Override
    public boolean getHasCookie() {
        if (this._hasCookie) {
            return true;
        }
        if (this._invocation != null) {
            return this._invocation.getSessionId() != null;
        }
        return false;
    }

    @Override
    public boolean isTop() {
        return true;
    }

    @Override
    public boolean isComet() {
        return this._request.isCometActive();
    }

    public void addCloseOnExit(Path path) {
        if (this._closeOnExit == null) {
            this._closeOnExit = new ArrayList();
        }
        this._closeOnExit.add(path);
    }

    @Override
    public boolean isDuplex() {
        return this._request.isDuplex();
    }

    @Override
    public void killKeepalive() {
        this._request.killKeepalive();
    }

    @Override
    public boolean isKeepaliveAllowed() {
        return this._request.isKeepaliveAllowed();
    }

    @Override
    public boolean isClientDisconnect() {
        return this._request.isClientDisconnect();
    }

    @Override
    public void clientDisconnect() {
        this._request.clientDisconnect();
    }

    public SocketLink getConnection() {
        return this._request.getConnection();
    }

    @Override
    public AbstractHttpRequest getAbstractHttpRequest() {
        return this._request;
    }

    @Override
    public boolean isSuspend() {
        return this._request.isSuspend();
    }

    @Override
    public boolean hasRequest() {
        return this._request.hasRequest();
    }

    public void setInvocation(Invocation invocation) {
        this._invocation = invocation;
    }

    @Override
    public Invocation getInvocation() {
        return this._invocation;
    }

    public long getStartTime() {
        return this._request.getStartTime();
    }

    public void finishInvocation() {
        AsyncContextImpl asyncContext = this._asyncContext;
        if (asyncContext != null) {
            asyncContext.onComplete();
        }
        this._request.finishInvocation();
    }

    public boolean isAsyncStarted() {
        AbstractHttpRequest request = this._request;
        return request != null && request.isCometActive();
    }

    public boolean isAsyncSupported() {
        Invocation invocation = this._invocation;
        if (invocation != null) {
            return invocation.isAsyncSupported();
        }
        return false;
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this, (ServletResponse)this._response);
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException(L.l("The servlet '{0}' at '{1}' does not support async because the servlet or one of the filters does not support asynchronous mode.  The servlet should be annotated with a @WebServlet(asyncSupported=true) annotation or have a <async-supported> tag in the web.xml.", (Object)this.getServletName(), this.getServletPath()));
        }
        if (this._request.isCometActive()) {
            throw new IllegalStateException(L.l("startAsync may not be called twice on the same dispatch."));
        }
        boolean isOriginal = request == this && response == this._response;
        this._asyncContext = new AsyncContextImpl(this._request, request, response, isOriginal);
        if (this._asyncTimeout > 0L) {
            this._asyncContext.setTimeout(this._asyncTimeout);
        }
        return this._asyncContext;
    }

    public AsyncContextImpl getAsyncContext() {
        if (this._asyncContext != null) {
            return this._asyncContext;
        }
        throw new IllegalStateException(L.l("getAsyncContext() must be called after asyncStarted() has started a new AsyncContext."));
    }

    @Override
    public WebSocketContext startWebSocket(WebSocketListener listener) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " upgrade HTTP to WebSocket " + listener);
        }
        String connection = this.getHeader("Connection");
        String upgrade = this.getHeader("Upgrade");
        if (!"WebSocket".equals(upgrade)) {
            throw new IllegalStateException(L.l("HTTP Upgrade header '{0}' must be 'WebSocket', because the WebSocket protocol requires an Upgrade: WebSocket header.", upgrade));
        }
        if (!"Upgrade".equalsIgnoreCase(connection)) {
            throw new IllegalStateException(L.l("HTTP Connection header '{0}' must be 'Upgrade', because the WebSocket protocol requires a Connection: Upgrade header.", connection));
        }
        String origin = this.getHeader("Origin");
        if (origin == null) {
            throw new IllegalStateException(L.l("HTTP Origin header is required, because the WebSocket protocol requires an Origin header."));
        }
        this._response.setStatus(101, "Web Socket Protocol Handshake");
        this._response.setHeader("Upgrade", "WebSocket");
        this._response.setContentLength(0);
        StringBuilder sb = new StringBuilder();
        if (this.isSecure()) {
            sb.append("wss://");
        } else {
            sb.append("ws://");
        }
        sb.append(this.getServerName());
        if (!this.isSecure() && this.getServerPort() != 80 || this.isSecure() && this.getServerPort() != 443) {
            sb.append(":");
            sb.append(this.getServerPort());
        }
        sb.append(this.getContextPath());
        if (this.getServletPath() != null) {
            sb.append(this.getServletPath());
        }
        String url = sb.toString();
        this._response.setHeader("WebSocket-Location", url);
        this._response.setHeader("WebSocket-Origin", origin.toLowerCase());
        String protocol = this.getHeader("WebSocket-Protocol");
        if (protocol != null) {
            this._response.setHeader("WebSocket-Protocol", protocol);
        }
        WebSocketContextImpl duplex = new WebSocketContextImpl(this, this._response, listener);
        SocketLinkDuplexController controller = this._request.startDuplex(duplex);
        duplex.setController(controller);
        try {
            duplex.onStart();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return duplex;
    }

    int getAvailable() throws IOException {
        return this._request.getAvailable();
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    @Override
    protected void finishRequest() throws IOException {
        AsyncContextImpl comet = this._asyncContext;
        this._asyncContext = null;
        super.finishRequest();
        this.cleanup();
        if (this._closeOnExit != null) {
            for (int i = this._closeOnExit.size() - 1; i >= 0; --i) {
                Path path = this._closeOnExit.get(i);
                try {
                    path.remove();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        this._request = null;
    }

    public void cleanup() {
        HashMapImpl<String, Object> attributes = this._attributes;
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof ScopeRemoveListener)) continue;
                ((ScopeRemoveListener)value).removeEvent(this, entry.getKey());
            }
        }
    }

    public String getServletName() {
        if (this._invocation != null) {
            return this._invocation.getServletName();
        }
        return null;
    }

    public final Server getServer() {
        return this._request.getServer();
    }

    @Override
    public final WebApp getWebApp() {
        if (this._invocation != null) {
            return this._invocation.getWebApp();
        }
        return null;
    }

    public boolean isClosed() {
        return this._request == null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._request + "]";
    }

    static class WebSocketContextImpl
    implements WebSocketContext,
    SocketLinkDuplexListener {
        private final HttpServletRequestImpl _request;
        private final WebSocketListener _listener;
        private SocketLinkDuplexController _controller;

        WebSocketContextImpl(HttpServletRequestImpl request, HttpServletResponseImpl response, WebSocketListener listener) {
            this._request = request;
            this._listener = listener;
        }

        public void setController(SocketLinkDuplexController controller) {
            this._controller = controller;
        }

        public void setTimeout(long timeout) {
            this._controller.setIdleTimeMax(timeout);
        }

        public long getTimeout() {
            return this._controller.getIdleTimeMax();
        }

        public InputStream getInputStream() throws IOException {
            return this._controller.getReadStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this._controller.getWriteStream();
        }

        public void complete() {
            this._controller.complete();
        }

        void onStart() throws IOException {
            this._listener.onStart(this);
        }

        public void onRead(SocketLinkDuplexController duplex) throws IOException {
            do {
                this._listener.onRead(this);
            } while (this._request.getAvailable() > 0);
        }

        public void onComplete(SocketLinkDuplexController duplex) throws IOException {
            this._listener.onComplete(this);
        }

        public void onTimeout(SocketLinkDuplexController duplex) throws IOException {
            this._listener.onTimeout(this);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._listener + "]";
        }

        public void onStart(SocketLinkDuplexController context) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartImpl
    implements Part {
        private String _name;
        private Map<String, List<String>> _headers;
        private Object _value;
        private Path _newPath;

        private PartImpl(String name, Map<String, List<String>> headers) {
            this._name = name;
            this._headers = headers;
        }

        public void delete() throws IOException {
            Object value;
            if (this._newPath != null) {
                this._newPath.remove();
            }
            if (!((value = this.getValue()) instanceof FilePath)) {
                throw new IOException(L.l("Part.delete() is not applicable to part '{0}':'{1}'", (Object)this._name, value));
            }
            ((FilePath)value).remove();
        }

        public String getContentType() {
            String[] value = (String[])HttpServletRequestImpl.this._filledForm.get(this._name + ".content-type");
            if (value != null && value.length > 0) {
                return value[0];
            }
            return null;
        }

        public String getHeader(String name) {
            List<String> values = this._headers.get(name);
            if (values != null && values.size() > 0) {
                return values.get(0);
            }
            return null;
        }

        public Collection<String> getHeaderNames() {
            return this._headers.keySet();
        }

        public Collection<String> getHeaders(String name) {
            return this._headers.get(name);
        }

        public InputStream getInputStream() throws IOException {
            Object value = this.getValue();
            if (value instanceof FilePath) {
                return ((FilePath)value).openRead();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(value.toString().getBytes(UTF8));
            return is;
        }

        public String getName() {
            return this._name;
        }

        public long getSize() {
            Object value = this.getValue();
            if (value instanceof FilePath) {
                return ((Path)value).getLength();
            }
            if (value instanceof String) {
                return -1L;
            }
            if (value == null) {
                return -1L;
            }
            log.finest(L.l("Part.getSize() is not applicable to part'{0}':'{1}'", (Object)this._name, value));
            return -1L;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void write(String fileName) throws IOException {
            if (this._newPath != null) {
                throw new IOException(L.l("Contents of part '{0}' has already been written to '{1}'", (Object)this._name, this._newPath));
            }
            Object value = this.getValue();
            if (!(value instanceof FilePath)) {
                throw new IOException(L.l("Part.write() is not applicable to part '{0}':'{1}'", (Object)this._name, value));
            }
            Path path = (Path)value;
            MultipartConfigElement mc = HttpServletRequestImpl.this._invocation.getMultipartConfig();
            String location = mc.getLocation().replace('\\', '/');
            fileName = fileName.replace('\\', '/');
            String file = location.charAt(location.length() - 1) != '/' && fileName.charAt(fileName.length() - 1) != '/' ? location + '/' + fileName : location + fileName;
            this._newPath = Vfs.lookup(file);
            if (this._newPath.exists()) {
                throw new IOException(L.l("File '{0}' already exists.", this._newPath));
            }
            Path parent = this._newPath.getParent();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException(L.l("Unable to create path '{0}'. Check permissions.", parent));
            }
            if (path.renameTo(this._newPath)) return;
            WriteStream out = null;
            try {
                try {
                    out = this._newPath.openWrite();
                    path.writeToStream(out);
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, L.l("Cannot write contents of '{0}' to '{1}'", (Object)path, this._newPath), e);
                    throw e;
                }
                Object var11_9 = null;
                if (out == null) return;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
        }

        public Object getValue() {
            if (this._value != null) {
                return this._value;
            }
            String[] values = (String[])HttpServletRequestImpl.this._filledForm.get(this._name + ".file");
            if (values != null && values.length > 0) {
                this._value = Vfs.lookup(values[0]);
            } else {
                values = (String[])HttpServletRequestImpl.this._filledForm.get(this._name);
                if (values != null && values.length > 0) {
                    this._value = values[0];
                }
            }
            return this._value;
        }
    }
}

