/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.network.listen.SocketLink;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.RequestWrapper;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAdapter
extends RequestWrapper
implements CauchoRequest {
    private static final L10N L = new L10N(RequestAdapter.class);
    static final int MAX_DEPTH = 64;
    public static String JSP_EXCEPTION = "javax.servlet.jsp.jspException";
    public static String SHUTDOWN = "com.caucho.shutdown";
    private static final FreeList<RequestAdapter> _freeList = new FreeList(16);
    private WebApp _webApp;
    private HttpServletResponse _response;
    private HashMap<String, String> _roleMap;

    protected RequestAdapter() {
    }

    protected RequestAdapter(HttpServletRequest request, WebApp app) {
        super(request);
        this._webApp = app;
    }

    public static RequestAdapter create(HttpServletRequest request, WebApp app) {
        RequestAdapter reqAdapt = _freeList.allocate();
        if (reqAdapt == null) {
            return new RequestAdapter(request, app);
        }
        reqAdapt.setRequest(request);
        reqAdapt._webApp = app;
        return reqAdapt;
    }

    public static RequestAdapter create() {
        RequestAdapter reqAdapt = _freeList.allocate();
        if (reqAdapt != null) {
            return reqAdapt;
        }
        return new RequestAdapter();
    }

    public void init(HttpServletRequest request, HttpServletResponse response, WebApp app) throws ServletException {
        this.setRequest(request);
        this._response = response;
        this._webApp = app;
        if (request == this || request instanceof CauchoRequest && ((CauchoRequest)request).getRequestDepth(0) > 64) {
            throw new ServletException(L.l("too many servlet includes `{0}'", request.getRequestURI()));
        }
    }

    @Override
    public boolean isTop() {
        return false;
    }

    public void setWebApp(WebApp app) {
        this._webApp = app;
    }

    @Override
    public AbstractHttpRequest getAbstractHttpRequest() {
        HttpServletRequest request = this.getRequest();
        if (request instanceof CauchoRequest) {
            return ((CauchoRequest)request).getAbstractHttpRequest();
        }
        return null;
    }

    protected HttpServletResponse getResponse() {
        return this._response;
    }

    public void setResponse(CauchoResponse response) {
        this._response = response;
    }

    @Override
    public ReadStream getStream() throws IOException {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getStream();
        }
        return null;
    }

    @Override
    public String getPageURI() {
        String uri = (String)this.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            return uri;
        }
        return this.getRequestURI();
    }

    public static String getPageURI(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            return uri;
        }
        return request.getRequestURI();
    }

    @Override
    public String getPageContextPath() {
        String contextPath = (String)this.getAttribute("javax.servlet.include.context_path");
        if (contextPath != null) {
            return contextPath;
        }
        return this.getContextPath();
    }

    public static String getPageContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute("javax.servlet.include.context_path");
        if (contextPath != null) {
            return contextPath;
        }
        return request.getContextPath();
    }

    @Override
    public String getPageServletPath() {
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath != null) {
            return servletPath;
        }
        return this.getServletPath();
    }

    public static String getPageServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath != null) {
            return servletPath;
        }
        return request.getServletPath();
    }

    @Override
    public String getPagePathInfo() {
        String uri = (String)this.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            return (String)this.getAttribute("javax.servlet.include.path_info");
        }
        return this.getPathInfo();
    }

    public static String getPagePathInfo(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            return (String)request.getAttribute("javax.servlet.include.path_info");
        }
        return request.getPathInfo();
    }

    @Override
    public String getPageQueryString() {
        String uri = (String)this.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            return (String)this.getAttribute("javax.servlet.include.query_string");
        }
        return this.getQueryString();
    }

    public static String getPageQueryString(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            return (String)request.getAttribute("javax.servlet.include.query_string");
        }
        return request.getQueryString();
    }

    @Override
    public int getRequestDepth(int depth) {
        if (depth > 64) {
            throw new RuntimeException(L.l("too many request dispatchers"));
        }
        HttpServletRequest req = this.getRequest();
        while (req != null) {
            if (req instanceof CauchoRequest) {
                return ((CauchoRequest)req).getRequestDepth(depth + 1);
            }
            if (!(req instanceof ServletRequestWrapper)) break;
            ServletRequestWrapper reqWrap = (ServletRequestWrapper)req;
            req = reqWrap.getRequest();
        }
        return depth + 2;
    }

    @Override
    public void setHeader(String key, String value) {
    }

    @Override
    public void setSyntheticCacheHeader(boolean isSynthetic) {
    }

    @Override
    public boolean isSyntheticCacheHeader() {
        return false;
    }

    @Override
    public WebApp getWebApp() {
        return this._webApp;
    }

    @Override
    public void setVaryCookie(String cookie) {
        if (this.getRequest() instanceof CauchoRequest) {
            ((CauchoRequest)this.getRequest()).setVaryCookie(cookie);
        }
    }

    @Override
    public boolean getVaryCookies() {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getVaryCookies();
        }
        return false;
    }

    @Override
    public void setHasCookie() {
        if (this.getRequest() instanceof CauchoRequest) {
            ((CauchoRequest)this.getRequest()).setHasCookie();
        }
    }

    @Override
    public boolean getHasCookie() {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getHasCookie();
        }
        return false;
    }

    @Override
    public HttpSession getMemorySession() {
        return this.getSession(false);
    }

    @Override
    public HttpSession getSession(boolean create) {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(this.getCookieName(manager));
        HttpSession session = super.getSession(create);
        if (session != null) {
            this.setHasCookie();
        }
        return session;
    }

    @Override
    public String getRequestedSessionId() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(this.getCookieName(manager));
        String id = super.getRequestedSessionId();
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(this.getCookieName(manager));
        boolean isValid = super.isRequestedSessionIdValid();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(this.getCookieName(manager));
        boolean isValid = super.isRequestedSessionIdFromCookie();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(this.getCookieName(manager));
        boolean isValid = super.isRequestedSessionIdFromURL();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    @Override
    public boolean isSessionIdFromCookie() {
        CauchoRequest cReq = this.getCauchoRequest();
        if (cReq != null) {
            return cReq.isSessionIdFromCookie();
        }
        return this.isRequestedSessionIdFromCookie();
    }

    @Override
    public String getSessionId() {
        CauchoRequest cReq = this.getCauchoRequest();
        if (cReq != null) {
            return cReq.getSessionId();
        }
        return this.getRequestedSessionId();
    }

    @Override
    public void setSessionId(String sessionId) {
        CauchoRequest cReq = this.getCauchoRequest();
        if (cReq != null) {
            cReq.setSessionId(sessionId);
        }
    }

    protected final SessionManager getSessionManager() {
        WebApp app = this.getWebApp();
        if (app != null) {
            return app.getSessionManager();
        }
        return null;
    }

    protected final String getCookieName(SessionManager manager) {
        if (this.isSecure()) {
            return manager.getCookieName();
        }
        return manager.getSSLCookieName();
    }

    @Override
    public Cookie[] getCookies() {
        this.setVaryCookie(null);
        Cookie[] cookies = super.getCookies();
        if (cookies != null && cookies.length > 0) {
            this.setHasCookie();
        }
        return cookies;
    }

    @Override
    public Cookie getCookie(String name) {
        this.setVaryCookie(name);
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getCookie(name);
        }
        Cookie[] cookies = super.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            this.setHasCookie();
            return cookies[i];
        }
        return null;
    }

    @Override
    public boolean isComet() {
        return false;
    }

    @Override
    public boolean isDuplex() {
        return false;
    }

    @Override
    public void killKeepalive() {
    }

    @Override
    public boolean isKeepaliveAllowed() {
        return true;
    }

    @Override
    public SocketLink getSocketLink() {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getSocketLink();
        }
        return null;
    }

    @Override
    public boolean isClientDisconnect() {
        return false;
    }

    @Override
    public void clientDisconnect() {
    }

    public HashMap<String, String> setRoleMap(HashMap<String, String> map) {
        HashMap<String, String> oldMap = this._roleMap;
        this._roleMap = map;
        return oldMap;
    }

    @Override
    public boolean isUserInRole(String role) {
        String newRole;
        if (this._roleMap != null && (newRole = this._roleMap.get(role)) != null) {
            role = newRole;
        }
        return super.isUserInRole(role);
    }

    @Override
    public boolean isLoginRequested() {
        return false;
    }

    @Override
    public void requestLogin() {
    }

    @Override
    public boolean login(boolean isFail) {
        return true;
    }

    @Override
    public boolean isSuspend() {
        return false;
    }

    @Override
    public boolean hasRequest() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.getRequest().authenticate(response);
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.getRequest().getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getRequest().getParts();
    }

    public void login(String username, String password) throws ServletException {
        this.getRequest().login(username, password);
    }

    public void logout() throws ServletException {
        this.getRequest().logout();
    }

    public CauchoRequest getCauchoRequest() {
        return (CauchoRequest)this.getRequest();
    }

    public static void free(RequestAdapter reqAdapt) {
        reqAdapt.free();
        _freeList.free(reqAdapt);
    }

    @Override
    protected void free() {
        super.free();
        this._webApp = null;
        this._response = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this._request + ']';
    }
}

