/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.http.ResponseWrapper;
import com.caucho.server.http.ResponseWriter;
import com.caucho.server.http.ServletOutputStreamImpl;
import com.caucho.server.http.WrapperResponseStream;
import com.caucho.util.FreeList;
import com.caucho.vfs.FlushBuffer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseAdapter
extends ResponseWrapper
implements CauchoResponse {
    private static final Logger log = Logger.getLogger(ResponseAdapter.class.getName());
    private static final FreeList<ResponseAdapter> _freeList = new FreeList(32);
    protected RequestAdapter _request;
    protected FlushBuffer _flushBuffer;
    protected AbstractResponseStream _originalResponseStream;
    protected AbstractResponseStream _responseStream;
    private ServletOutputStreamImpl _os;
    private ResponseWriter _writer;
    private boolean _hasOutputStream;
    private boolean _hasError;

    private ResponseAdapter() {
    }

    protected ResponseAdapter(HttpServletResponse response) {
        this.setResponse(response);
        this._originalResponseStream = this.createWrapperResponseStream();
        this._os = new ServletOutputStreamImpl();
        this._writer = new ResponseWriter();
    }

    public static ResponseAdapter create(HttpServletResponse response) {
        ResponseAdapter resAdapt = _freeList.allocate();
        if (resAdapt == null) {
            resAdapt = new ResponseAdapter(response);
        } else {
            resAdapt.setResponse(response);
        }
        resAdapt.init(response);
        return resAdapt;
    }

    void setRequest(RequestAdapter request) {
        this._request = request;
    }

    protected AbstractResponseStream createWrapperResponseStream() {
        return new WrapperResponseStream();
    }

    public void init(HttpServletResponse response) {
        this.setResponse(response);
        this._hasError = false;
        this._responseStream = this._originalResponseStream;
        if (this._originalResponseStream instanceof WrapperResponseStream) {
            WrapperResponseStream wrapper = (WrapperResponseStream)this._originalResponseStream;
            wrapper.init(response);
        }
        this._originalResponseStream.start();
        this._os.init(this._originalResponseStream);
        this._writer.init(this._originalResponseStream);
    }

    @Override
    public AbstractResponseStream getResponseStream() {
        return this._responseStream;
    }

    @Override
    public boolean isCauchoResponseStream() {
        return false;
    }

    @Override
    public void setResponseStream(AbstractResponseStream responseStream) {
        this._responseStream = responseStream;
        this._os.init(responseStream);
        this._writer.init(responseStream);
    }

    public boolean isTop() {
        return false;
    }

    @Override
    public void resetBuffer() {
        super.resetBuffer();
        this._responseStream.clearBuffer();
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        this.resetBuffer();
        super.sendRedirect(url);
    }

    @Override
    public int getBufferSize() {
        return this._responseStream.getBufferSize();
    }

    @Override
    public void setBufferSize(int size) {
        this._responseStream.setBufferSize(size);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this._os;
    }

    public void setFlushBuffer(FlushBuffer flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    public FlushBuffer getFlushBuffer() {
        return this._flushBuffer;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this._writer;
    }

    @Override
    public void setContentType(String value) {
        super.setContentType(value);
        try {
            this._responseStream.setEncoding(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this._request != null) {
            this._request.setHasCookie();
        }
        super.addCookie(cookie);
    }

    @Override
    public String getHeader(String key) {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    @Override
    public void setFooter(String key, String value) {
    }

    @Override
    public void addFooter(String key, String value) {
    }

    public int getRemaining() {
        return this._responseStream.getRemaining();
    }

    @Override
    public void setForbidForward(boolean forbid) {
    }

    @Override
    public boolean getForbidForward() {
        return false;
    }

    @Override
    public String getStatusMessage() {
        if (this._response instanceof CauchoResponse) {
            return ((CauchoResponse)this._response).getStatusMessage();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    @Override
    public boolean hasError() {
        return this._hasError;
    }

    @Override
    public void killCache() {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).killCache();
        }
    }

    @Override
    public void setPrivateCache(boolean isPrivate) {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setPrivateCache(isPrivate);
        }
    }

    @Override
    public void setNoCache(boolean isPrivate) {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setNoCache(isPrivate);
        }
    }

    @Override
    public void setSessionId(String id) {
        if (this.getResponse() instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setSessionId(id);
        }
    }

    @Override
    public boolean isNoCacheUnlessVary() {
        CauchoResponse cRes = this.getCauchoResponse();
        if (cRes != null) {
            return cRes.isNoCacheUnlessVary();
        }
        return false;
    }

    public CauchoResponse getCauchoResponse() {
        ServletResponse response = this.getResponse();
        if (response instanceof CauchoResponse) {
            return (CauchoResponse)response;
        }
        return null;
    }

    public void finish() throws IOException {
        if (this._responseStream != null) {
            this._responseStream.flushBuffer();
        }
        this._responseStream = this._originalResponseStream;
    }

    @Override
    public void close() throws IOException {
        ServletResponse response = this.getResponse();
        AbstractResponseStream responseStream = this._responseStream;
        this._responseStream = this._originalResponseStream;
        if (responseStream != null) {
            responseStream.close();
        }
        if (this._originalResponseStream != responseStream) {
            this._originalResponseStream.close();
        }
        if (response instanceof CauchoResponse) {
            ((CauchoResponse)response).close();
        }
    }

    public int getStatus() {
        return this._response.getStatus();
    }

    public Collection<String> getHeaders(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this._response.getHeaderNames();
    }

    @Override
    public void setForwardEnclosed(boolean isForwardEnclosed) {
    }

    @Override
    public boolean isForwardEnclosed() {
        return false;
    }

    public static void free(ResponseAdapter resAdapt) {
        resAdapt.free();
        _freeList.free(resAdapt);
    }

    protected void free() {
        this._request = null;
        this._responseStream = null;
        this.setResponse(null);
    }
}

