/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.env.meter.SemaphoreMeter;
import com.caucho.env.thread.TaskWorker;
import com.caucho.log.AbstractRolloverLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.log.LogBuffer;
import com.caucho.util.Alarm;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessLogWriter
extends AbstractRolloverLog {
    protected static final L10N L = new L10N(AccessLogWriter.class);
    protected static final Logger log = Logger.getLogger(AccessLogWriter.class.getName());
    private static final int BUFFER_SIZE = 65536;
    private static final int BUFFER_GAP = 8192;
    private final AccessLog _log;
    private boolean _isAutoFlush;
    private final Object _bufferLock = new Object();
    private final Semaphore _logSemaphore = new Semaphore(16384);
    private final FreeList<LogBuffer> _freeList = new FreeList(512);
    private LogBuffer _logHead;
    private LogBuffer _logTail;
    private int _logQueueSize;
    private final LogWriterTask _logWriterTask = new LogWriterTask();
    private SemaphoreMeter _semaphoreProbe;

    AccessLogWriter(AccessLog log) {
        this._log = log;
    }

    public void init() throws IOException {
        super.init();
        this._isAutoFlush = this._log.isAutoFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeThrough(byte[] buffer, int offset, int length) throws IOException {
        Object object = this._bufferLock;
        synchronized (object) {
            this.write(buffer, offset, length);
        }
        this.flushStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBuffer(LogBuffer buffer) {
        Object object = this._bufferLock;
        synchronized (object) {
            if (this._logTail != null) {
                this._logTail.setNext(buffer);
                this._logTail = buffer;
                ++this._logQueueSize;
            } else {
                this._logHead = buffer;
                this._logTail = buffer;
                this._logQueueSize = 1;
            }
        }
        if (this._logQueueSize > 64 || this._isAutoFlush) {
            this._logWriterTask.wake();
        }
    }

    protected void flush() {
        this._logWriterTask.wake();
    }

    protected void waitForFlush(long timeout) {
        long expire = Alarm.getCurrentTimeActual() + timeout;
        while (this._logHead != null) {
            long delta = expire - Alarm.getCurrentTimeActual();
            if (delta < 0L) {
                return;
            }
            if (delta > 50L) {
                delta = 50L;
            }
            try {
                this._logWriterTask.wake();
                Thread.sleep(delta);
            }
            catch (Exception e) {
            }
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushBuffer() {
        LogBuffer ptr = null;
        Object object = this._bufferLock;
        synchronized (object) {
            ptr = this._logHead;
            this._logHead = null;
            this._logTail = null;
            this._logQueueSize = 0;
        }
        if (ptr == null) {
            return false;
        }
        while (ptr != null) {
            LogBuffer next = ptr.getNext();
            ptr.setNext(null);
            try {
                this.write(ptr.getBuffer(), 0, ptr.getLength());
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                this.freeBuffer(ptr);
            }
            ptr = next;
        }
        try {
            this.flushStream();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return true;
    }

    LogBuffer allocateBuffer() {
        try {
            Thread.interrupted();
            this._logSemaphore.acquire();
            if (this._semaphoreProbe != null) {
                this._semaphoreProbe.acquire();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogBuffer buffer = this._freeList.allocate();
        if (buffer == null) {
            buffer = new LogBuffer();
        }
        return buffer;
    }

    void freeBuffer(LogBuffer logBuffer) {
        this._logSemaphore.release();
        if (this._semaphoreProbe != null) {
            this._semaphoreProbe.release();
        }
        logBuffer.setNext(null);
        this._freeList.free(logBuffer);
    }

    public void destroy() throws IOException {
        this._logWriterTask.destroy();
    }

    class LogWriterTask
    extends TaskWorker {
        LogWriterTask() {
        }

        public long runTask() {
            AccessLogWriter.this.flushBuffer();
            return -1L;
        }
    }
}

