/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.resin.BootPodConfig;
import com.caucho.server.resin.BootResinConfig;
import com.caucho.server.resin.BootServerConfig;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootClusterConfig
implements SchemaBean {
    private static final L10N L = new L10N(BootClusterConfig.class);
    private BootResinConfig _resinConfig;
    private CloudCluster _cloudCluster;
    private String _id;
    private ContainerProgram _clusterProgram = new ContainerProgram();
    private ContainerProgram _serverDefaultProgram = new ContainerProgram();
    private ArrayList<BootPodConfig> _pods = new ArrayList();

    public BootClusterConfig(BootResinConfig resinConfig) {
        this._resinConfig = resinConfig;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/cluster.rnc";
    }

    public String getId() {
        return this._id;
    }

    @Configurable
    public void setId(String id) {
        this._id = id;
    }

    @Configurable
    public void addServerDefault(ContainerProgram program) {
        this._serverDefaultProgram.addProgram(program);
    }

    public ContainerProgram getServerDefault() {
        return this._serverDefaultProgram;
    }

    @Configurable
    public BootPodConfig createPod() throws ConfigException {
        BootPodConfig pod = new BootPodConfig(this);
        this._pods.add(pod);
        return pod;
    }

    @Configurable
    public void addPod(BootPodConfig pod) {
        this._pods.add(pod);
    }

    @Configurable
    public BootServerConfig createServer() throws ConfigException {
        if (this._pods.size() == 0) {
            this.addPod(this.createPod());
        }
        BootPodConfig pod = this._pods.get(0);
        return pod.createServer();
    }

    @Configurable
    public void addServer(BootServerConfig server) {
        if (this._pods.size() == 0) {
            this.addPod(this.createPod());
        }
        BootPodConfig pod = this._pods.get(0);
        pod.addServer(server);
    }

    public ArrayList<BootPodConfig> getPodList() {
        return this._pods;
    }

    public void addContentProgram(ConfigProgram program) {
        this._clusterProgram.addProgram(program);
    }

    ConfigProgram getProgram() {
        return this._clusterProgram;
    }

    @PostConstruct
    public void init() {
        if (this._id == null) {
            throw new ConfigException(L.l("'id' is a require attribute for <cluster>"));
        }
        CloudCluster cluster = this.getCloudCluster();
        cluster.putData(new ClusterServerProgram(this._serverDefaultProgram));
        this.getCloudPod();
    }

    CloudCluster getCloudCluster() {
        if (this._id == null) {
            throw new ConfigException(L.l("'id' is a require attribute for <cluster>"));
        }
        if (this._cloudCluster == null) {
            this._cloudCluster = this._resinConfig.getCloudSystem().findCluster(this._id);
            if (this._cloudCluster == null) {
                this._cloudCluster = this._resinConfig.getCloudSystem().createCluster(this._id);
            }
        }
        return this._cloudCluster;
    }

    CloudPod getCloudPod() {
        if (this._pods.size() == 0) {
            this.addPod(this.createPod());
        }
        return this._pods.get(0).getCloudPod();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

