/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.resin.BootPodConfig;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;

public class BootServerConfig
implements SchemaBean {
    private static final L10N L = new L10N(BootServerConfig.class);
    private final BootPodConfig _pod;
    private String _id = "default";
    private String _address = "127.0.0.1";
    private int _port = -1;
    private boolean _isSecure;
    private ContainerProgram _serverProgram = new ContainerProgram();
    private CloudServer _cloudServer;

    public BootServerConfig(BootPodConfig pod) {
        this._pod = pod;
    }

    public BootPodConfig getPod() {
        return this._pod;
    }

    public String getSchema() {
        return "com/caucho/server/resin/server.rnc";
    }

    public String getId() {
        return this._id;
    }

    @Configurable
    public void setId(String id) {
        if (id.equals("")) {
            id = "default";
        }
        this._id = id;
    }

    public String getAddress() {
        return this._address;
    }

    @Configurable
    public void setAddress(String address) {
        this._address = address;
    }

    public int getPort() {
        return this._port;
    }

    @Configurable
    public void setPort(int port) {
        this._port = port;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    public CloudServer getCloudServer() {
        return this._cloudServer;
    }

    @PostConstruct
    public void init() {
        CloudPod pod = this._pod.getCloudPod();
        if (pod.getServerLength() >= 64) {
            throw new ConfigException(L.l("The server cannot be added to the current pod because it would be more than 64 servers to the pod."));
        }
        this._cloudServer = pod.createStaticServer(this.getId(), this.getAddress(), this.getPort(), this.isSecure());
        this._cloudServer.putData(new ClusterServerProgram(this._serverProgram));
    }

    ClusterServer getClusterServer() {
        return this._cloudServer.getData(ClusterServer.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

