/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.log.EnvironmentStream;
import com.caucho.log.RotateStream;
import com.caucho.server.util.JniCauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResinArgs {
    private static final Logger log = Logger.getLogger(ResinArgs.class.getName());
    private static final L10N L = new L10N(ResinArgs.class);
    private String _serverId = "default";
    private Path _resinHome;
    private Path _rootDirectory;
    private String _resinConf;
    private Socket _pingSocket;
    private DynamicServer _dynServer;
    private ArrayList<BoundPort> _boundPortList = new ArrayList();
    private String _stage = null;
    private boolean _isDumpHeapOnExit;

    public ResinArgs(String[] args) throws Exception {
        this.preConfigureInit();
        this.parseCommandLine(args);
    }

    private void preConfigureInit() {
        String resinHome = System.getProperty("resin.home");
        this._resinHome = resinHome != null ? Vfs.lookup(resinHome) : Vfs.getPwd();
        this._rootDirectory = this._resinHome;
        String resinRoot = System.getProperty("server.root");
        if (resinRoot != null) {
            this._rootDirectory = Vfs.lookup(resinRoot);
        }
        if ((resinRoot = System.getProperty("resin.root")) != null) {
            this._rootDirectory = Vfs.lookup(resinRoot);
        }
    }

    public String getServerId() {
        return this._serverId;
    }

    public Path getResinHome() {
        return this._resinHome;
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public Socket getPingSocket() {
        return this._pingSocket;
    }

    public String getResinConf() {
        return this._resinConf;
    }

    public Path getResinConfPath() {
        Path pwd = Vfs.lookup();
        Path resinConf = null;
        String resinConfFile = this.getResinConf();
        if (resinConfFile != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " looking for conf in " + pwd.lookup(resinConfFile));
            }
            resinConf = pwd.lookup(resinConfFile);
        } else {
            resinConfFile = pwd.lookup("conf/resin.xml").canRead() ? "conf/resin.xml" : "conf/resin.conf";
        }
        Path rootDirectory = this.getRootDirectory();
        if (resinConf == null || !resinConf.exists()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " looking for conf in " + rootDirectory.lookup(resinConfFile));
            }
            resinConf = this._rootDirectory.lookup(resinConfFile);
        }
        if (!resinConf.exists() && !this._resinHome.equals(this._rootDirectory)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " looking for conf in " + this._resinHome.lookup(resinConfFile));
            }
            resinConf = this._resinHome.lookup(resinConfFile);
        }
        if (!resinConf.exists()) {
            resinConf = rootDirectory.lookup(resinConfFile);
        }
        return resinConf;
    }

    public ArrayList<BoundPort> getBoundPortList() {
        return this._boundPortList;
    }

    public String getStage() {
        return this._stage;
    }

    public DynamicServer getDynamicServer() {
        return this._dynServer;
    }

    public boolean isDumpHeapOnExit() {
        return this._isDumpHeapOnExit;
    }

    private void parseCommandLine(String[] argv) throws Exception {
        int len = argv.length;
        int i = 0;
        while (i < len) {
            RotateStream stream;
            if (i + 1 < len && (argv[i].equals("-stdout") || argv[i].equals("--stdout"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.init();
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStdout(out);
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-stderr") || argv[i].equals("--stderr"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                stream.init();
                WriteStream out = stream.getStream();
                out.setDisableClose(true);
                EnvironmentStream.setStderr(out);
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-conf") || argv[i].equals("--conf"))) {
                this._resinConf = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-log-directory") || argv[i].equals("--log-directory")) {
                i += 2;
                continue;
            }
            if (argv[i].equals("-config-server") || argv[i].equals("--config-server")) {
                i += 2;
                continue;
            }
            if (argv[i].equals("--dump-heap-on-exit")) {
                this._isDumpHeapOnExit = true;
                ++i;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-dynamic-server") || argv[i].equals("--dynamic-server"))) {
                String[] values = argv[i + 1].split(":");
                if (values.length == 3) {
                    String clusterId = values[0];
                    String address = values[1];
                    int port = Integer.parseInt(values[2]);
                    this._dynServer = new DynamicServer(clusterId, address, port);
                } else {
                    System.out.println("-dynamic-server requires 'cluster:address:port' at '" + argv[i + 1] + "'");
                    System.exit(66);
                }
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-server") || argv[i].equals("--server"))) {
                this._serverId = argv[i + 1];
                if (this._serverId.equals("")) {
                    this._serverId = "default";
                }
                i += 2;
                continue;
            }
            if (argv[i].equals("-resin-home") || argv[i].equals("--resin-home")) {
                this._resinHome = Vfs.lookup(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-root-directory") || argv[i].equals("--root-directory") || argv[i].equals("-resin-root") || argv[i].equals("--resin-root") || argv[i].equals("-server-root") || argv[i].equals("--server-root")) {
                this._rootDirectory = this._resinHome.lookup(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-service")) {
                JniCauchoSystem.create().initJniBackground();
                ++i;
                continue;
            }
            if (argv[i].equals("-version") || argv[i].equals("--version")) {
                System.out.println(VersionFactory.getFullVersion());
                System.exit(66);
                continue;
            }
            if (argv[i].equals("-watchdog-port") || argv[i].equals("--watchdog-port")) {
                i += 2;
                continue;
            }
            if (argv[i].equals("-socketwait") || argv[i].equals("--socketwait") || argv[i].equals("-pingwait") || argv[i].equals("--pingwait")) {
                int socketport = Integer.parseInt(argv[i + 1]);
                Socket socket = null;
                for (int k = 0; k < 15 && socket == null; ++k) {
                    try {
                        socket = new Socket("127.0.0.1", socketport);
                    }
                    catch (Throwable e) {
                        System.out.println(new Date());
                        e.printStackTrace();
                    }
                    if (socket != null) continue;
                    Thread.sleep(1000L);
                }
                if (socket == null) {
                    System.err.println("Can't connect to parent process through socket " + socketport);
                    System.err.println("Resin needs to connect to its parent.");
                    System.exit(0);
                }
                this._pingSocket = socket;
                i += 2;
                continue;
            }
            if ("-port".equals(argv[i]) || "--port".equals(argv[i])) {
                int fd = Integer.parseInt(argv[i + 1]);
                String addr = argv[i + 2];
                if ("null".equals(addr)) {
                    addr = null;
                }
                int port = Integer.parseInt(argv[i + 3]);
                this._boundPortList.add(new BoundPort(QJniServerSocket.openJNI(fd, port), addr, port));
                i += 4;
                continue;
            }
            if ("start".equals(argv[i]) || "restart".equals(argv[i])) {
                JniCauchoSystem.create().initJniBackground();
                ++i;
                continue;
            }
            if (argv[i].equals("-verbose") || argv[i].equals("--verbose")) {
                ++i;
                continue;
            }
            if (argv[i].equals("gui")) {
                ++i;
                continue;
            }
            if (argv[i].equals("console")) {
                ++i;
                continue;
            }
            if (argv[i].equals("-fine") || argv[i].equals("--fine")) {
                ++i;
                continue;
            }
            if (argv[i].equals("-finer") || argv[i].equals("--finer")) {
                ++i;
                continue;
            }
            if (argv[i].startsWith("-D") || argv[i].startsWith("-J") || argv[i].startsWith("-X")) {
                ++i;
                continue;
            }
            if ("-stage".equals(argv[i]) || "--stage".equals(argv[i])) {
                this._stage = argv[i + 1];
                i += 2;
                continue;
            }
            if ("-preview".equals(argv[i]) || "--preview".equals(argv[i])) {
                this._stage = "preview";
                ++i;
                continue;
            }
            if ("-debug-port".equals(argv[i]) || "--debug-port".equals(argv[i])) {
                i += 2;
                continue;
            }
            if ("-jmx-port".equals(argv[i]) || "--jmx-port".equals(argv[i])) {
                i += 2;
                continue;
            }
            System.out.println(L.l("unknown argument '{0}'", argv[i]));
            System.out.println();
            ResinArgs.usage();
            System.exit(66);
        }
    }

    private static void usage() {
        System.err.println(L.l("usage: java -jar resin.jar [-options] [start | stop | restart]"));
        System.err.println(L.l(""));
        System.err.println(L.l("where options include:"));
        System.err.println(L.l("   -conf <file>          : select a configuration file"));
        System.err.println(L.l("   -log-directory <dir>  : select a logging directory"));
        System.err.println(L.l("   -resin-home <dir>     : select a resin home directory"));
        System.err.println(L.l("   -root-directory <dir> : select a root directory"));
        System.err.println(L.l("   -server <id>          : select a <server> to run"));
        System.err.println(L.l("   -watchdog-port <port> : override the watchdog-port"));
        System.err.println(L.l("   -verbose              : print verbose starting information"));
        System.err.println(L.l("   -preview              : run as a preview server"));
    }

    static class BoundPort {
        private QServerSocket _ss;
        private String _address;
        private int _port;

        BoundPort(QServerSocket ss, String address, int port) {
            if (ss == null) {
                throw new NullPointerException();
            }
            this._ss = ss;
            this._address = address;
            this._port = port;
        }

        public QServerSocket getServerSocket() {
            return this._ss;
        }

        public int getPort() {
            return this._port;
        }

        public String getAddress() {
            return this._address;
        }
    }

    static class DynamicServer {
        private final String _cluster;
        private final String _address;
        private final int _port;

        DynamicServer(String cluster, String address, int port) {
            this._cluster = cluster;
            this._address = address;
            this._port = port;
        }

        String getCluster() {
            return this._cluster;
        }

        String getAddress() {
            return this._address;
        }

        int getPort() {
            return this._port;
        }
    }
}

