/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.vfs.Path;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ResinELContext {
    private final JavaVar _javaVar = new JavaVar();
    private final ResinVar _resinVar = new ResinVar();
    private final ServerVar _serverVar = new ServerVar();

    public JavaVar getJavaVar() {
        return this._javaVar;
    }

    public ResinVar getResinVar() {
        return this._resinVar;
    }

    public ServerVar getServerVar() {
        return this._serverVar;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    public abstract Path getResinHome();

    public abstract Path getRootDirectory();

    public abstract Path getResinConf();

    public abstract String getServerId();

    public abstract boolean isResinProfessional();

    public class ServerVar {
        public String getId() {
            return ResinELContext.this.getServerId();
        }

        public Path getRoot() {
            return ResinELContext.this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }
    }

    public class ResinVar {
        public String getServerId() {
            return ResinELContext.this.getServerId();
        }

        public String getId() {
            return this.getServerId();
        }

        public String getAddress() {
            try {
                if (Alarm.isTest()) {
                    return "127.0.0.1";
                }
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                Logger.getLogger(ResinELContext.class.getName()).log(Level.FINE, e.toString(), e);
                return "localhost";
            }
        }

        public Path getConf() {
            return ResinELContext.this.getResinConf();
        }

        public Path getHome() {
            return ResinELContext.this.getResinHome();
        }

        public Path getRoot() {
            return ResinELContext.this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public String getUserName() {
            return System.getProperty("user.name");
        }

        public String getVersion() {
            if (Alarm.isTest()) {
                return "3.1.test";
            }
            return VersionFactory.getVersion();
        }

        public String getHostName() {
            try {
                if (Alarm.isTest()) {
                    return "localhost";
                }
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                Logger.getLogger(ResinELContext.class.getName()).log(Level.FINE, e.toString(), e);
                return "localhost";
            }
        }

        public boolean isProfessional() {
            return ResinELContext.this.isResinProfessional();
        }
    }

    public class JavaVar {
        public boolean isJava5() {
            return CauchoSystem.isJdk15();
        }

        public String getVersion() {
            return System.getProperty("java.version");
        }
    }
}

