/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.util.L10N;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LocaleCondition
extends AbstractCondition {
    private static final L10N L = new L10N(LocaleCondition.class);
    private final Pattern _regexp;
    private boolean _sendVary = true;

    LocaleCondition(String regexp) {
        this._regexp = Pattern.compile(regexp, 2);
    }

    public String getTagName() {
        return "locale";
    }

    public void setSendVary(boolean sendVary) {
        this._sendVary = sendVary;
    }

    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        Locale locale;
        if (this._sendVary) {
            this.addHeaderValue(response, "Vary", "Accept-Language");
        }
        if ((locale = request.getLocale()) == null) {
            return false;
        }
        return this._regexp.matcher(locale.toString()).find();
    }
}

