/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.rewrite.RequestPredicate;
import com.caucho.server.http.HttpServletResponseImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class MatchFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(MatchFilterChain.class.getName());
    private final RequestPredicate[] _predicates;
    private final FilterChain _passChain;
    private final FilterChain _failChain;

    public MatchFilterChain(RequestPredicate[] predicates, FilterChain passChain, FilterChain failChain) {
        this._predicates = predicates;
        this._passChain = passChain;
        this._failChain = failChain;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (response instanceof HttpServletResponseImpl) {
            HttpServletResponseImpl res = (HttpServletResponseImpl)response;
            res.setNoCacheUnlessVary(true);
        }
        for (RequestPredicate predicate : this._predicates) {
            if (predicate.isMatch(req)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this + " not match");
            }
            this._failChain.doFilter(request, response);
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finest(this + " match");
        }
        this._passChain.doFilter(request, response);
    }
}

