/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.RequestAdapter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SetRequestSecureFilterChain
implements FilterChain {
    private final FilterChain _next;
    private Boolean _isSecure;

    public SetRequestSecureFilterChain(FilterChain next, Boolean isSecure) {
        this._next = next;
        this._isSecure = isSecure;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        SetRequestSecureFilterChain.doFilter(request, response, this._next, this._isSecure);
    }

    public static void doFilter(ServletRequest request, ServletResponse response, FilterChain next, boolean isSecure) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req instanceof HttpServletRequestImpl) {
            HttpServletRequestImpl requestFacade = (HttpServletRequestImpl)req;
            requestFacade.setSecure(true);
            next.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            req = new SecureServletRequestWrapper(req, isSecure);
            next.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    public static class SecureServletRequestWrapper
    extends RequestAdapter {
        private Boolean _isSecure;

        public SecureServletRequestWrapper(HttpServletRequest request, Boolean isSecure) {
            this.setRequest(request);
            if (request instanceof CauchoRequest) {
                this.setWebApp(((CauchoRequest)request).getWebApp());
            }
            this._isSecure = isSecure;
        }

        public boolean isSecure() {
            return this._isSecure;
        }

        public String getScheme() {
            return this.isSecure() ? "https" : "http";
        }
    }
}

