/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.server.session.JavaSessionSerializer;
import com.caucho.server.session.SessionDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaSessionDeserializer
extends SessionDeserializer {
    private static final Logger log = Logger.getLogger(JavaSessionSerializer.class.getName());
    private ObjectInputStream _in;

    public JavaSessionDeserializer(InputStream is) throws IOException {
        this._in = new ContextObjectInputStream(is);
    }

    public int readInt() throws IOException {
        return this._in.readInt();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this._in.readObject();
    }

    public void close() {
        ObjectInputStream in = this._in;
        this._in = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    static class ContextObjectInputStream
    extends ObjectInputStream {
        private ClassLoader _loader;

        ContextObjectInputStream(InputStream is) throws IOException {
            super(is);
            Thread thread = Thread.currentThread();
            this._loader = thread.getContextClassLoader();
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String name = v.getName();
            return Class.forName(name, false, this._loader);
        }
    }
}

