/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp;

import com.caucho.server.snmp.SnmpParsingException;
import com.caucho.server.snmp.types.CounterValue;
import com.caucho.server.snmp.types.GaugeValue;
import com.caucho.server.snmp.types.IntegerValue;
import com.caucho.server.snmp.types.IpAddressValue;
import com.caucho.server.snmp.types.NullValue;
import com.caucho.server.snmp.types.ObjectIdentifierValue;
import com.caucho.server.snmp.types.OctetStringValue;
import com.caucho.server.snmp.types.OpaqueValue;
import com.caucho.server.snmp.types.PduValue;
import com.caucho.server.snmp.types.SequenceValue;
import com.caucho.server.snmp.types.SnmpMessageValue;
import com.caucho.server.snmp.types.SnmpValue;
import com.caucho.server.snmp.types.TimeTicksValue;
import com.caucho.server.snmp.types.VarBindListValue;
import com.caucho.server.snmp.types.VarBindValue;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpParser {
    private static final L10N L = new L10N(SnmpParser.class);
    private InputStream _is;
    private int _bytesRead = 0;
    private boolean _isCheckIdentifier = true;

    public SnmpParser(InputStream is) {
        this._is = is;
    }

    public SnmpParser(String s) {
        this._is = new StringInputStream(s);
    }

    public SnmpMessageValue readMessage() throws IOException {
        PduValue pdu;
        this.checkIdentifier(48);
        int expectedLen = this.readLength();
        int bytesRead = this.getBytesRead();
        IntegerValue version = this.readInteger();
        OctetStringValue communityString = this.readOctetString();
        int id = this.readByte();
        this._isCheckIdentifier = false;
        switch (id) {
            case 160: {
                pdu = this.readGetRequestPdu();
                break;
            }
            case 161: {
                pdu = this.readGetNextRequestPdu();
                break;
            }
            case 163: {
                pdu = this.readSetRequestPdu();
                break;
            }
            case 162: {
                pdu = this.readGetResponsePdu();
                break;
            }
            default: {
                throw new SnmpParsingException(L.l("unknown PDU type '{0}'", id));
            }
        }
        this.checkLength(expectedLen, this.getBytesRead() - bytesRead);
        return new SnmpMessageValue(version, communityString, pdu);
    }

    public PduValue readGetRequestPdu() throws IOException {
        return this.readPdu(160);
    }

    public PduValue readGetNextRequestPdu() throws IOException {
        return this.readPdu(161);
    }

    public PduValue readSetRequestPdu() throws IOException {
        return this.readPdu(163);
    }

    public PduValue readGetResponsePdu() throws IOException {
        return this.readPdu(162);
    }

    private PduValue readPdu(int type) throws IOException {
        this.checkIdentifier(type);
        int expectedLen = this.readLength();
        int bytesRead = this.getBytesRead();
        IntegerValue requestId = this.readInteger();
        IntegerValue error = this.readInteger();
        IntegerValue errorIndex = this.readInteger();
        VarBindListValue varBindList = this.readVarBindList();
        this.checkLength(expectedLen, this.getBytesRead() - bytesRead);
        return PduValue.create(type, requestId, error, errorIndex, varBindList);
    }

    public VarBindListValue readVarBindList() throws IOException {
        int bytesRead;
        this.checkIdentifier(48);
        int expectedLen = this.readLength();
        VarBindListValue varBindList = new VarBindListValue();
        for (bytesRead = 0; bytesRead < expectedLen; bytesRead += this.getBytesRead()) {
            bytesRead -= this.getBytesRead();
            varBindList.addVarBind(this.readVarBind());
        }
        this.checkLength(expectedLen, bytesRead);
        return varBindList;
    }

    public VarBindValue readVarBind() throws IOException {
        this.checkIdentifier(48);
        int expectedLen = this.readLength();
        int bytesRead = this.getBytesRead();
        VarBindValue varBind = new VarBindValue(this.readObjectIdentifier(), this.read());
        this.checkLength(expectedLen, this.getBytesRead() - bytesRead);
        return varBind;
    }

    public void skipObject() throws IOException {
        this.readByte();
        int len = this.readLength();
        for (int i = 0; i < len; ++i) {
            this.readByte();
        }
    }

    public SnmpValue read() throws IOException {
        int identifier = this.readByte();
        this._isCheckIdentifier = false;
        switch (identifier) {
            case 5: {
                return this.readNull();
            }
            case 2: {
                return this.readInteger();
            }
            case 4: {
                return this.readOctetString();
            }
            case 6: {
                return this.readObjectIdentifier();
            }
            case 48: {
                return this.readSequence();
            }
            case 64: {
                return this.readIpAddress();
            }
            case 65: {
                return this.readCounter();
            }
            case 66: {
                return this.readGauge();
            }
            case 67: {
                return this.readTimeTicks();
            }
            case 68: {
                return this.readOpaque();
            }
            case 160: {
                return this.readGetRequestPdu();
            }
            case 161: {
                return this.readGetNextRequestPdu();
            }
            case 162: {
                return this.readGetResponsePdu();
            }
            case 163: {
                return this.readSetRequestPdu();
            }
        }
        throw new SnmpParsingException(L.l("unknown identifier {0}", identifier));
    }

    public NullValue readNull() throws IOException {
        this.checkIdentifier(5);
        int len = this.readLength();
        if (len != 0) {
            throw new SnmpParsingException("length must be zero for NULL");
        }
        return NullValue.NULL;
    }

    public IntegerValue readInteger() throws IOException {
        this.checkIdentifier(2);
        int len = this.readLength();
        if (len < 1 || len > 4) {
            throw new SnmpParsingException(L.l("integer length {0} must be 1-4"));
        }
        int value = this.readByte();
        boolean isNeg = (value & 0x80) > 0;
        for (int i = 1; i < len; ++i) {
            value <<= 8;
            value |= this.readByte();
        }
        if (isNeg) {
            while (len != 4) {
                value |= 255 << 8 * len++;
            }
        }
        return new IntegerValue(value);
    }

    public OctetStringValue readOctetString() throws IOException {
        this.checkIdentifier(4);
        int expectedLen = this.readLength();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expectedLen; ++i) {
            sb.append((char)this.readByte());
        }
        return new OctetStringValue(sb.toString());
    }

    public ObjectIdentifierValue readObjectIdentifier() throws IOException {
        int y;
        int x;
        this.checkIdentifier(6);
        int len = this.readLength();
        StringBuilder sb = new StringBuilder();
        int total = 0;
        while (len-- > 0) {
            int b = this.readByte();
            total <<= 7;
            total += b & 0x7F;
            if ((b & 0x80) != 0) continue;
            break;
        }
        if (total < 40) {
            x = 0;
            y = total;
        } else if (total < 80) {
            x = 1;
            y = total - 40;
        } else {
            x = 2;
            y = total - 80;
        }
        sb.append(x);
        sb.append('.');
        sb.append(y);
        while (len > 0) {
            int val = 0;
            while (len-- > 0) {
                int b = this.readByte();
                val <<= 7;
                val += b & 0x7F;
                if ((b & 0x80) != 0) continue;
                break;
            }
            sb.append('.');
            sb.append(val);
        }
        return new ObjectIdentifierValue(sb.toString());
    }

    public IpAddressValue readIpAddress() throws IOException {
        this.checkIdentifier(64);
        int expectedLen = this.readLength();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expectedLen; ++i) {
            int b = this.readByte();
            if (b < 0 || b > 255) {
                throw new SnmpParsingException(L.l("IP address digit {0} out of range", b));
            }
            if (i != 0) {
                sb.append('.');
            }
            sb.append(b);
        }
        return new IpAddressValue(sb.toString());
    }

    public CounterValue readCounter() throws IOException {
        this.checkIdentifier(65);
        int expectedLen = this.readLength();
        long value = 0L;
        for (int i = 0; i < expectedLen; ++i) {
            value <<= 8;
            value |= (long)this.readByte();
        }
        return new CounterValue(value);
    }

    public GaugeValue readGauge() throws IOException {
        this.checkIdentifier(66);
        int expectedLen = this.readLength();
        long value = 0L;
        for (int i = 0; i < expectedLen; ++i) {
            value <<= 8;
            value |= (long)this.readByte();
        }
        return new GaugeValue(value);
    }

    public TimeTicksValue readTimeTicks() throws IOException {
        this.checkIdentifier(67);
        int expectedLen = this.readLength();
        long value = 0L;
        for (int i = 0; i < expectedLen; ++i) {
            value <<= 8;
            value |= (long)this.readByte();
        }
        return new TimeTicksValue(value);
    }

    public OpaqueValue readOpaque() throws IOException {
        this.checkIdentifier(68);
        int expectedLen = this.readLength();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expectedLen; ++i) {
            sb.append((char)this.readByte());
        }
        return new OpaqueValue(sb.toString());
    }

    public SequenceValue<SnmpValue> readSequence() throws IOException {
        int bytesRead;
        this.checkIdentifier(48);
        int expectedLen = this.readLength();
        SequenceValue<SnmpValue> sequence = new SequenceValue<SnmpValue>();
        for (bytesRead = 0; bytesRead < expectedLen; bytesRead += this.getBytesRead()) {
            bytesRead -= this.getBytesRead();
            SnmpValue item = this.read();
            sequence.add(item);
        }
        if (bytesRead != expectedLen) {
            throw new SnmpParsingException(L.l("expected sequence length {0} != {1}", expectedLen, bytesRead));
        }
        return sequence;
    }

    public int readLength() throws IOException {
        int octlet = this.readByte();
        if ((octlet & 0x80) == 0) {
            return octlet & 0x7F;
        }
        int numOfOctlets = octlet & 0x7F;
        int len = 0;
        for (int i = 0; i < numOfOctlets; ++i) {
            octlet = this.readByte();
            len <<= 8;
            len |= octlet;
        }
        return len;
    }

    private int readByte() throws IOException {
        ++this._bytesRead;
        int ch = this._is.read();
        if (ch < 0) {
            throw new SnmpParsingException("unexpected EOF");
        }
        return ch;
    }

    private int getBytesRead() {
        return this._bytesRead;
    }

    private void checkLength(int expected, int bytesRead) throws SnmpParsingException {
        if (expected != bytesRead) {
            throw new SnmpParsingException(L.l("expected length {0} != {1}", expected, bytesRead));
        }
    }

    private void checkIdentifier(int expected) throws IOException {
        if (this._isCheckIdentifier) {
            this.checkIdentifier(expected, this.readByte());
        }
        this._isCheckIdentifier = true;
    }

    private void checkIdentifier(int expected, int identifier) throws SnmpParsingException {
        if (expected != identifier) {
            throw new SnmpParsingException(L.l("saw '{0}' but expected type '{1}'", (Object)SnmpParser.type(identifier), SnmpParser.type(expected)));
        }
    }

    private static String type(int identifier) {
        return SnmpValue.typeName(identifier);
    }

    static class StringInputStream
    extends InputStream {
        private String _s;
        private int _len;
        private int _index;

        public StringInputStream(String s) {
            this._s = s;
            this._len = s.length();
        }

        public int read() throws IOException {
            if (this._index < this._len) {
                return this._s.charAt(this._index++);
            }
            return -1;
        }
    }
}

