/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.CauchoRequestWrapper;
import com.caucho.server.http.Form;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.HashMapImpl;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncRequest
extends CauchoRequestWrapper {
    private static final IntMap _asyncAttributeMap = new IntMap();
    private static final L10N L = new L10N(AsyncRequest.class);
    private static final int REQUEST_URI_CODE = 1;
    private static final int CONTEXT_PATH_CODE = 2;
    private static final int SERVLET_PATH_CODE = 3;
    private static final int PATH_INFO_CODE = 4;
    private static final int QUERY_STRING_CODE = 5;
    private Invocation _invocation;
    private HashMapImpl<String, String[]> _filledForm;

    public AsyncRequest(HttpServletRequestImpl request, HttpServletResponseImpl response, Invocation invocation) {
        super(request);
        this._invocation = invocation;
    }

    @Override
    protected Invocation getInvocation() {
        return this._invocation;
    }

    void startRequest() {
    }

    @Override
    public ServletContext getServletContext() {
        return this._invocation.getWebApp();
    }

    @Override
    public DispatcherType getDispatcherType() {
        return DispatcherType.ASYNC;
    }

    @Override
    public String getRequestURI() {
        return this._invocation.getURI();
    }

    @Override
    public String getContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getServletPath() {
        return this._invocation.getServletPath();
    }

    @Override
    public String getPathInfo() {
        return this._invocation.getPathInfo();
    }

    @Override
    public String getQueryString() {
        return this.calculateQueryString();
    }

    protected String calculateQueryString() {
        String queryString = this._invocation.getQueryString();
        if (queryString != null) {
            return queryString;
        }
        return this.getRequest().getQueryString();
    }

    @Override
    public String getPageURI() {
        return this._invocation.getURI();
    }

    @Override
    public String getPageContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getPageServletPath() {
        return this._invocation.getServletPath();
    }

    @Override
    public String getPagePathInfo() {
        return this._invocation.getPathInfo();
    }

    @Override
    public String getPageQueryString() {
        return this.getQueryString();
    }

    @Override
    public WebApp getWebApp() {
        return this._invocation.getWebApp();
    }

    @Override
    public boolean isAsyncSupported() {
        return this._invocation.isAsyncSupported() && this.getRequest().isAsyncSupported();
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException(L.l("The servlet '{0}' at '{1}' does not support async because the servlet or one of the filters does not support asynchronous mode.", (Object)this.getServletName(), this.getServletPath()));
        }
        return super.startAsync();
    }

    public String getServletName() {
        if (this._invocation != null) {
            return this._invocation.getServletName();
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        switch (_asyncAttributeMap.get(name)) {
            case 1: {
                return this.getRequest().getRequestURI();
            }
            case 2: {
                return this.getRequest().getContextPath();
            }
            case 3: {
                return this.getRequest().getServletPath();
            }
            case 4: {
                return this.getRequest().getPathInfo();
            }
            case 5: {
                return this.getRequest().getQueryString();
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.enumeration(this._filledForm.keySet());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.unmodifiableMap(this._filledForm);
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return this._filledForm.get(name);
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    private HashMapImpl<String, String[]> parseQuery() {
        String javaEncoding = Encoding.getJavaName(this.getCharacterEncoding());
        HashMapImpl<String, String[]> form = new HashMapImpl<String, String[]>();
        form.putAll(this.getRequest().getParameterMap());
        Form formParser = Form.allocate();
        try {
            String queryString = this._invocation.getQueryString();
            String oldQueryString = this.getRequest().getQueryString();
            if (queryString != null && !queryString.equals(oldQueryString)) {
                formParser.parseQueryString(form, queryString, javaEncoding, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return form;
    }

    static {
        _asyncAttributeMap.put("javax.servlet.async.request_uri", 1);
        _asyncAttributeMap.put("javax.servlet.async.context_path", 2);
        _asyncAttributeMap.put("javax.servlet.async.servlet_path", 3);
        _asyncAttributeMap.put("javax.servlet.async.path_info", 4);
        _asyncAttributeMap.put("javax.servlet.async.query_string", 5);
    }
}

